#import "ASR033WRfidValues.h"

@implementation ASR033WResultData{
    ASR033WResultCode mResult;
    NSData * mData;
}

- (id)initWithResultCode:(ASR033WResultCode)result data:(NSData *)data{
    self = [super init];
    mResult = result;
    mData = data;
    return self;
}

- (ASR033WResultCode)result{
    return mResult;
}

- (NSData *)data{
    return mData;
}
@end

@implementation ASR033WLockParam

- (int)value {
    return (_killPassword ? 16:0) + (_accessPassword ? 8:0) + (_epc ? 4:0) + (_tid ? 2:0) + (_user ? 1:0);
}

@end


@implementation ASR033WSelectMaskEPCParam

- (void)encodeWithCoder:(NSCoder *)aCoder{
    [aCoder encodeInt:self.offset forKey:@"offset"];
    [aCoder encodeInt:self.length forKey:@"length"];
    [aCoder encodeObject:self.mask forKey:@"mask"];
    
}
- (nullable instancetype)initWithCoder:(NSCoder *)aDecoder{
    if (self = [super init]) {
        self.offset = [aDecoder decodeIntForKey:@"offset"];
        self.length = [aDecoder decodeIntForKey:@"length"];
        self.mask   = [aDecoder decodeObjectForKey:@"mask"];
    }
    return self;
}

- (id)copyWithZone:(NSZone *)zone{
    ASR033WSelectMaskEPCParam *asSelectMaskEPCParam=[[[self class] allocWithZone:zone] init];
    asSelectMaskEPCParam.offset=self.offset;
    asSelectMaskEPCParam.length=self.length;
    asSelectMaskEPCParam.mask  =self.mask;
    return asSelectMaskEPCParam;
}
@end



@implementation ASR033WLbtItem

-(id)init {
    self = [super init];
    _mSlot = -1;
    _mIsUsed = NO;
    return self;
}

-(id)initWithSlot:(int)slot isUsed:(BOOL)isUsed  frequency:(NSString *)frequency {
    self = [super init];
    _mSlot = slot;
    _mIsUsed = isUsed;
    _frequency = frequency;
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder{
    [aCoder encodeInt:self.mSlot forKey:@"mSlot"];
    [aCoder encodeInt:self.mIsUsed forKey:@"mIsUsed"];
    [aCoder encodeObject:self.frequency forKey:@"frequency"];
    
}
- (nullable instancetype)initWithCoder:(NSCoder *)aDecoder{
    if (self = [super init]) {
        self.mSlot = [aDecoder decodeIntForKey:@"mSlot"];
        self.mIsUsed = [aDecoder decodeIntForKey:@"mIsUsed"];
        self.frequency   = [aDecoder decodeObjectForKey:@"frequency"];
    }
    return self;
}

- (id)copyWithZone:(NSZone *)zone{
    ASR033WLbtItem *lbtItem=[[[self class] allocWithZone:zone] init];
    lbtItem.mSlot=self.mSlot;
    lbtItem.mIsUsed=self.mIsUsed;
    lbtItem.frequency  =self.frequency;
    return lbtItem;
}
@end
