//
//  ASR033WPrinter.h
//  ASR033WSDK
//
//  Created by DS.Zhang on 2019/2/20.
//  Copyright © 2019年 Robin. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "ASR033WDefine.h"
#import "ASR033WNetworkTCP.h"
#import "ASR033W.h"

@protocol ASR033WPrinterDelegate <NSObject>
@optional
- (void)ASR033WPrinterStatus:(ASR033WPrinterStatus)printerStatus;
- (void)ASR033WPrinterConnected:(BOOL)isConnected;
- (BOOL)retryPrintOnError;
- (void)whenPrintSuccessed;
- (void)rxRawData:(NSData *)rxRawData;
@end
@interface ASR033WPrinter : NSObject
@property(nonatomic,assign,readonly)BOOL isConnected;
@property (nonatomic, weak) id<ASR033WPrinterDelegate> printDelegate;
-(id)initWithASR033W:(ASR033W *)asr033w;
-(void)getPrinterStatus;
-(void)addPrintText:(NSString*)text
               font:(ASR033WPrintFont)font
   printerAlignment:(ASR033WPrintAlignment)printerAlignment;
-(void)addPrintQRCode:(NSString*)qrCode
                 size:(ASR033WPrintQrDotSize)size
     printerAlignment:(ASR033WPrintAlignment)printerAlignment;
-(void)addPrintImage:(UIImage *)image
               width:(float)width
              height:(float)height
    printerAlignment:(ASR033WPrintAlignment)printerAlignment;
-(void)addCutCommand:(ASR033WPrintCutType)cutType;
-(void)openDrawer;//打开钱箱
-(void)cleanPrintData;
-(void)doPrint;
-(void)txRawData:(NSData *)txRawData;
@end
