//
//  ASR033WNetworkUDP.m
//  ASR033WSDK
//
//  Created by mac on 2020/10/29.
//

#import "ASR033WNetworkUDP.h"
#import "ASR033WReaderInfo.h"
#import "ASR033WGCDAsyncUdpSocket.h"
#import "ASR033WUtility.h"
@interface ASR033WNetworkUDP ()<ASR033WGCDAsyncUdpSocketDelegate>

@end
@implementation ASR033WNetworkUDP{
    ASR033WGCDAsyncUdpSocket *m_udpSocket;
    ASR033WReaderInfo *asr033wReaderInfo;
    NSMutableArray *arrInfo;
}
- (instancetype)init
{
    self = [super init];
    if (self) {
        arrInfo = [[NSMutableArray alloc]init];
    }
    return self;
}
- (ASR033WResultCode)searchDevice{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    [arrInfo removeAllObjects];
    m_udpSocket = [[ASR033WGCDAsyncUdpSocket alloc] initWithDelegate:self delegateQueue:dispatch_get_global_queue(0, 0)];
    NSError *error = nil;
    BOOL status = [m_udpSocket bindToPort:BIND_GROUP_PORT error:&error];
    if (!status || error) {
        return ASR033WResultOtherError;
    }
    status = [m_udpSocket enableBroadcast:YES error:&error];
    if (!status || error) {
        return ASR033WResultOtherError;
    }
    status = [m_udpSocket joinMulticastGroup:BIND_GROUP_IP error:&error];
    if (!status || error) {
        return ASR033WResultOtherError;
    }
    status = [m_udpSocket beginReceiving:&error];
    if (!status || error) {
        return ASR033WResultOtherError;
    }
    asr033wReaderInfo = [ASR033WReaderInfo sharedManager];
    NSTimeInterval stopTime = 0.0;
    if (asr033wReaderInfo.searchTimeout) {
        stopTime = [ASR033WUtility formatInputValue:asr033wReaderInfo.searchTimeout maxValue:60 minValue:10];
    } else {
        stopTime = 10;
    }
    [self performSelector:@selector(finshSearchDeivce) withObject:nil afterDelay:stopTime];
    return ASR033WResultNoError;
}
- (ASR033WResultCode)stopSearch{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(finshSearchDeivce) object:nil];
    [m_udpSocket close];
    return ASR033WResultNoError;
}
- (void)finshSearchDeivce{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    [self stopSearch];
    if([_delegate respondsToSelector:@selector(onSearchingUDPReceiveInformation:isFinish:)]){
        [self.delegate onSearchingUDPReceiveInformation:nil isFinish:YES];
    }
    if([_delegate respondsToSelector:@selector(onSearchingDeviceInfoReceive:)]){
        [self.delegate onSearchingDeviceInfoReceive:arrInfo];
    }
}
//GCDAsyncUdpSocketDelegate
- (void)udpSocket:(ASR033WGCDAsyncUdpSocket *)sock didReceiveData:(NSData *)data fromAddress:(NSData *)address withFilterContext:(id)filterContext {
    @try {
        NSString *str = [[NSString alloc] initWithData:data encoding:NSASCIIStringEncoding];
        if (str.length > 0) {
            NSArray *array = [str componentsSeparatedByString:@","];
            NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
            for (NSString *string in array) {
                NSArray *newArray = [string componentsSeparatedByString:@":"];
                if (newArray.count == 2) {
                    NSString *string = [newArray firstObject];
                    if ([string containsString:SEARCH_RFID_READER_INFORMATION]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_RFID_READER_INFORMATION];
                    }
                    if ([string containsString:SEARCH_IP]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_IP];
                    }
                    if ([string containsString:SEARCH_MASK]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_MASK];
                    }
                    if ([string containsString:SEARCH_GATEWAY]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_GATEWAY];
                    }
                    if ([string containsString:SEARCH_MAC]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_MAC];
                    }
                    if ([string containsString:SEARCH_PORT]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_PORT];
                    }
                    if ([string containsString:SEARCH_HOST_SERVER_IP]) {
                        NSString *ipString = [newArray lastObject];
                        if ([ipString containsString:@"\r\n"]) {
                            ipString = [ipString stringByReplacingOccurrencesOfString:@"\r\n" withString:@""];
                        }
                        [dic setValue:ipString forKey:SEARCH_HOST_SERVER_IP];
                    }
                    if ([string containsString:SEARCH_HOST_SERVER_PORT]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_HOST_SERVER_PORT];
                    }
                    if ([string containsString:SEARCH_MODE]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_MODE];
                    }
                    if ([string containsString:SEARCH_NET_STATE]) {
                        [dic setValue:[newArray lastObject] forKey:SEARCH_NET_STATE];
                    }
                    if ([string containsString:SEARCH_DHCP_SW]) {
                        NSString *dhcp = [newArray lastObject];
                        if ([dhcp containsString:@"\r\n$"]) {
                            dhcp = [dhcp stringByReplacingOccurrencesOfString:@"\r\n$" withString:@""];
                        }
                        [dic setValue:dhcp forKey:SEARCH_DHCP_SW];
                    }
                }
            }
            if ([_delegate respondsToSelector:@selector(onSearchingUDPReceiveInformation:isFinish:)]){
                [self.delegate onSearchingUDPReceiveInformation:dic isFinish:NO];
            }
            if (![arrInfo containsObject:dic]) {
                [arrInfo addObject:dic];
            }
        }
    } @catch (NSException *exception) {
        
    } @finally {
        
    }
}
- (void)udpSocketDidClose:(ASR033WGCDAsyncUdpSocket *)sock withError:(NSError  * _Nullable)error {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s : %@",__PRETTY_FUNCTION__,error]];
}
@end
