#import "ASR033WNetworkTCP.h"
#import <CFNetwork/CFNetwork.h>
#include <sys/socket.h>
#include <netinet/in.h>
#import "ASR033WUtility.h"

@implementation ASR033WNetworkTCP{
    CFStringRef    host;
    int            port;
    NSInputStream *instream;
    NSOutputStream *outstream;
    NSMutableData *rxData;
    NSString       *connectIP;
}

- (instancetype)init{
    self = [super init];
    if (self) {
        host = nil;
        port = 0;
        instream = nil;
        outstream = nil;
    }
    return self;
}
- (void)reconnect{
    [self connect:connectIP port:port];
}

- (void)connect:(NSString*)ip port:(int)remoteport{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s IP = %@ port = %d",__PRETTY_FUNCTION__, ip, remoteport]];
    if (ip != nil && ![@"" isEqualToString:ip]) {
        connectIP = ip;
        if(_isConnected != NO){
            [self disconnect];
            [NSThread sleepForTimeInterval:1.0];
        }else{
            [self clossStream];
            [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s %d clossStream",__FUNCTION__ , __LINE__]];
        }
        
        host = CFStringCreateWithCString(kCFAllocatorDefault, [ip UTF8String], NSUnicodeStringEncoding);
        port = remoteport;
        
        CFReadStreamRef		readStream = NULL;
        CFWriteStreamRef	writeStream = NULL;
        CFStreamCreatePairWithSocketToHost(kCFAllocatorDefault, host, port,  &readStream, &writeStream);
        instream = (__bridge_transfer NSInputStream *)readStream;
        outstream =(__bridge_transfer NSOutputStream *)writeStream;
        [instream setDelegate:self];
        [outstream setDelegate:self];
        [instream scheduleInRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
        [outstream scheduleInRunLoop:[NSRunLoop currentRunLoop] forMode:NSRunLoopCommonModes];
        [instream open];
        [outstream open];
    } else {
        [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s %d ip is nil",__FUNCTION__ , __LINE__]];
        if (self.delegate && [self.delegate respondsToSelector:@selector(onTCPErrorReceive:)]) {
            NSDictionary *dic = [NSDictionary dictionaryWithObject:@"IP is nil" forKey:NSLocalizedFailureReasonErrorKey];
            NSError *error = [[NSError alloc] initWithDomain:NSCocoaErrorDomain code:0 userInfo:dic];
            [self.delegate onTCPErrorReceive:error];
        }
    }
}


-(void) sendData:(NSData *)data{
    uint8_t *pData = (uint8_t*)[data bytes];
    if ([outstream streamStatus] == NSStreamStatusOpen ||
        [outstream streamStatus] == NSStreamStatusReading ||
        [outstream streamStatus] == NSStreamStatusWriting) {
        [ASR033WUtility writeLog:[NSString stringWithFormat:@"TX : %@", [ASR033WUtility getHexString:data]]];
        [outstream write:pData maxLength:data.length];
        return;
    } else {
        [self disconnect];
    }
}

- (void)disconnect{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if( _isConnected ){
        _isConnected = NO;
        [self clossStream];
        if(self.delegate && [self.delegate respondsToSelector:@selector(onTCPDisconnect)]){
            [_delegate onTCPDisconnect];
        }
    }
}

- (void)clossStream{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s %d",__FUNCTION__ , __LINE__]];
    if(instream) {
        [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s %d instream close",__FUNCTION__ , __LINE__]];
        [instream removeFromRunLoop:[NSRunLoop currentRunLoop] forMode:NSDefaultRunLoopMode];
        [instream setDelegate:nil];
        [instream close];
        instream = nil;
    }
    if(outstream) {
        [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s %d outstream close",__FUNCTION__ , __LINE__]];
        [outstream removeFromRunLoop:[NSRunLoop currentRunLoop] forMode:NSDefaultRunLoopMode];
        [outstream setDelegate:nil];
        [outstream close];
        outstream = nil;
    }
}

- (void)stream:(NSStream *)aStream handleEvent:(NSStreamEvent)eventCode{
    switch(eventCode) {
        case NSStreamEventOpenCompleted:
            [self streamOpenCompleted:aStream];
            break;
        case NSStreamEventHasBytesAvailable:
            @synchronized(self) {
                [self OnHasRead];
            }
            break;
        case NSStreamEventHasSpaceAvailable:
            [self OnHasWrite];
            break;
        case NSStreamEventErrorOccurred:
            [self OnError:aStream];
            break;
        case NSStreamEventEndEncountered:
            [self disconnect];
            break;
        default:
		      break;
    }
}


- (void)streamOpenCompleted:(NSStream *)stream{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if ([stream isEqual:instream]) {
        _isConnected = YES;
        if(self.delegate && [self.delegate respondsToSelector:@selector(onTCPConnected)]){
            [_delegate onTCPConnected];
        }
    }
}

-(void) OnHasRead{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    #define EAD_INPUT_BUFFER_SIZE 2048
    uint8_t buf[EAD_INPUT_BUFFER_SIZE];
    while ([instream hasBytesAvailable]){
        NSInteger bytesRead = [instream read:buf maxLength:EAD_INPUT_BUFFER_SIZE];
        if (rxData == nil){
            rxData = [[NSMutableData alloc] init];
        }
        if (bytesRead >= 0) {
            [rxData appendBytes:(void *)buf length:bytesRead];
        }else{
            NSLog(@" bytesRead = %ld",(long)bytesRead);
        }
    }
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"RX : %@", [ASR033WUtility getHexString:rxData]]];
    if(self.delegate && [self.delegate respondsToSelector:@selector(onTCPReceive:)]){
        if (rxData.length != 0) {
            [self.delegate onTCPReceive:[rxData copy]];
        }
    }
    [rxData setLength:0];
}

-(void) OnHasWrite{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
}

-(void) OnError:(NSStream *)stream {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if ([stream isEqual:instream]) {
        NSError *error = stream.streamError;
        if( error ) {
            [self clossStream];
            if( _isConnected ){
                _isConnected = NO;
            }
            if(self.delegate && [self.delegate respondsToSelector:@selector(onTCPErrorReceive:)]){
                [self.delegate onTCPErrorReceive:error];
            }
        }
    }
}
@end
