//
//  ASR033WNetworkMQTT.m
//
//  Created by iOS on 15.4.22.
//

#import "ASR033WNetworkMQTT.h"
#import "ASR033WUtility.h"
#import "MQTTSessionManager.h"

@interface ASR033WNetworkMQTT ()<MQTTSessionManagerDelegate>
@property (strong, nonatomic)  MQTTSessionManager * manager;
@end

@implementation ASR033WNetworkMQTT
{
    NSMutableDictionary *_dic;
}
- (BOOL)isConnected{
    if (!self.manager) {
        return NO;
    }
    if (self.manager.state == MQTTSessionManagerStateConnected) {
        return YES;
    }
    return NO;
}
- (void)subscriptions:(ASR033WNetworkMQTTSubscriptions)subscriptions status:(BOOL)status{
    if (subscriptions == ASR033WNetworkMQTTSubscriptions_SERIAL) {
        if (status) {
            [_dic setValue:[NSNumber numberWithInt:MQTTQosLevelExactlyOnce] forKey:@"HEX_OUT"];
        } else {
            if([_dic.allKeys containsObject:@"HEX_OUT"]) {
                [_dic removeObjectForKey:@"HEX_OUT"];
            }
        }
    } else if (subscriptions == ASR033WNetworkMQTTSubscriptions_MQTT_HID){
        if (status) {
            [_dic setValue:[NSNumber numberWithInt:MQTTQosLevelExactlyOnce] forKey:@"HID_OUT"];
        } else {
            if([_dic.allKeys containsObject:@"HID_OUT"]) {
                [_dic removeObjectForKey:@"HID_OUT"];
            }
        }
    } else {
        [_dic setValue:[NSNumber numberWithInt:MQTTQosLevelExactlyOnce] forKey:@"CHG_STAT"];
    }
    self.manager.subscriptions = _dic;
}
- (BOOL)connectedWithIP:(NSString *)ip port:(int)port{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s ip = [%@] port = [%d]",__PRETTY_FUNCTION__,ip,port]];
    _dic = [[NSMutableDictionary alloc] init];
    if (!ip || [ip isEqualToString:@""] || port < 0) {
        return NO;
    }

    dispatch_queue_t queue = dispatch_queue_create("ASR033WNetworkMQTT", DISPATCH_QUEUE_SERIAL);
    self.manager = [[MQTTSessionManager alloc] initWithPersistence:MQTT_PERSISTENT
                       maxWindowSize:MQTT_MAX_WINDOW_SIZE
                         maxMessages:MQTT_MAX_MESSAGES
                             maxSize:MQTT_MAX_SIZE
          maxConnectionRetryInterval:64.0
                 connectInForeground:YES
                      streamSSLLevel:(NSString *)kCFStreamSocketSecurityLevelNegotiatedSSL
                               queue:queue];
    self.manager.delegate = self;
    [self.manager connectTo:ip
                       port:port
                        tls:NO
                  keepalive:60
                      clean:true
                       auth:NO
                       user:nil
                       pass:nil
                       will:NO
                  willTopic:nil
                    willMsg:nil
                    willQos:MQTTQosLevelAtMostOnce
             willRetainFlag:NO
               withClientId:nil
             securityPolicy:nil
               certificates:nil
              protocolLevel:MQTTProtocolVersion311
             connectHandler:^(NSError *error) {
        if (error) {
            NSLog(@"==========连接  failed %@", error.localizedDescription);
            [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s error = [%@]",__PRETTY_FUNCTION__,error]];
//            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTErrorReceive:)]){
//                [self.delegate onMQTTErrorReceive:error];
//            }
        } else {
            NSLog(@"==========连接  sucessfull!");
            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTConnected)]){
                [self.delegate onMQTTConnected];
            }
        }
    }];
    return YES;
}
- (void)reconnect{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (!self.manager || self.manager.state == MQTTSessionStatusConnected) {
        return;
    }
    [self.manager connectToLast:^(NSError *error) {
        if (error) {
            NSLog(@"==========连接  failed %@", error.localizedDescription);
            [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s error = [%@]",__PRETTY_FUNCTION__,error]];
//            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTErrorReceive:)]){
//                [self.delegate onMQTTErrorReceive:error];
//            }
        } else {
            NSLog(@"==========连接  sucessfull!");
            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTConnected)]){
                [self.delegate onMQTTConnected];
            }
        }
    }];
}
- (BOOL)disConnect{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (!self.manager) {
        return NO;
    }
    [self.manager disconnectWithDisconnectHandler:^(NSError *error) {
        if (error) {
            NSLog(@"==========断开  failed %@", error.localizedDescription);
            [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s error = [%@]",__PRETTY_FUNCTION__,error]];
//            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTErrorReceive:)]){
//                [self.delegate onMQTTErrorReceive:error];
//            }
        } else {
            NSLog(@"==========断开  sucessfull!");
            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTDisconnect)]){
                [self.delegate onMQTTDisconnect];
            }
        }
    }];
    return YES;
}
- (BOOL)sendGPIOData:(NSData *)data{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s data = [%@]",__PRETTY_FUNCTION__,[ASR033WUtility dataToString:data]]];
    if (!self.manager) {
        return NO;
    }
    [self.manager sendData:data topic:@"GPIO_INPUT" qos:MQTTQosLevelExactlyOnce retain:NO];
    return YES;
}
- (BOOL)sendHIDORRFIDData:(NSData *)data{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s data = [%@]",__PRETTY_FUNCTION__,[ASR033WUtility dataToString:data]]];
    if (!self.manager) {
        return NO;
    }
    [self.manager sendData:data topic:@"HEX_IN" qos:MQTTQosLevelExactlyOnce retain:NO];
    return YES;
}
#pragma ---MQTTSessionManagerDelegate---
//返回读取到数据
- (void)handleMessage:(NSData *)data onTopic:(NSString *)topic retained:(BOOL)retained{
    NSLog(@"==========%s %d data =  %@ topic = %@",__FUNCTION__,__LINE__,data,topic);
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s data = [%@] topic = [%@]",__PRETTY_FUNCTION__,[ASR033WUtility dataToString:data],topic]];
    if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTReceive:)]){
        if (data.length != 0) {
            [self.delegate onMQTTReceive:[data copy]];
        }
    }
}

/** gets called when a new message was received
 @param sessionManager the instance of MQTTSessionManager whose state changed
 @param data the data received, might be zero length
 @param topic the topic the data was published to
 @param retained indicates if the data retransmitted from server storage
 */
- (void)sessionManager:(MQTTSessionManager *)sessionManager
     didReceiveMessage:(NSData *)data
               onTopic:(NSString *)topic
              retained:(BOOL)retained{
    NSLog(@"==========%s %d didReceiveMessage  = %@ topic = %@",__FUNCTION__,__LINE__,data,topic);
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s data = [%@] topic = [%@]",__PRETTY_FUNCTION__,[ASR033WUtility dataToString:data],topic]];
}

/** gets called when a published message was actually delivered
 @param msgID the Message Identifier of the delivered message
 @note this method is called after a publish with qos 1 or 2 only
 */
- (void)messageDelivered:(UInt16)msgID{
    NSLog(@"==========%s %d msgID = %d",__FUNCTION__,__LINE__,msgID);
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s msgID = [%d]",__PRETTY_FUNCTION__,msgID]];
}

/** gets called when a published message was actually delivered
 @param sessionManager the instance of MQTTSessionManager whose state changed
 @param msgID the Message Identifier of the delivered message
 @note this method is called after a publish with qos 1 or 2 only
 */
- (void)sessionManager:(MQTTSessionManager *)sessionManager didDeliverMessage:(UInt16)msgID{
    NSLog(@"==========%s %d msgID = %d",__FUNCTION__,__LINE__,msgID);
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s msgID = [%d]",__PRETTY_FUNCTION__,msgID]];
}

//返回连接状态
- (void)sessionManager:(MQTTSessionManager *)sessionManager didChangeState:(MQTTSessionManagerState)newState{
    NSLog(@"==========%s %d  newState = %d",__FUNCTION__,__LINE__ ,newState);
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s newState = [%d]",__PRETTY_FUNCTION__,newState]];
    switch (newState) {
        case MQTTSessionManagerStateStarting:

            break;
        case MQTTSessionManagerStateConnecting:

            break;
        case MQTTSessionManagerStateConnected:

            break;
        case MQTTSessionManagerStateError:{
            NSError * e = sessionManager.lastErrorCode;
            NSLog(@"==========%@",e);
            
            [self.manager disconnectWithDisconnectHandler:^(NSError *error) {
                NSLog(@"断开连接  error = %@",[error description]);
            }];
            if(self.delegate && [self.delegate respondsToSelector:@selector(onMQTTErrorReceive:)]){
                [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s error = [%@]",__PRETTY_FUNCTION__,e]];
                [self.delegate onMQTTErrorReceive:sessionManager.lastErrorCode];
            }
        }
            break;
        case MQTTSessionManagerStateClosing:

            break;
        case MQTTSessionManagerStateClosed:

            break;
        default:
            break;
    }
}

@end
