//
//  ASR033W.m
//  ASR033WSDK
//
//  Created by MRX_ZYL on 13/10/2020.
//

#import "ASR033W.h"
#import "ASR033WNetworkTCP.h"
#import "ASR033WNetworkUDP.h"
#import "ASR033WNetworkMQTT.h"
#import "ASR033WUtility.h"
#import "ASR033WReaderInfo.h"
#import "ASR033WPrinter.h"

@interface ASR033W()<ASR033WNetworkTCPDelegate, ASR033WNetworkUDPDelegate, ASR033WNetworkMQTTDelegate>
@property(nonatomic, assign) id<ASR033WDelegate> asr033WDelegate;
@end

@implementation ASR033W{
    ASR033WNetworkTCP *asr033wNetworkTCP;
    ASR033WNetworkUDP *asr033wNetworkUDP;
    ASR033WNetworkMQTT *asr033wNetworkMQTT;
    ASR033WProtocol   *asr033wProtocol;
    NSMutableData    *writeData;
    ASR033WReaderInfo *asr033wReaderInfo;
    ASR033WCommandType mAction;
}
#pragma mark  ---ASR033W SDK METHOD---
static ASR033W *asr033w;
+ (ASR033W *)sharedInstance{
    if (!asr033w) {
        asr033w = [[ASR033W alloc] init];
    }
    return asr033w;
}
- (instancetype)init{
    self = [super init];
    if (self) {
        asr033wNetworkTCP = [[ASR033WNetworkTCP alloc] init];
        asr033wNetworkTCP.delegate = self;
        asr033wNetworkUDP = [[ASR033WNetworkUDP alloc] init];
        asr033wNetworkUDP.delegate = self;
        asr033wNetworkMQTT = [[ASR033WNetworkMQTT alloc] init];
        asr033wNetworkMQTT.delegate = self;
        _isConnected = NO;
        asr033wProtocol = [[ASR033WProtocol alloc] initWithASR033W:self asr033WNetworkMqtt:asr033wNetworkMQTT tcp:asr033wNetworkTCP];
        asr033wReaderInfo = [ASR033WReaderInfo sharedManager];
    }
    return self;
}
- (ASR033WPrinter *)getASR033WPrinter{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    ASR033WPrinter *asr033wPrinter = [[ASR033WPrinter alloc] initWithASR033W:self];
    return asr033wPrinter;
}
- (void)setDelegate:(id<ASR033WDelegate>)delegate{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    self.asr033WDelegate = delegate;
    asr033wProtocol.delegate = delegate;
}
- (NSString *)getSDKVersion{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    return ASR033W_VERSION_NO;
}
- (void)setConnectMethod:(ASR033WConnectMethod)connectMethod {
    _connectMethod = connectMethod;
    asr033wProtocol.connectMethod = connectMethod;
}
- (void)setSearchDeviceTimeout:(NSTimeInterval)timeout{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    timeout = [ASR033WUtility formatInputValue:timeout maxValue:60 minValue:0];
    asr033wReaderInfo.searchTimeout = timeout;
}
- (ASR033WResultCode)startSearchDevice{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (_connectMethod == ASR033WConnectMethod_TCP) {
        [asr033wNetworkTCP disconnect];
    } else {
        [asr033wNetworkMQTT disConnect];
    }
    return [asr033wNetworkUDP searchDevice];
}
- (ASR033WResultCode)stopSearchDevice{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    return [asr033wNetworkUDP stopSearch];
}
- (ASR033WResultCode)connectServerWithIP:(NSString *)IP remoteport:(int)port{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    [self stopSearchDevice];
    if(IP == nil || [@"" isEqualToString:IP]){
        return ASR033WResultOtherError;
    } else {
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            self->_host = IP;
            if (self.connectMethod == ASR033WConnectMethod_TCP) {
                [self->asr033wNetworkTCP connect:IP port:port];
            } else {
                [self->asr033wNetworkMQTT connectedWithIP:IP port:port];
            }
        }];
    }
    return ASR033WResultNoError;
}
- (ASR033WResultCode)disconnectServer{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (self.connectMethod == ASR033WConnectMethod_TCP) {
        if (asr033wNetworkTCP != nil) {
            [asr033wNetworkTCP disconnect];
        }
    } else {
        if (asr033wNetworkMQTT != nil) {
            [asr033wNetworkMQTT disConnect];
        }
    }
    return ASR033WResultNoError;
}
- (BOOL)startReceiveRFIDData{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(50 * NSEC_PER_MSEC)), dispatch_get_main_queue(), ^{
        if (self.connectMethod == ASR033WConnectMethod_TCP) {
            Byte param[] = {0xC0,0x00,0x00,0x00,0x00,0x01};
            [self->asr033wProtocol sendCommand:[NSData dataWithBytes:param length:sizeof(param)]];
        } else {
            if (self->asr033wNetworkMQTT != nil) {
                [self->asr033wNetworkMQTT subscriptions:ASR033WNetworkMQTTSubscriptions_SERIAL status:YES];
            }
        }
    });
    return YES;
}
- (BOOL)stopReceiveRFIDData{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(50 * NSEC_PER_MSEC)), dispatch_get_main_queue(), ^{
        if (self.connectMethod == ASR033WConnectMethod_TCP) {
            Byte param[] = {0xC0,0x00,0x00,0x00,0x00,0x02};
            [self->asr033wProtocol sendCommand:[NSData dataWithBytes:param length:sizeof(param)]];
        } else {
            if (self->asr033wNetworkMQTT != nil) {
                [self->asr033wNetworkMQTT subscriptions:ASR033WNetworkMQTTSubscriptions_SERIAL status:NO];
            }
        }
    });
    return YES;
}
- (BOOL)startReceiveHIDData {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(50 * NSEC_PER_MSEC)), dispatch_get_main_queue(), ^{
        if (self.connectMethod == ASR033WConnectMethod_TCP) {
            Byte param[] = {0xC0,0x00,0x00,0x00,0x00,0x03};
            [self->asr033wProtocol sendCommand:[NSData dataWithBytes:param length:sizeof(param)]];
        } else {
            if (self->asr033wNetworkMQTT != nil) {
                [self->asr033wNetworkMQTT subscriptions:ASR033WNetworkMQTTSubscriptions_MQTT_HID status:YES];
            }
        }
    });
    return YES;
}
- (BOOL)stopReceiveHIDData {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(50 * NSEC_PER_MSEC)), dispatch_get_main_queue(), ^{
        if (self.connectMethod == ASR033WConnectMethod_TCP) {
            Byte param[] = {0xC0,0x00,0x00,0x00,0x00,0x04};
            [self->asr033wProtocol sendCommand:[NSData dataWithBytes:param length:sizeof(param)]];
        } else {
            if (self->asr033wNetworkMQTT != nil) {
                [self->asr033wNetworkMQTT subscriptions:ASR033WNetworkMQTTSubscriptions_MQTT_HID status:NO];
            }
        }
    });
    return YES;
}
- (ASR033WResultCode)startInventoryWithAntenna1:(BOOL)antenna1
                                       antenna2:(BOOL)antenna2
                                       antenna3:(BOOL)antenna3
                                       antenna4:(BOOL)antenna4
                                       antenna5:(BOOL)antenna5
                                       antenna6:(BOOL)antenna6
                                       antenna7:(BOOL)antenna7
                                       antenna8:(BOOL)antenna8
                                            TID:(BOOL)TID{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    Byte param[] = {0x0b,0x01,0x00,0x00,0x00,0x00,0x00};
    if (TID) {
        param[0] = 0xB0;
    } else {
        param[0] = 0xC0;
    }
    param[1] = 0x01;
    param[2] = (antenna1 + antenna2 * 2 + antenna3 * 4 + antenna4 * 8 + antenna5 * 16 + antenna6 * 32 + antenna7 * 64 + antenna8 * 128)&0xFF;
    return [asr033wProtocol command:ASR033WCommandInventory withParameterData:[NSData dataWithBytes:param length:sizeof(param)]];
}
- (ASR033WResultCode)stopInventory {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    return [asr033wProtocol command:ASR033WCommandStop withParameter:@""];
}
- (NSString *)regionName{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [asr033wProtocol getProperty:ASR033WPropertyRegion withParameter:@""];
    if ([value isEqual:@""]) {
        return value;
    }
    NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
    [dic setValue:@"GB"            forKey:@"0"];
    [dic setValue:@"GB1"           forKey:@"1"];
    [dic setValue:@"GB2"           forKey:@"2"];
    [dic setValue:@"North America" forKey:@"3"];
    [dic setValue:@"Europe"        forKey:@"4"];
    [dic setValue:@"Japan250mW"    forKey:@"5"];
    [dic setValue:@"TEST"          forKey:@"9"];
    [dic setValue:@"Japan(1W)"     forKey:@"10"];
    [dic setValue:@"Australia"     forKey:@"11"];
    [dic setValue:@"Japan(200mW)"  forKey:@"16"];

    for (NSString * str in [dic allKeys]) {
        if ([str isEqualToString:value]) {
            value = [dic valueForKey:str];
        }
    }
    return value;
}
- (NSString *)serialNumber {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *serialValue = [asr033wProtocol getProperty:ASR033WPropertySerialNo withParameter:@""];
    if ([serialValue isEqual:@""]) {
        return @"";
    }
    return serialValue;
}
- (NSString *)hardwareVersion{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *hardwareVersion = [asr033wProtocol getProperty:ASR033WPropertyHardwareVersion withParameter:@""];
    if ([hardwareVersion isEqual:@""]) {
        return hardwareVersion;
    }
    return hardwareVersion;
}
- (NSString *)rFModuleVersion{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *uhfVersion = [asr033wProtocol getProperty:ASR033WPropertyUHFVersion withParameter:@""];
    if ([uhfVersion isEqual:@""]) {
        return uhfVersion;
    }
    return uhfVersion;
}
- (NSString *)firmwareVersion {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *firmwareVersion = [asr033wProtocol getProperty:ASR033WPropertyFirmwareVersion withParameter:@""];
    if ([firmwareVersion isEqual:@""]) {
        return firmwareVersion;
    }
    return firmwareVersion;
}
- (NSString *)macAddress {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *macAddress = [asr033wProtocol getProperty:ASR033WPropertyMacAddress withParameter:@""];
    if ([macAddress isEqual:@""]) {
        return macAddress;
    }
    return macAddress;
}
- (NSString *)getMessageWithASR033WResultCode:(ASR033WResultCode)code {
    switch (code) {
        case ASR033WResultNoError:
            return @"No Error";
        case ASR033WResultOtherError:
            return @"Other Error";
        case ASR033WResultUndefined:
            return @"Undefined";
        case ASR033WResultMemoryOverrun:
            return @"Memory Overrun";
        case ASR033WResultMemoryLocked:
            return @"Memory Locked";
        case ASR033WResultInsufficientPower:
            return @"Insufficient Power";
        case ASR033WResultNotConnected:
            return @"Disconnected";
        case ASR033WResultInvalidParameter:
            return @"Invalid parameter";
        case ASR033WResultTimeout:
            return @"Timeout";
        case ASR033WResultOutOfRetries:
            return @"Out of retries";
        case ASR033WResultReadLabelIsUnresponsive:
            return @"The label is unresponsive";
        case ASR033WResultReadCRCError:
            return @"CRC error";
        case ASR033WResultReadDataAreaIsLocked:
            return @"Memory Locked";
        case ASR033WResultReadDataAreaOverflow:
            return @"Memory Overrun";
        case ASR033WResultReadIncorrectAccessPassword:
            return @"Incorrect password";
        case ASR033WResultReadOtherLabelsAreIncorrect:
            return @"Other labels are incorrect";
        case ASR033WResultReadReaderWriterErrors:
            return @"Reader/writer error";
        case ASR033WResultWriteAntennaPortParameterError:
            return @"Write antenna port parameter error";
        case ASR033WResultWriteSelectionParameterError:
            return @"Write selection parameter error";
        case ASR033WResultWriteWritingParameterError:
            return @"Write writing parameter error";
        case ASR033WResultWriteCRCCheckError:
            return @"Write CRC error on tag response";
        case ASR033WResultWriteInsufficientPower:
            return @"Write insufficient power";
        case ASR033WResultWriteMemoryOverrun:
            return @"Memory Overrun";
        case ASR033WResultWriteMemoryLocked:
            return @"Memory locked";
        case ASR033WResultWriteIncorrectAccessPassword:
            return @"Incorrect password";
        case ASR033WResultWriteOtherLabelError:
            return @"Write other label error";
        case ASR033WResultWriteLabelLoss:
            return @"Write label loss";
        case ASR033WResultWriteSendingInstructionError:
            return @"Write sending instruction error";
        case ASR033WResultLockAntennaPortParameterError:
            return @"Lock antenna port parameter error";
        case ASR033WResultLockSelectionParameterError:
            return @"Lock selection parameter error";
        case ASR033WResultLockLockingParameterError:
            return @"Lock locking parameter error";
        case ASR033WResultLockCRCCheckError:
            return @"Lock CRC error on tag response";
        case ASR033WResultLockInsufficientPower:
            return @"Lock insufficient power";
        case ASR033WResultLockMemoryOverrun:
            return @"Memory Overrun";
        case ASR033WResultLockMemoryLocked:
            return @"Memory Locked";
        case ASR033WResultLockIncorrectAccessPassword:
            return @"Incorrect password";
        case ASR033WResultLockOtherLabelError:
            return @"Lock other label error";
        case ASR033WResultLockLabelLoss:
            return @"Lock label loss";
        case ASR033WResultLockSendingInstructionError:
            return @"Lock sending instruction error";
        case ASR033WResultKillAntennaPortParameterError:
            return @"Kill antenna port parameter error";
        case ASR033WResultKillSelectionParameterError:
            return @"Kill selection parameter error";
        case ASR033WResultKillCRCCheckError:
            return @"Kill CRC error on tag response";
        case ASR033WResultKillInsufficientPower:
            return @"Kill insufficient power";
        case ASR033WResultKillIncorrectAccessPassword:
            return @"Incorrect password";
        case ASR033WResultKillOtherLabelError:
            return @"Kill other label error";
        case ASR033WResultKillLabelLoss:
            return @"Kill label loss";
        case ASR033WResultKillSendingInstructionError:
            return @"Kill sending instruction error";
        default:
            return @"Unknown Error";
    }
}
- (ASR033WResultCode)readMemory:(ASR033WMemoryBank)bank
                         offset:(int)offset
                         length:(int)length
                            epc:(NSData *)epc
                             pc:(NSData *)pc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8 {
    unsigned int accessPassword = password;
    unsigned short epcLength = epc.length;
    unsigned char *newEPC = (unsigned char*)epc.bytes;
    
    unsigned short pcLength = pc.length;
    unsigned char *newPC = (unsigned char*)pc.bytes;
    
    unsigned char memoryBank = bank;
    unsigned short startAddress = offset;
    unsigned short dataLength = length;
    
    unsigned char len = 0;
    unsigned char param[255];
    
   
    param[len++] = (antenna1 + antenna2 * 2 + antenna3 * 4 + antenna4 * 8 + antenna5 * 16 + antenna6 * 32 + antenna7 * 64 + antenna8 * 128)&0xFF;
    
    param[len++] = (epcLength >> 8) & 0xFF;
    param[len++] = (epcLength & 0xFF);
    
    for (int i = 0; i < epcLength; i++) {
        param[len++] = newEPC[i];
    }
    
    for (int i = 0; i < pcLength; i++) {
        param[len++] = newPC[i];
    }
    
    param[len++] = 0x00;
    param[len++] = 0x20;

    param[len++] = epcLength * 8;
    
    param[len++] = memoryBank;
    
    param[len++] = (startAddress >> 8) & 0xFF;
    param[len++] = (startAddress & 0xFF);
    
    param[len++] = (dataLength & 0xFF);
    
    param[len++] = (accessPassword >> 24) & 0xFF;
    param[len++] = (accessPassword >> 16) & 0xFF;
    param[len++] = (accessPassword >> 8) & 0xFF;
    param[len++] = (accessPassword & 0xFF);
    
    return [asr033wProtocol command:ASR033WCommandReadMemory withParameterData:[NSData dataWithBytes:param length:len]];
}

- (ASR033WResultCode)writeMemory:(ASR033WMemoryBank)bank
                          offset:(int)offset
                          length:(int)length
                       writeData:(NSData *)writeData
                             epc:(NSData *)epc
                              cw:(BOOL)cw
                        password:(int)password
                        antenna1:(BOOL)antenna1
                        antenna2:(BOOL)antenna2
                        antenna3:(BOOL)antenna3
                        antenna4:(BOOL)antenna4
                        antenna5:(BOOL)antenna5
                        antenna6:(BOOL)antenna6
                        antenna7:(BOOL)antenna7
                        antenna8:(BOOL)antenna8 {
    unsigned int accessPassword = password;
    unsigned short epccLength = epc.length;
    unsigned char *epcData = (unsigned char*)epc.bytes;

    unsigned short writeDataLength = writeData.length;
    unsigned char *writeeData = (unsigned char*)writeData.bytes;
    unsigned short startAddress = offset;
    unsigned short dataLength = length;
    unsigned char memoryBank = bank;

    unsigned char len = 0;
    unsigned char param[255];
    
   
    param[len++] = (antenna1 + antenna2 * 2 + antenna3 * 4 + antenna4 * 8 + antenna5 * 16 + antenna6 * 32 + antenna7 * 64 + antenna8 * 128)&0xFF;
    
    param[len++] = 0x00;
    param[len++] = 0x20;
    
    param[len++] = ((epccLength * 8) & 0xFF);

    for (int i = 0; i < epccLength; i++) {
        param[len++] = epcData[i];
    }
    
    param[len++] = (accessPassword >> 24) & 0xFF;
    param[len++] = (accessPassword >> 16) & 0xFF;
    param[len++] = (accessPassword >> 8) & 0xFF;
    param[len++] = (accessPassword & 0xFF);
    
    param[len++] = memoryBank;
    
    param[len++] = (startAddress >> 8) & 0xFF;
    param[len++] = (startAddress & 0xFF);
    
    param[len++] = (dataLength >> 8) & 0xFF;
    param[len++] = (dataLength & 0xFF);
    
    for (int i = 0; i < writeDataLength; i++) {
        param[len++] = writeeData[i];
    }
    if (cw) {
        param[len++] = 0x01;
    } else {
        param[len++] = 0x00;
    }
    return [asr033wProtocol command:ASR033WCommandWriteMemory withParameterData:[NSData dataWithBytes:param length:len]];
}

- (ASR033WResultCode)lockMemory:(ASR033WLockBank)lockBank
                       lockType:(ASR033WLockType)lockType
                            epc:(NSData *)epc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8 {
    unsigned int accessPassword = password;
    unsigned short epcLength = epc.length;
    unsigned char *newEPC = (unsigned char*)epc.bytes;
    
    unsigned char lockMBank = lockBank;
    unsigned char lockMType = lockType;
    
    unsigned char len = 0;
    unsigned char param[255];
    
   
    param[len++] = (antenna1 + antenna2 * 2 + antenna3 * 4 + antenna4 * 8 + antenna5 * 16 + antenna6 * 32 + antenna7 * 64 + antenna8 * 128)&0xFF;
    
    param[len++] = lockMBank;

    param[len++] = lockMType;
    
    param[len++] = 0x01;

    param[len++] = 0x00;
    param[len++] = 0x20;
    
    param[len++] = ((epcLength * 8) & 0xFF);

    for (int i = 0; i < epcLength; i++) {
        param[len++] = newEPC[i];
    }
    
    param[len++] = (accessPassword >> 24) & 0xFF;
    param[len++] = (accessPassword >> 16) & 0xFF;
    param[len++] = (accessPassword >> 8) & 0xFF;
    param[len++] = (accessPassword & 0xFF);
    
    return [asr033wProtocol command:ASR033WCommandLock withParameterData:[NSData dataWithBytes:param length:len]];
}

- (ASR033WResultCode)killMemory:(NSData *)epc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8 {
    unsigned int accessPassword = password;
    unsigned short epcLength = epc.length;
    unsigned char *newEPC = (unsigned char*)epc.bytes;
        
    unsigned char len = 0;
    unsigned char param[255];
    
    param[len++] = (antenna1 + antenna2 * 2 + antenna3 * 4 + antenna4 * 8 + antenna5 * 16 + antenna6 * 32 + antenna7 * 64 + antenna8 * 128)&0xFF;
    
    param[len++] = (accessPassword >> 24) & 0xFF;
    param[len++] = (accessPassword >> 16) & 0xFF;
    param[len++] = (accessPassword >> 8) & 0xFF;
    param[len++] = (accessPassword & 0xFF);
    
    param[len++] = 0x01;
    
    param[len++] = 0x00;
    param[len++] = 0x20;
    
    param[len++] = ((epcLength * 8) & 0xFF);

    for (int i = 0; i < epcLength; i++) {
        param[len++] = newEPC[i];
    }
    
    return [asr033wProtocol command:ASR033WCommandKill withParameterData:[NSData dataWithBytes:param length:len]];
}
- (ASR033WResultCode)setSession:(ASR033WSessionType)session {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [NSString stringWithFormat:@"%d", session];
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertyInventorySession withParameter:value];
    return res;
}
- (ASR033WSessionType)getSession {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [asr033wProtocol getProperty:ASR033WPropertyInventorySession withParameter:@""];
    if ([value isEqual:@""]) {
        return ASR033WSessionType_S0;
    }
    ASR033WSessionType session = (ASR033WSessionType)[value intValue];
    return session;
}
- (ASR033WResultCode)setSessionFlag:(ASR033WSessionFlag)session {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [NSString stringWithFormat:@"%d", session];
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertySessionFlag withParameter:value];
    return res;
}
- (ASR033WSessionFlag)getSessionFlag {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [asr033wProtocol getProperty:ASR033WPropertySessionFlag withParameter:@""];
    if ([value isEqual:@""]) {
        return ASR033WSessionFlag_A;
    }
    ASR033WSessionFlag session = (ASR033WSessionFlag)[value intValue];
    return session;
}
- (ASR033WResultCode)setLinkProfile:(int)linkProfile {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (linkProfile < 0) {
        linkProfile = 0;
    }
    if (linkProfile > 4) {
        linkProfile = 4;
    }
    NSString *value = [NSString stringWithFormat:@"%02d", linkProfile];
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertyLinkProfile withParameter:value];
    return res;
}
- (int)getLinkProfile {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    int value = 0;
    NSString *valueString = [asr033wProtocol getProperty:ASR033WPropertyLinkProfile withParameter:@""];
    if ([valueString isEqual:@""]) {
        return value;
    }
    value = [valueString intValue];
    return value;
}
- (ASR033WResultCode)setQValue:(int)QValue {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (QValue < 0) {
        QValue = 0;
    }
    if (QValue > 15) {
        QValue = 15;
    }
    NSString *value = [NSString stringWithFormat:@"%02d", QValue];
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertyQValue withParameter:value];
    return res;
}
- (int)getQValue {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    int value = 0;
    NSString *valueString = [asr033wProtocol getProperty:ASR033WPropertyQValue withParameter:@""];
    if ([valueString isEqual:@""]) {
        return value;
    }
    value = [valueString intValue];
    return value;
}
- (ASR033WResultCode)setAntenna1Power:(int)antenna1Power
                        Antenna2Power:(int)antenna2Power
                        Antenna3Power:(int)antenna3Power
                        Antenna4Power:(int)antenna4Power
                        Antenna5Power:(int)antenna5Power
                        Antenna6Power:(int)antenna6Power
                        Antenna7Power:(int)antenna7Power
                        Antenna8Power:(int)antenna8Power{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    Byte param[] = {0x01,0x00,0x02,0x00,0x03,0x00,0x04,0x00,0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00};
    param[1] = antenna1Power;
    param[3] = antenna2Power;
    param[5] = antenna3Power;
    param[7] = antenna4Power;
    param[9] = antenna5Power;
    param[11] = antenna6Power;
    param[13] = antenna7Power;
    param[15] = antenna8Power;
    return [asr033wProtocol setProperty:ASR033WPropertyPowerGain withParameterData:[NSData dataWithBytes:param length:sizeof(param)]];
}
- (NSDictionary *)getAntennaPower {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    NSData *value = [asr033wProtocol getPropertyData:ASR033WPropertyPowerGain withParameter:@""];
    if ([value isEqual:nil]) {
        return dic;
    }
    const char * param = value.bytes;
    if (value.length == 16) {
        [dic setValue:[NSString stringWithFormat:@"%d",param[1]] forKey:@"Antenna1Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[3]] forKey:@"Antenna2Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[5]] forKey:@"Antenna3Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[7]] forKey:@"Antenna4Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[9]] forKey:@"Antenna5Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[11]] forKey:@"Antenna6Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[13]] forKey:@"Antenna7Power"];
        [dic setValue:[NSString stringWithFormat:@"%d",param[15]] forKey:@"Antenna8Power"];
    }
    return dic;
}
- (NSDictionary *)getAntennaPowerRange {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *regionName = [self regionName];
    NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
    if ([regionName isEqualToString:@"Japan(200mW)"]) {
        [dic setValue:@"23" forKey:@"Max"];
        [dic setValue:@"0" forKey:@"Min"];
    } else {
        [dic setValue:@"30" forKey:@"Max"];
        [dic setValue:@"0" forKey:@"Min"];
    }
    return dic;
}
- (ASR033WResultCode)setIdleTime:(int)time {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if (time < 0 ) {
        time = 0;
    }
    if (time >65535) {
        time = 65535;
    }
    NSString *value = [NSString stringWithFormat:@"%d", time];
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertyIdleTime withParameter:value];
    return res;
}
- (int)getIdleTime {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *value = [asr033wProtocol getProperty:ASR033WPropertyIdleTime withParameter:@""];
    if ([value isEqual:@""]) {
        return 0;
    }
    int time = [value intValue];
    return time;
}
- (ASR033WResultCode)setLBT:(NSArray *)table {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    unsigned char len = 0;
    unsigned char param[255];
    for (NSString *string in table) {
        param[len++] = [string intValue];
    }
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertyLBT withParameterData:[NSData dataWithBytes:param length:len]];
    return res;
}
- (NSArray *)getLBT {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSMutableArray *array = [[NSMutableArray alloc] init];
    NSData *value = [asr033wProtocol getPropertyData:ASR033WPropertyLBT withParameter:@""];
    if ([value isEqual:nil]) {
        return array;
    }
    const char * param = value.bytes;
    for (int i = 0; i < value.length; i++) {
        [array addObject:[NSString stringWithFormat:@"%d",param[i]]];
    }
    return array;
}
- (NSArray *)getLBTMask {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSArray *array = @[@"916.8", @"918.0", @"919.2", @"920.4", @"920.6", @"920.8", @"921.0", @"921.2", @"921.4", @"921.6", @"921.8", @"922.0"];
    return array;
}
- (ASR033WResultCode)setIPStatus:(ASR033WIPStatus)status IP:(NSString *)ip Subnet:(NSString *)subnet Gateway:(NSString *)gateway {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    NSString *sta = 0;
    if (status == ASR033WIPStatus_DHCP) {
        sta = @"D";
    } else {
        sta = @"S";
    }
    NSString *value = [NSString stringWithFormat:@"%@,%@,%@,%@", sta, ip, subnet, gateway];
    if ([ip isEqualToString:@""] && [subnet isEqualToString:@""] && [gateway isEqualToString:@""]) {
        value = [NSString stringWithFormat:@"%@", sta];
    }
    ASR033WResultCode res = [asr033wProtocol setProperty:ASR033WPropertySetIPStatus withParameter:value];
    return res;
}
- (ASR033WResultCode)sendData:(NSData *)data{
    return [asr033wProtocol sendCommand:data];
}
#pragma mark  ---ASR033W Network TCP Delegate---
- (void)onTCPConnected {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    _isConnected = YES;
    if([self.asr033WDelegate respondsToSelector:@selector(receivedASR033WNetworkState:error:)]) {
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            [self.asr033WDelegate receivedASR033WNetworkState:ASR033WNetworkStateConnected error:nil];
        }];
    }
}
- (void)onTCPDisconnect {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    _isConnected = NO;
    if([self.asr033WDelegate respondsToSelector:@selector(receivedASR033WNetworkState:error:)]) {
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            [self.asr033WDelegate receivedASR033WNetworkState:ASR033WNetworkStateDisconnected error:nil];
        }];
    }
}
- (void)onTCPErrorReceive:(NSError *)error {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    _isConnected = NO;
    if([self.asr033WDelegate respondsToSelector:@selector(receivedASR033WNetworkState:error:)]) {
        NSString *errReason = [NSString stringWithFormat:@"ErrCode %d : %@",(int)[error code],[error localizedDescription]];
        [ASR033WUtility writeLog:[NSString stringWithFormat:@"TCP Error : %@",errReason]];
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            [self.asr033WDelegate receivedASR033WNetworkState:ASR033WNetworkStateError error:error];
        }];
    }
}
- (void)onTCPReceive:(NSData *)data {
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    [asr033wProtocol readData:data];
}
#pragma mark  ---ASR033W Network UDP Delegate---
- (void)onSearchingUDPReceiveInformation:(NSDictionary *)information isFinish:(BOOL)isFinish{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if([self.asr033WDelegate respondsToSelector:@selector(receivedASR033WSearchInformation:isFinish:)]){
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            [self.asr033WDelegate receivedASR033WSearchInformation:information isFinish:isFinish];
        }];
    }
}
- (void)onSearchingDeviceInfoReceive:(NSArray *)infoArray{
    [ASR033WUtility writeLog:[NSString stringWithFormat:@"%s",__PRETTY_FUNCTION__]];
    if([self.asr033WDelegate respondsToSelector:@selector(receivedASR033WSearchDeviceInfo:)]){
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            [self.asr033WDelegate receivedASR033WSearchDeviceInfo:infoArray];
        }];
    }
}
#pragma mark  ---ASR033WNetworkMQTTDelegate Private Method---
- (void)onMQTTReceive:(NSData *)data {
    [self onTCPReceive:data];
}
- (void)onMQTTDisconnect {
    [self onTCPDisconnect];
}
- (void)onMQTTConnected {
    [asr033wNetworkMQTT subscriptions:ASR033WNetworkMQTTSubscriptions_CHG_STAT status:YES];
    [self onTCPConnected];
}
- (void)onMQTTErrorReceive:(NSError *)err {
    [self onTCPErrorReceive:err];
}
@end
