//
//  ASR033WDefine.h
//  ASR033WSDK
//
//  Created by MRX_ZYL on 10/12/2020.
//

#ifndef Define_h
#define Define_h

#pragma mark  ---ASR033W SDK VERSION START---
#define ASR033W_VERSION_NO                                                   @"1.0.0"
#pragma mark  ---ASR033W SDK VERSION END---


#pragma mark  ---ASR033W SDK UDP BIND START---
#define BIND_GROUP_IP                                                        @"230.1.1.169"
#define BIND_GROUP_PORT                                                      8161
#pragma mark  ---ASR033W SDK UDP BIND END---

#define CAN_WRITE_LOG                                                        true

#define SEARCH_RFID_READER_INFORMATION                                       @"RFID_READER_INFORMATION"
#define SEARCH_IP                                                            @"IP"
#define SEARCH_MASK                                                          @"MASK"
#define SEARCH_GATEWAY                                                       @"GATEWAY"
#define SEARCH_MAC                                                           @"MAC"
#define SEARCH_PORT                                                          @"PORT"
#define SEARCH_HOST_SERVER_IP                                                @"HOST_SERVER_IP"
#define SEARCH_HOST_SERVER_PORT                                              @"HOST_SERVER_PORT"
#define SEARCH_MODE                                                          @"MODE"
#define SEARCH_NET_STATE                                                     @"NET_STATE"
#define SEARCH_DHCP_SW                                                       @"PROTO"

#pragma mark  ---ASR033W PACKET Struct Start---
typedef struct{
    unsigned char header;
    unsigned char msg_type[4];
    unsigned char pl_length[2];
    unsigned char payload[1024];
} rcp_033w_packet;

typedef struct{
    unsigned char code_type[1];
    unsigned char payload[1024];
} rcp_033w_packet_type;

typedef struct{
    unsigned char pl_length[2];
    unsigned char payload[1024];
} rcp_033w_packet_length;

#pragma mark  ---ASR033W PACKET Struct End---

#pragma mark  ---ASR033W PACKET Enumerlator Start---
typedef enum {
    ASR033WNetworkStateUnknown = 0,
    ASR033WNetworkStateConnected,
    ASR033WNetworkStateDisconnected,
    ASR033WNetworkStateError
} ASR033WNetworkState;

typedef enum {
    ASR033WResultNoError = 0x0000,
    ASR033WResultOtherError = 0x0001,
    ASR033WResultUndefined = 0x0002,
    ASR033WResultMemoryOverrun = 0x0003,
    ASR033WResultMemoryLocked = 0x0004,
    ASR033WResultInsufficientPower = 0x000B,
    ASR033WResultNotConnected = 0xE100,
    ASR033WResultInvalidParameter = 0xE200,
    ASR033WResultTimeout = 0xEFFF,
    ASR033WResultOutOfRetries = 0xF009,
    ASR033WResultReadCRCError = 0xF002,
    ASR033WResultReadDataAreaIsLocked = 0xF003,
    ASR033WResultReadDataAreaOverflow = 0xF004,
    ASR033WResultReadIncorrectAccessPassword = 0xF005,
    ASR033WResultReadOtherLabelsAreIncorrect = 0xF006,
    ASR033WResultReadReaderWriterErrors = 0xF007,
    ASR033WResultWriteAntennaPortParameterError = 0xF101,
    ASR033WResultWriteSelectionParameterError = 0xF102,
    ASR033WResultWriteWritingParameterError = 0xF103,
    ASR033WResultWriteCRCCheckError = 0xF104,
    ASR033WResultWriteInsufficientPower = 0xF105,
    ASR033WResultWriteMemoryOverrun = 0xF106,
    ASR033WResultWriteMemoryLocked = 0xF107,
    ASR033WResultWriteIncorrectAccessPassword = 0xF108,
    ASR033WResultWriteOtherLabelError = 0xF109,
    ASR033WResultWriteLabelLoss = 0xF110,
    ASR033WResultWriteSendingInstructionError = 0xF111,
    ASR033WResultLockAntennaPortParameterError = 0xF201,
    ASR033WResultLockSelectionParameterError = 0xF202,
    ASR033WResultLockLockingParameterError = 0xF203,
    ASR033WResultLockCRCCheckError = 0xF204,
    ASR033WResultLockInsufficientPower = 0xF205,
    ASR033WResultLockMemoryOverrun = 0xF206,
    ASR033WResultLockMemoryLocked = 0xF207,
    ASR033WResultLockIncorrectAccessPassword = 0xF208,
    ASR033WResultLockOtherLabelError = 0xF209,
    ASR033WResultLockLabelLoss = 0xF210,
    ASR033WResultLockSendingInstructionError = 0xF211,
    ASR033WResultKillAntennaPortParameterError = 0xF301,
    ASR033WResultKillSelectionParameterError = 0xF302,
    ASR033WResultKillCRCCheckError = 0xF303,
    ASR033WResultKillInsufficientPower = 0xF304,
    ASR033WResultKillIncorrectAccessPassword = 0xF305,
    ASR033WResultKillOtherLabelError = 0xF306,
    ASR033WResultKillLabelLoss = 0xF307,
    ASR033WResultKillSendingInstructionError = 0xF308,
    ASR033WResultLBTParameterError = 0xF503,
    ASR033WResultSessionValueParameterError = 0xF805,
    ASR033WResultSessionFlagParameterError = 0xF905,
    ASR033WResultPowerOutputParameterError = 0xFA02,
} ASR033WResultCode;

typedef enum {
    ASR033WMemoryBank_Reserved,
    ASR033WMemoryBank_EPC,
    ASR033WMemoryBank_TID,
    ASR033WMemoryBank_User
} ASR033WMemoryBank;

typedef enum {
    ASR033WLockBank_Kill,
    ASR033WLockBank_Access,
    ASR033WLockBank_EPC,
    ASR033WLockBank_TID,
    ASR033WLockBank_User
} ASR033WLockBank;

typedef enum {
    ASR033WLockType_Unlock,
    ASR033WLockType_Lock,
    ASR033WLockType_PermaUnlock,
    ASR033WLockType_PermaLock
} ASR033WLockType;

typedef enum {
    ASR033WSessionFlag_A,
    ASR033WSessionFlag_B,
    ASR033WSessionFlag_AB
} ASR033WSessionFlag;
 
typedef enum {
    ASR033WSessionType_S0 = 0,
    ASR033WSessionType_S1,
    ASR033WSessionType_S2,
    ASR033WSessionType_S3
} ASR033WSessionType;

typedef enum {
    ASR033WPrinterStatus_NOERROR = 0,
    ASR033WPrinterStatus_NOPAPER,
    ASR033WPrinterStatus_InstitutionalFailure,
    ASR033WPrinterStatus_CoverOpen
} ASR033WPrinterStatus;

typedef enum {
    ASR033WPrintCutTypeFull = 0x69,
    ASR033WPrintCutTypeHalf = 0x6D
} ASR033WPrintCutType;

typedef enum {
    ASR033WPrintAlignmentLeft = 0,
    ASR033WPrintAlignmentCenter = 1,
    ASR033WPrintAlignmentRight = 2
} ASR033WPrintAlignment;

typedef enum {
    ASR033WPrintFont_1 = 0x00,
    ASR033WPrintFont_2 = 0x11,
    ASR033WPrintFont_3 = 0x22,
    ASR033WPrintFont_4 = 0x33,
    ASR033WPrintFont_5 = 0x44,
    ASR033WPrintFont_6 = 0x55,
    ASR033WPrintFont_7 = 0x66,
    ASR033WPrintFont_8 = 0x77
} ASR033WPrintFont;

typedef enum {
    ASR033WPrintQrDotSize_1 = 1,    //!< QR dot size 1x1
    ASR033WPrintQrDotSize_2 = 2,    //!< QR dot size 2x2
    ASR033WPrintQrDotSize_3 = 3,    //!< QR dot size 3x3
    ASR033WPrintQrDotSize_4 = 4,    //!< QR dot size 4x4
    ASR033WPrintQrDotSize_5 = 5,    //!< QR dot size 5x5
    ASR033WPrintQrDotSize_6 = 6,    //!< QR dot size 6x6
    ASR033WPrintQrDotSize_7 = 7     //!< QR dot size 7x7
} ASR033WPrintQrDotSize;

typedef enum {
    ASR033WConnectMethod_TCP,
    ASR033WConnectMethod_MQTT
} ASR033WConnectMethod;

typedef enum {
    ASR033WIPStatus_DHCP,
    ASR033WIPStatus_STATIC
} ASR033WIPStatus;
#pragma mark  ---ASR033W PACKET Enumerlator End---

#endif /* Define_h */
