#import <Foundation/Foundation.h>
#import "ASR033WRfidValues.h"
#import "ASR033WPacket.h"
#import "ASR033WDelegate.h"
#import "ASR033WNetworkTCP.h"
#import "ASR033WDefine.h"
#import "ASR033WNetworkMQTT.h"
@interface ASR033WProtocol : NSObject
@property (nonatomic, strong) id<ASR033WDelegate> delegate;
@property (nonatomic, assign) BOOL isReportRssi;
@property (nonatomic, assign) ASR033WConnectMethod connectMethod;

- (id)initWithASR033W:(ASR033W *)asreader asr033WNetworkMqtt:(ASR033WNetworkMQTT *)asr033WNetworkMqtt tcp:(ASR033WNetworkTCP *)asP52NNetworkTCP;
- (void)disconnect;
- (ASR033WCommandType)getAction;
- (NSData *)getPropertyData:(ASR033WPropertyType)type withParameter:(NSString *)param;
- (NSString *)getProperty:(ASR033WPropertyType)type withParameter:(NSString *)param;
- (ASR033WResultCode)setProperty:(ASR033WPropertyType)type withParameter:(NSString *)param;
- (ASR033WResultCode)setProperty:(ASR033WPropertyType)type withParameterData:(NSData *)param;
- (ASR033WResultCode)sendCommand:(NSData *)data;
- (ASR033WResultCode)command:(ASR033WCommandType)command withParameter:(NSString *)param;
- (ASR033WResultCode)command:(ASR033WCommandType)command withParameterData:(NSData *)param;
- (void)readData:(NSData *)data;
@end
