//
//  SettingViewController.m
//  ASR033W
//
//  Created by mac on 2020/10/30.
//

#import "SettingViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "System.h"

@interface SettingViewController ()<ASR033WDelegate, UITableViewDelegate, UITableViewDataSource>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@end

@implementation SettingViewController
{
    ASR033W *asr033w;
    System *system;
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    system = [System sharedSystem];
    asr033w = [ASR033W sharedInstance];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
}
#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 3;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        NSString *cellIdentifier = @"tableViewCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell){
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
        }
        cell.textLabel.text = @"Ethernet Mac";
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        return cell;
    } else if (indexPath.row == 1) {
        NSString *cellIdentifier = @"tableViewCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell){
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
        }
        cell.textLabel.text = @"Reader time";
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        return cell;
    } else {
        NSString *cellIdentifier = @"tableViewCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
        if(!cell){
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellIdentifier];
        }
        cell.textLabel.text = @"Ethernet IP";
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        return cell;
    }
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        [self performSegueWithIdentifier:@"EthernetMacID" sender:nil];
    } else if (indexPath.row == 1) {
        [self performSegueWithIdentifier:@"ReaderTimeID" sender:nil];
    } else if (indexPath.row == 2) {
        [self performSegueWithIdentifier:@"EthernetIPID" sender:nil];
    }
}
#pragma mark - ASR033WDelegate
- (void)ASR033W:(ASR033W *)ASR033W changeNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
@end
