﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Security.Policy;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using uPLibrary.Networking.M2Mqtt;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;

namespace AsReader033W_Demo
{
    class Handler
    {
        private static volatile Handler instance;
        private static object syncRoot = new Object();
        public ClientModel ConnectedModel = ClientModel.None;

        UdpClient udpClient;
        ClassTCPClient tCPClient = ClassTCPClient.Instance;
        ClassMqttClient mQTTClient = ClassMqttClient.Instance;
        Device device;

        public event Action<int> EventSetProgressBarValue;// progress bar
        public event Action<string> EventReceiveMessage;// 
        public event Action<string> EventSendMessage;// 
        public event Action<bool> EventConnectedCheck;// 
        public event Action<bool> EventStopSuccess;// 

        public event Action<Tag> whenReceivedTag;

        public event Action<GroupMessage> EventGroupBack;


        bool Connected = false;
        string RemainingMessages = "";//The last packet (incomplete data) after splitting the TCP return message by type, used for packet assembly

        bool AnalyzeMessages = true;

        public static Handler Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new Handler();
                    }
                }

                return instance;
            }
        }

        private Handler()
        {
            device = new Device();
            device.WriteMessage += Device_WriteMessage;
            device.whenReceivedTag += Device_whenReceivedTag;
            device.EventStop += Device_EventStop;
        }

        private void Device_EventStop(bool obj)
        {
            EventStopSuccess?.Invoke(obj);
        }

        public void SetAnalyzeStatus(bool status)
        {
            AnalyzeMessages = status;
        }

        private void Device_WriteMessage(byte[] data)
        {

            if (ConnectedModel == ClientModel.TCP)
            {
                tCPClient.WriteMessage(data);
            }
            else if (ConnectedModel == ClientModel.MQTT)
            {
                mQTTClient.Publish(data);
            }
            var sendmsg = Device.ByteArrayToHexStringWithSpaces(data).ToUpper();

            EventSendMessage?.Invoke(sendmsg);
        }

        public bool UdpJoinGroup()
        {
            try
            {
                IPAddress multicastAddress = IPAddress.Parse(Const.UDP_ADDRESS);
                int port = Convert.ToInt32(Const.UDP_PORT);

                udpClient = new UdpClient(port);

                // Join Multicast Group
                udpClient.JoinMulticastGroup(multicastAddress);

                Thread th = new Thread(StartGetGroupValue);
                th.Start();

                return true;
            }
            catch (Exception ex) 
            { 
                return false;
            }

        }

        public bool UdpDisconnect()
        {
            try
            {
                udpClient.Close();
                udpClient.Dispose();

                return true;
            }
            catch (Exception ex)
            {
                return false;
            }

        }


        public async void StartGetGroupValue()
        {
            while (true)
            {
                //IPEndPoint remoteEP = null;
                //byte[] data = udpClient.Receive(ref remoteEP);

                try
                {
                    UdpReceiveResult result = await udpClient.ReceiveAsync();
                
                    byte[] data = result.Buffer;
                    IPEndPoint remoteEndPoint = result.RemoteEndPoint;

                    string message = Encoding.UTF8.GetString(data);

                    var messageGroup = message.Replace("^", "").Split("\r\n");
                    GroupMessage rtn = new GroupMessage();
                    for (int i = 0; i < messageGroup.Length; i++)
                    {
                        var one = messageGroup[i].Replace(" ", "").Replace(",", "").Split(":");
                        if (one.Length > 0)
                        {
                            if (one[0] == "HOST_SERVER_IP")
                            {
                                rtn.IP = one[1];
                            }
                            else if (one[0] == "HOST_SERVER_PORT")
                            {
                                rtn.Port = one[1];
                            }
                            else if(one[0] == "MAC")
                            {
                                rtn.MAC = one[1];
                            }
                            else if(one[0] == "RFID_READER_INFORMATION")
                            {
                                rtn.ManufactureNumber = one[1];
                            }
                        }
                    }
                    EventGroupBack?.Invoke(rtn);

                    Thread.Sleep(100);
                }

                catch (Exception ex)
                {
                    Debug.WriteLine("UDP disconnected："+ ex.Message);
                    return;
                }
            }
        }


        public async Task<List<string>> GetGroupValue()
        {
            List<string> rtn = new List<string>();
            HashSet<string> hashSet;

            CancellationTokenSource cts = new CancellationTokenSource(10000); // Set a timeout of 10 seconds
            CancellationToken token = cts.Token;

            int num = 0;

            while (!token.IsCancellationRequested)
            {
                try
                {
                    if (num++ == 10)
                    {
                        EventSetProgressBarValue?.Invoke(100);
                        continue;
                    }
                    UdpReceiveResult result = await udpClient.ReceiveAsync(token);
                    byte[] data = result.Buffer;
                    IPEndPoint remoteEndPoint = result.RemoteEndPoint;

                    EventSetProgressBarValue?.Invoke(num);

                    string message = Encoding.UTF8.GetString(data);
                    Debug.WriteLine("Received UDP multicast message: {0}", message);

                    var messageGroup = message.Split(',');
                    for (int i = 0; i < messageGroup.Length; i++)
                    {
                        var one = messageGroup[i].Replace(" ", "").Replace("\r\n","").Split(":");
                        if (one.Length > 0)
                        {
                            if (one[0] == "HOST_SERVER_IP")
                            {
                                rtn.Add(one[1]);
                            }
                        }
                    }
                }
                catch (TaskCanceledException)
                {
                    EventSetProgressBarValue?.Invoke(100);
                    break;
                }
                catch (Exception ex)
                {
                    // Other exceptions
                    EventSetProgressBarValue?.Invoke(100);
                    Console.WriteLine($"An exception occurred while receiving data:{ex.Message}");
                    hashSet = new HashSet<string>(rtn);
                    rtn.Clear();
                    rtn = new List<string>(hashSet);
                    return rtn;
                }
            }


            hashSet = new HashSet<string>(rtn);
            rtn.Clear();
            rtn = new List<string>(hashSet);

            return rtn;

        }

        private void Device_EventAnalyzeMessage(string msg)
        {

            if (msg.StartsWith("*"))
            {
                RemainingMessages = msg.Replace("*", "");
            }
            else if (msg.StartsWith("#"))
            {
                string _tmp = msg.Replace("#", "");

                if (!Connected)
                {
                    Connected = true;
                }

                if (!Connected)
                {
                    EventConnectedCheck?.Invoke(true);
                }
                EventReceiveMessage?.Invoke(msg);
            }
            else
            {
                EventReceiveMessage?.Invoke(msg);
            }
        }

        private void MqttClient_EventConnectState(bool obj)
        {
            if (obj)
            {
                Thread.Sleep(1);
                device.Subinitialization();
                Thread.Sleep(1);
                device.StopInventory();
                Thread.Sleep(1);
                device.GetepcModuleVersion();

                Thread thread = new Thread(GetConnected);
                thread.Start();
            }
            else//If the network is incorrect,ERROR
            {
                EventConnectedCheck?.Invoke(false);
            }
        }

        private void TCPClient_EventConnectState(bool obj)
        {
            if (obj)
            {
                Thread.Sleep(1);
                device.Subinitialization();
                Thread.Sleep(1);
                device.StopInventory();
                Thread.Sleep(1);
                device.GetepcModuleVersion();

                Thread thread = new Thread(GetConnected);
                thread.Start();
            }
            else//If the network is incorrect,ERROR
            {
                EventConnectedCheck?.Invoke(false);
            }
        }

        private void TCPClient_EventConnectStateNumber(int obj)
        {
            EventSetProgressBarValue?.Invoke(obj);
        }

        private void MqttClient_EventReceiveMessage(byte[] obj)
        {
            string msg = "";

            msg = device.AnalyzeMessages(obj, AnalyzeMessages, RemainingMessages);
            //Debug.WriteLine("Messages received by MQTT:" + msg);

            if (msg.StartsWith("*"))
            {
                RemainingMessages = msg.Replace("*", "");
            }
            else if (msg.StartsWith("#"))
            {
                if (!Connected)
                {
                    EventConnectedCheck?.Invoke(true);
                }
                EventReceiveMessage?.Invoke(msg);
            }
            else
            {
                EventReceiveMessage?.Invoke(msg);
            }
        }

        private void TCPClient_EventReceiveMessage(byte[] obj)
        {
            string msg = "";

            msg = device.AnalyzeMessages(obj, AnalyzeMessages, RemainingMessages);
            Debug.WriteLine("Messages received by TCP:" + msg);

            if (msg.StartsWith("*"))
            {
                RemainingMessages = msg.Replace("*", "");
            }
            else if (msg.StartsWith("#"))
            {
                if (!Connected)
                { 
                    EventConnectedCheck?.Invoke(true);
                }
                EventReceiveMessage?.Invoke(msg);
            }
            else
            {
                EventReceiveMessage?.Invoke(msg);
            }
        }


        void GetConnected()
        {
            int i = 0;
            while (i < 5)
            {
                if (Connected)
                {
                    EventConnectedCheck?.Invoke(true);
                    return;
                }
                else
                {
                    Thread.Sleep(1000);
                    Debug.WriteLine("Waiting for connection timeout:" + i.ToString());
                    i++;
                }
            }

            tCPClient.Disconnect();
            tCPClient.EventReceiveMessage -= TCPClient_EventReceiveMessage;
            tCPClient.EventConnectState -= TCPClient_EventConnectState;
            tCPClient.EventConnectStateNumber -= TCPClient_EventConnectStateNumber;


            device.EventAnalyzeMessage -= Device_EventAnalyzeMessage;

            EventConnectedCheck?.Invoke(false);
        }

        public void Connect(ClientModel model, string IP, string Port)
        {
            ConnectedModel = model;
            Connected = false;

            if (model == ClientModel.TCP)
            {
                tCPClient = ClassTCPClient.Instance;

                RemainingMessages = "";

                tCPClient.EventReceiveMessage += TCPClient_EventReceiveMessage; 
                tCPClient.EventConnectState += TCPClient_EventConnectState; 
                tCPClient.EventConnectStateNumber += TCPClient_EventConnectStateNumber;

                device.EventAnalyzeMessage += Device_EventAnalyzeMessage;

                tCPClient.Connect(IP, Convert.ToInt32(Port));
            }
            else if (model == ClientModel.MQTT)
            {
                RemainingMessages = "";

                mQTTClient = ClassMqttClient.Instance;
                mQTTClient.EventReceiveMessage += MqttClient_EventReceiveMessage;
                mQTTClient.EventConnectState += MqttClient_EventConnectState;

                device.EventAnalyzeMessage += Device_EventAnalyzeMessage;

                mQTTClient.MqttClientStart(IP);
            }
        }


        public void DisConnect()
        {
            if (ConnectedModel == ClientModel.TCP)
            {
                tCPClient.Disconnect();
                tCPClient.EventReceiveMessage -= TCPClient_EventReceiveMessage;
                tCPClient.EventConnectState -= TCPClient_EventConnectState;
                tCPClient.EventConnectStateNumber -= TCPClient_EventConnectStateNumber;


                tCPClient = ClassTCPClient.Instance;

                device.EventAnalyzeMessage -= Device_EventAnalyzeMessage;

            }
            else if (ConnectedModel == ClientModel.MQTT)
            {
                mQTTClient.EventReceiveMessage -= MqttClient_EventReceiveMessage;
                mQTTClient.EventConnectState -= MqttClient_EventConnectState;

                device.EventAnalyzeMessage -= Device_EventAnalyzeMessage;

                mQTTClient.MqttClientStop();
            }
        }

        public void SatrtInventory(bool TID, bool RSSI, byte anats, int time, int count)
        {
           device.StartInventory(TID, RSSI, anats, time, count);
        }

        public void StopInventory()
        {
           device.StopInventory();
        }

        public void SendCommand(string msg)
        {
            device.SendCommand(msg);
        }

        private void Device_whenReceivedTag(Tag tag)
        {
            whenReceivedTag?.Invoke(tag);
        }
    }
}
