using System.CodeDom;
using System.Collections;
using System.Data;
using System.Diagnostics;
using System.Net;
using System.Net.Http;
using System.Net.Sockets;
using System.Reflection;
using System.Reflection.Emit;
using System.Text;
using System.Windows.Forms;
using static System.Runtime.InteropServices.JavaScript.JSType;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.Button;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.ListView;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.StartPanel;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.ToolBar;
using Timer = System.Windows.Forms.Timer;

namespace AsReader033W_Demo
{
    public partial class Form1 : Form
    {
        #region "VARIABLE"

        Handler handler = Handler.Instance;
        Timer timer = new Timer();

        ClientModel model = ClientModel.TCP;

        DateTime startTime;

        int systemCounter = 0;

        Hashtable TagHashTable = new Hashtable();

        int singluationCount = 0;

        bool stopShow = false;

        List<string> dropList = new List<string>();

        bool CountStop = false;
        bool RoundStop = false;
        bool TimeStop = false;

        bool Inventorying = false;

        int _count = 0;
        int LastCount = 0;

        DataTable dt = new DataTable();
        DataTable dtShow = new DataTable();

        private Queue<Tag> tagQueue = new Queue<Tag>();
        private System.Threading.Timer updateTimer;

        int tmpnum = 0;

        private BindingSource bindingSource = new BindingSource();

        private object dataLock = new object();

        #endregion

        #region "EVENT"

        private void Timer_Tick(object? sender, EventArgs e)
        {
            systemCounter++;
            label19.Text = Convert.ToInt32((DateTime.Now - startTime).TotalMilliseconds).ToString();

            if (CountStop)
            {

                if (Convert.ToInt32(label18.Text) >= Convert.ToInt32(txtInventroyCount.Text))
                {
                    BtnStopInventory(null, null);
                    stopShow = true;
                }
            }

            if (RoundStop)
            {
                if (Convert.ToInt32(label20.Text) >= Convert.ToInt32(txtInventroyRound.Text))
                {
                    BtnStopInventory(null, null);
                    stopShow = true;
                }
            }

            if (TimeStop)
            {
                if (Convert.ToInt32(label19.Text) / 1000 >= Convert.ToInt32(txtInvertoryTime.Text))
                {
                    BtnStopInventory(null, null);
                    stopShow = true;
                }
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            handler.DisConnect();
        }

        private void btnGruop_Click(object sender, EventArgs e)
        {
            try
            {
                if (handler.UdpJoinGroup())
                {
                    this.btn_Search.Enabled = true;
                }
                else
                {
                    this.btn_Search.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                this.btn_Search.Enabled = false;
            }
        }

        private void Handler_EventGroupBack(GroupMessage obj)
        {

            if (dropList.Exists(t => t == obj.IP))
            {
                Debug.WriteLine(obj.IP);
            }
            else
            {
                dropList.Add(obj.IP);

                string showMessage = "";
                showMessage += "IP:" + obj.IP + "     ";
                showMessage += "Manufacture Number:" + obj.ManufactureNumber + "     ";
                showMessage += "MAC:" + obj.MAC;

                this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + showMessage + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
        }

        private async void btn_Search_Click(object sender, EventArgs e)
        {
            btnGruop_Click(sender, e);

            dropList.Clear();

            this.comboBox1.Text = "";
            this.progressBar1.Visible = true;
            progressBar1.Value = 0;

            Thread th = new Thread(GetGroupValue);
            th.Start();
        }

        private void btn_Connect_Click(object sender, EventArgs e)
        {
            this.btn_Connect.Enabled = false;

            this.progressBar1.Value = 0;
            this.progressBar1.Visible = true;

            if (string.IsNullOrEmpty(comboBox1.Text) || string.IsNullOrEmpty(textPort.Text))
            {
                MessageBox.Show("Please Input IP Address.");
                this.btn_Connect.Enabled = true;
                this.progressBar1.Value = 100;
                this.progressBar1.Visible = false;

                return;
            }

            handler.EventReceiveMessage -= Handler_EventReceiveMessage;
            handler.EventReceiveMessage += Handler_EventReceiveMessage;
            handler.EventConnectedCheck -= Handler_EventConnectedCheck;
            handler.EventConnectedCheck += Handler_EventConnectedCheck;
            handler.EventSendMessage -= Handler_EventSendMessage;
            handler.EventSendMessage += Handler_EventSendMessage;
            handler.EventSetProgressBarValue -= Handler_EventSetProgressBarValue;
            handler.EventSetProgressBarValue += Handler_EventSetProgressBarValue;

            handler.Connect(model, comboBox1.Text, textPort.Text);
        }

        private void btn_Inventory_Click(object sender, EventArgs e)
        {
            if (!Inventorying)
            {
                this.panelCover.Visible = true;

                handler.whenReceivedTag += Handler_whenReceivedTag;
                BtnSatrtInventory(sender, e);
            }
            else
            {
                this.panelCover.Visible = false;

                //handler.whenReceivedTag -= Handler_whenReceivedTag;
                BtnStopInventory(sender, e);
            }
        }

        private void btn_DisConnect_Click(object sender, EventArgs e)
        {
            try
            {
                this.tabControl1.SelectedIndex = 0;

                handler.DisConnect();

                this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Server Disconnected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();

                handler.EventReceiveMessage -= Handler_EventReceiveMessage;
                handler.EventConnectedCheck -= Handler_EventConnectedCheck;
                handler.EventSendMessage -= Handler_EventSendMessage;
                handler.EventSetProgressBarValue -= Handler_EventSetProgressBarValue;

                btn_Connect.Enabled = true;
                btn_Search.Enabled = true;
                groupBox8.Enabled = true;

                this.progressBar1.Value = 100;
                this.progressBar1.Visible = false;
                btn_DisConnect.Enabled = false;
                tabControl1.Enabled = false;
            }
            catch (Exception ex)
            {
            }
        }

        private void btn_Flush_Click(object sender, EventArgs e)
        {
            TagHashTable.Clear();

            dt.Rows.Clear();

            singluationCount = 0;
            LastCount = 0;


            this.DatalistView.Items.Clear();
            //this.Devmes.Text = "";

            this.label18.Text = "0";
            this.label19.Text = "0";
            this.label20.Text = "0";
            this.label21.Text = "0";

            //this.labType.Text = "";
        }

        private void btn_SendCommand_Click(object sender, EventArgs e)
        {
            string tmp = SendBox.Text;
            string msg = tmp.Replace(" ", "").Replace("\r", "").Replace("\n", "");

            if (msg.Length % 2 != 0)
            {
                MessageBox.Show("Data Format Error");
            }
            else
            {
                this.SendBox.Clear();

                this.GetBox.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Send Command : " + tmp.ToUpper().Replace("\r", "").Replace("\n", "") + Environment.NewLine);
                this.GetBox.ScrollToCaret();

                handler.SendCommand(msg);
            }
        }

        private void btn_Clear_Click(object sender, EventArgs e)
        {
            this.GetBox.Clear();
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (tabControl1.SelectedIndex == 1)
            {
                handler.SetAnalyzeStatus(false);
            }
            else
            {
                handler.SetAnalyzeStatus(true);
            }
            BtnStopInventory(sender, e);

        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                chbAna8.Checked = true;
                chbAna7.Checked = true;
                chbAna6.Checked = true;
                chbAna5.Checked = true;
                chbAna4.Checked = true;
                chbAna3.Checked = true;
                chbAna2.Checked = true;
                chbAna1.Checked = true;
            }
            else
            {
                chbAna8.Checked = false;
                chbAna7.Checked = false;
                chbAna6.Checked = false;
                chbAna5.Checked = false;
                chbAna4.Checked = false;
                chbAna3.Checked = false;
                chbAna2.Checked = false;
                chbAna1.Checked = false;
            }
        }

        private void ModelCheck_CheckedChanged(object sender, EventArgs e)
        {
            var _tmp = sender as System.Windows.Forms.CheckBox;

            if (_tmp.Text == "MQTT")
            {
                ModelTCPCheck.Checked = !ModelMQTTCheck.Checked;
            }
            else
            {
                ModelMQTTCheck.Checked = !ModelTCPCheck.Checked;
            }

            if (ModelTCPCheck.Checked)
            {
                this.textPort.Text = Const.TCP_PORT;
                model = ClientModel.TCP;
            }
            else
            {
                this.textPort.Text = Const.MQTT_PORT;
                model = ClientModel.MQTT;
            }
        }

        private void SendBox_KeyPress(object sender, KeyPressEventArgs e)
        {

            if (e.KeyChar == 13)
            {
                btn_SendCommand_Click(null, null);
            }

            if (char.IsControl(e.KeyChar))
            {
                return;
            }

            if (e.KeyChar == ' ')
            {
                return;
            }

            // 0-9 A-F a-f  
            if ((e.KeyChar >= '0' && e.KeyChar <= '9') ||
                (e.KeyChar >= 'A' && e.KeyChar <= 'F') ||
                (e.KeyChar >= 'a' && e.KeyChar <= 'f'))
            {
                return;
            }

            // Prevent the input of other characters
            e.Handled = true;
        }

        private void Handler_EventSetProgressBarValue(int obj)
        {
            if (obj != 100)
            {
                int value = progressBar1.Value;
                if (value >= 100)
                {
                    progressBar1.Value = 99;
                }
                else
                {
                    progressBar1.Value = value += 10;
                }
            }
            else
            {
                progressBar1.Value = 99;
            }
        }

        private void Handler_EventSendMessage(string obj)
        {
            if (tabControl1.SelectedIndex != 1)//Send mode
            {
                if (!string.IsNullOrEmpty(obj))
                {
                    this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + " Send:" + obj + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
        }

        private void Handler_EventConnectedCheck(bool obj)
        {
            if (obj && tabControl1.Enabled == false)
            {

                this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Server Connected." + Environment.NewLine);
                this.Devmes.ScrollToCaret();

                btn_Connect.Enabled = false;
                btn_Search.Enabled = false;
                groupBox8.Enabled = false;

                this.progressBar1.Value = 0;
                this.progressBar1.Visible = false;

                btn_DisConnect.Enabled = true;
                tabControl1.Enabled = true;
            }
            else if (!obj && tabControl1.Enabled == false)
            {
                btn_Connect.Enabled = true;
                btn_Search.Enabled = true;
                groupBox8.Enabled = true;

                this.progressBar1.Value = 100;
                this.progressBar1.Visible = false;

                btn_DisConnect.Enabled = false;
                tabControl1.Enabled = false;

                this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Server Connection Failed." + Environment.NewLine);
                this.Devmes.ScrollToCaret();

                handler.DisConnect();
            }
        }

        private void Handler_EventReceiveMessage(string obj)
        {
            if (string.IsNullOrEmpty(obj)) return;

            Debug.WriteLine("Received message" + obj);

            if (tabControl1.SelectedIndex == 1)//Send mode
            {
                this.GetBox.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Received Command   : " + obj.ToUpper() + Environment.NewLine);
                this.GetBox.ScrollToCaret();
            }
            else
            {
                if (obj.StartsWith("#"))
                {
                    string Type = obj.Replace("#", "");
                    if (Type == "R2000")
                    {
                        txtInventroyCount.Enabled = false;
                        txtInventroyRound.Enabled = false;
                        txtInvertoryTime.Enabled = false;
                    }
                    labType.Text = Type;
                }
                else
                {
                    this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "Received Command   : " + obj.ToUpper() + Environment.NewLine);
                    this.Devmes.ScrollToCaret();
                }
            }
        }

        private void pictureBox1_DoubleClick(object sender, EventArgs e)
        {
            this.Devmes.Text = string.Empty;
        }
        
        private void button1_Click(object sender, EventArgs e)
        {
            this.Devmes.Text = string.Empty;
        }


        #endregion

        #region "FUCTION"
        public Form1()
        {
            InitializeComponent();
            CheckForIllegalCrossThreadCalls = false;

            timer.Enabled = false;
            timer.Interval = 1;
            timer.Tick += Timer_Tick;

            dt.Clear();
            dt.Columns.Clear();

            dt.Columns.Add("Index", typeof(string));
            dt.Columns.Add("PC", typeof(string));
            dt.Columns.Add("EPC", typeof(string));
            dt.Columns.Add("AntID", typeof(string));
            dt.Columns.Add("RSSI", typeof(string));
            dt.Columns.Add("Frequency", typeof(string));
            dt.Columns.Add("Phase", typeof(string));
            dt.Columns.Add("Count", typeof(string));  // Use integer type
            dt.Columns.Add("Time", typeof(string));
            dt.Columns.Add("TID", typeof(string));

            dt.PrimaryKey = new DataColumn[] { dt.Columns["EPC"] };

            ThreadPool.QueueUserWorkItem(HandleTagsInQueue);

            updateTimer = new System.Threading.Timer(UpdateDataTable, null, TimeSpan.Zero, TimeSpan.FromMilliseconds(1000));
         
            handler.EventStopSuccess += Handler_EventStopSuccess;
        }

        private void Handler_EventStopSuccess(bool obj)
        {
            handler.whenReceivedTag -= Handler_whenReceivedTag;
        }

        byte GetCheckBoxAnas()
        {
            int ouptutValue = 0;
            ouptutValue += chbAna8.Checked ? 128 : 0;
            ouptutValue += chbAna7.Checked ? 64 : 0;
            ouptutValue += chbAna6.Checked ? 32 : 0;
            ouptutValue += chbAna5.Checked ? 16 : 0;
            ouptutValue += chbAna4.Checked ? 8 : 0;
            ouptutValue += chbAna3.Checked ? 4 : 0;
            ouptutValue += chbAna2.Checked ? 2 : 0;
            ouptutValue += chbAna1.Checked ? 1 : 0;

            return (byte)ouptutValue;
        }

        private void BtnSatrtInventory(object sender, EventArgs e)
        {
            btn_DisConnect.Enabled = false;

            startTime = DateTime.Now;

            systemCounter = 0;
            stopShow = false;

            btn_Flush_Click(sender, e);
            btn_Flush.Enabled = false;

            timer.Start();
            bool rssi = false;
            if (rabRSSION.Checked) rssi = true;


            int time = 0;
            if (int.TryParse(txtInvertoryTime.Text, out int res))
            {
                time = res;
            }

            int count = 0;
            if (int.TryParse(txtInventroyCount.Text, out int res3))
            {
                count = res3;
            }

            int round = 0;
            if (int.TryParse(txtInventroyRound.Text, out int res2))
            {
                round = res2;
            }

            TimeStop = false;
            RoundStop = false;
            CountStop = false;


            if (time != 0)
            {
                TimeStop = true;
            }

            if (count != 0)
            {
                CountStop = true;
            }

            if (round != 0)
            {
                RoundStop = true;
            }

            Inventorying = true;
            this.btn_Inventory.Text = "Stop";


            if ((this.labType.Text == "PR920") && time > 255) time = 0;
            if ((this.labType.Text == "PR920") && count > 255) count = 0;

            handler.SatrtInventory(chbTID.Checked, rssi, GetCheckBoxAnas(), time, count);
        }

        private void BtnStopInventory(object sender, EventArgs e)
        {
            btn_DisConnect.Enabled = true;

            handler.StopInventory();

            timer.Stop();

            btn_Flush.Enabled = true;

            Inventorying = false;
            this.btn_Inventory.Text = "Start";
        }

        void GetGroupValue()
        {
            DateTime start = DateTime.Now;
            handler.EventGroupBack += Handler_EventGroupBack;
            while ((DateTime.Now - start).TotalSeconds <= 10)
            {
                progressBar1.Value = progressBar1.Value += 10;
                Thread.Sleep(1000);
            }
            handler.EventGroupBack -= Handler_EventGroupBack;
            progressBar1.Value = 100;
            this.progressBar1.Visible = false;

            handler.UdpDisconnect();

            if (dropList.Count < 1)
            {
                this.comboBox1.Items.Clear();
                this.comboBox1.Text = "";

                this.Devmes.AppendText("[" + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + "]" + "IP address not found." + Environment.NewLine);
                this.Devmes.ScrollToCaret();
            }
            else
            {

                HashSet<string> groups = new HashSet<string>(dropList);
                dropList = new List<string>(groups);

                this.comboBox1.Items.Clear();
                this.comboBox1.Items.AddRange(dropList.ToArray());

                this.comboBox1.Text = dropList.FirstOrDefault();
            }
        }

        private void Handler_whenReceivedTag(Tag tag)
        {
            lock (tagQueue)
            {
                singluationCount++;
                tagQueue.Enqueue(tag);
            }
        }

        // Update DataTable
        private void HandleTagsInQueue(object state)
        {
            while (true)
            {
                Tag tag = null;
                lock (tagQueue)
                {
                    if (tagQueue.Count > 0)
                    {
                        tag = tagQueue.Dequeue(); // get first Tag
                    }
                }

                if (tag != null)
                {
                    // Update DataTable
                    UpdateDataTableWithTag(tag);
                }

                if (tagQueue.Count == 0)
                {
                    Thread.Sleep(10);
                }
            }
        }

        // Update DataTable
        private void UpdateDataTableWithTag(Tag tag)
        {
            try
            {
                //Find same EPC
                DataRow existingRow = dt.Rows.Find(tag.EPC);

                if (existingRow != null)
                {
                    // Have same EPC,update Count
                    int currentCount = Convert.ToInt32(existingRow["Count"]);
                    if (rabRSSIOFF.Checked)
                    {
                        existingRow["RSSI"] = "-";
                        existingRow["Frequency"] = "-";
                        existingRow["Phase"] = "-";
                    }
                    else
                    {
                        existingRow["RSSI"] = Convert.ToString(tag.Rssi);
                        existingRow["Frequency"] = Convert.ToString(tag.Frequency);
                        existingRow["Phase"] = Convert.ToString(tag.Phase);
                    }

                    existingRow["Count"] = currentCount + 1;
                    existingRow["Time"] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    existingRow["TID"] = Convert.ToString(tag.TID);
                    existingRow["AntID"] = tag.AntID;
                }
                else
                {
                    //New EPC,add new row.
                    DataRow dr = dt.NewRow();
                    dr["Index"] = dt.Rows.Count + 1;
                    dr["PC"] = tag.PC;
                    dr["EPC"] = tag.EPC;
                    dr["AntID"] = tag.AntID;

                    if (rabRSSIOFF.Checked)
                    {
                        dr["RSSI"] = "-";
                        dr["Frequency"] = "-";
                        dr["Phase"] = "-";
                    }
                    else
                    {
                        dr["RSSI"] = tag.Rssi;
                        dr["Frequency"] = tag.Frequency;
                        dr["Phase"] = tag.Phase;
                    }
                    dr["Count"] = 1; // initial value
                    dr["Time"] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    dr["TID"] = tag.TID;

                    dt.Rows.Add(dr);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Error processing tag: {ex.Message}");
            }
        }

        private void UpdateDataTable(object state)
        {
            try
            {
                label27.Text = tagQueue.Count.ToString();

                if (!Inventorying && _count > 1) return;

                if (!Inventorying)
                {
                    _count += 1;
                }

                if (Application.OpenForms.Count > 0 && Application.OpenForms[0].InvokeRequired)
                {
                    Application.OpenForms[0].Invoke(new Action(() => UpdateDataTable(null)));
                    return;
                }

                label18.Text = singluationCount.ToString();
                label20.Text = dt.Rows.Count.ToString();
                if (dt.Rows.Count == 0)
                {
                    label21.Text = "0";
                }
                else
                {
                    label21.Text = (singluationCount - LastCount).ToString("F2");
                    LastCount = singluationCount;
                }

                lock (dataLock)
                {
                    DatalistView.Items.Clear();

                    DataRowCollection aaa = dt.Rows;
                    foreach (DataRow row in aaa)
                    {
                        DatalistView.Invoke(new Action(() =>
                        {
                            ListViewItem item = new ListViewItem();
                            item.Text = row["Index"].ToString();
                            item.SubItems.Add(row["PC"].ToString());
                            item.SubItems.Add(row["EPC"].ToString());
                            item.SubItems.Add(row["AntID"].ToString());
                            item.SubItems.Add(row["RSSI"].ToString());
                            item.SubItems.Add(row["Phase"].ToString());
                            item.SubItems.Add(row["Frequency"].ToString());
                            item.SubItems.Add(row["Count"].ToString());  // Use integer type
                            item.SubItems.Add(row["Time"].ToString());
                            item.SubItems.Add(row["TID"].ToString());

                            this.DatalistView.Items.Add(item);
                        }));
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message);
            }
        }

        #endregion

    }
}