﻿using Microsoft.VisualBasic.Logging;
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Diagnostics.Eventing.Reader;
using System.DirectoryServices.ActiveDirectory;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using static System.Runtime.InteropServices.JavaScript.JSType;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.ListView;

namespace AsReader033W_Demo
{
    public class Device
    {
        public event Action<string> EventAnalyzeMessage;
        public event Action<byte[]> WriteMessage;
        public event Action<Tag> whenReceivedTag;
        public event Action<bool> EventStop;

        public static byte[] ConvetIntToHex_2l(int val)
        {
            int velocity = val;

            byte[] output = new byte[2];
            output[0] = (byte)((velocity >> 8) & 0xff);
            output[1] = (byte)(velocity & 0xff);

            return output;
        }
        public static string ByteArrayToHexStringWithSpaces(byte[] ba)
        {
            if (ba.Length < 1) return "-";
            StringBuilder hex = new StringBuilder(ba.Length * 3 - 1); // Subtract 1 because we have one less trailing space  
            for (int i = 0; i < ba.Length; i++)
            {
                hex.AppendFormat("{0:x2}", ba[i]);
                if (i < ba.Length - 1)
                {
                    hex.Append(' ');
                }
            }
            return hex.ToString();
        }
        public static byte[] HexStringToByteArray(string hex)
        {
            int NumberChars = hex.Length;
            byte[] bytes = new byte[NumberChars / 2];
            for (int i = 0; i < NumberChars; i += 2)
            {
                bytes[i / 2] = Convert.ToByte(hex.Substring(i, 2), 16);
            }
            return bytes;
        }
        static string StringToHex(string input)
        {
            StringBuilder hex = new StringBuilder(input.Length * 2);
            foreach (char c in input)
            {
                hex.AppendFormat("{0:x2} ", (int)c);
            }
            return hex.ToString();
        }
        static int FindFirstOnePosition(int number)
        {
            int position = 0;
            while (number > 0)
            {
                if ((number & 1) == 1)
                {
                    return position;
                }
                number >>= 1;
                position++;
            }
            return -1;
        }
        public static string AddSpaceEveryTwoCharacters(string input)
        {
            if (string.IsNullOrEmpty(input))
            {
                return input;
            }

            char[] chars = input.ToCharArray();
            StringBuilder sb = new StringBuilder(chars.Length + (chars.Length / 2));

            for (int i = 0; i < chars.Length; i++)
            {
                sb.Append(chars[i]);
                if ((i + 1) % 2 == 0 && (i + 1) != chars.Length)
                {
                    sb.Append(' ');
                }
            }
            return sb.ToString();
        }


        //----------------------------------------------------------------------------------------------------------


        public void Subinitialization()
        {
            byte[] data = { 0xC0, 0x00, 0x00, 0x00, 0x00, 0x01 };
            WriteMessage?.Invoke(data);
        }

        public void StartInventory(bool TID, bool RSSI, byte anats, int time, int count)
        {
            List<byte> dataL = new List<byte>();

            dataL.Add(Const.COMMAND_HAND);
            dataL.Add(Const.COMMAND_SEND_TYPE);
            dataL.Add(0x66);

            if (TID)
            {
                dataL.Add(0xB0);
            }
            else
            {
                dataL.Add(0xC0);
            }

            if (RSSI)
            {
                dataL.Add(0x01);
            }
            else
            {
                dataL.Add(0x00);
            }

            dataL.Add(anats);

            dataL.AddRange(ConvetIntToHex_2l(time));
            //dataL.Add(0xf0);
            //dataL.Add(0x00);
            dataL.AddRange(ConvetIntToHex_2l(count));

            dataL.AddRange(Const.COMMAND_END);

            WriteMessage?.Invoke(dataL.ToArray());
        }

        public void StopInventory()
        {
            byte[] data = { Const.COMMAND_HAND,
                            Const.COMMAND_SEND_TYPE,
                            0x73,
                            Const.COMMAND_END1,
                            Const.COMMAND_END2
                           };
            WriteMessage?.Invoke(data);
        }

        public void GetepcModuleVersion()
        {
            byte[] data = { Const.COMMAND_HAND,
                            Const.COMMAND_GET_TYPE,
                            0x64,
                            Const.COMMAND_END1,
                            Const.COMMAND_END2
                           };
            WriteMessage?.Invoke(data);
        }

        public void SendCommand(string msg)
        {
            var bytes = HexStringToByteArray(msg);

            WriteMessage?.Invoke(bytes);
        }


        //----------------------------------------------------------------------------------------------------------

        void GetRSSI(byte[] tempRssi, ref double RSSI,
                         byte tempPhase, ref double Phase,
                         byte[] fbyte, ref double Frequency)
        {
            ((char)tempRssi[0]).ToString();
            ((char)tempRssi[1]).ToString();
            ((char)tempRssi[2]).ToString();

            RSSI = Convert.ToDouble(((char)tempRssi[0]).ToString() + ((char)tempRssi[1]).ToString() + ((char)tempRssi[2]).ToString());
            //RSSI = 20.0 * Math.Log10(Math.Pow(2, (tempRssi >> 3 & 0x1f)) * (1 + (tempRssi & 0x07) / Math.Pow(2, 3))) - 110.0;
            Phase = (Convert.ToSingle(tempPhase) / 128.0) * 360.0;
            var tempFrequency = (fbyte[0] << 24) + (fbyte[1] << 16) + (fbyte[2] << 8) + fbyte[3];
            Frequency = tempFrequency / 1000.0;
        }


        void ThreadAnalyzeMessage(object obj)
        {
            try
            {
                string rtn = "";
                string Allmsg = obj.ToString();

                string overSizemsg = Allmsg.Replace(" ", "").Replace("0d0a", ";");//Replace the original byte with a string, and then replace the trailing 0d0a with a specified character for segmentation
                string[] overSizeGroup = overSizemsg.Split(";");

                for (int groupSize = 0; groupSize < overSizeGroup.Length; groupSize++)
                {
                    if (groupSize != 1 && groupSize == overSizeGroup.Length - 1 && !overSizemsg.EndsWith(";"))
                    {
                        rtn = "*" + AddSpaceEveryTwoCharacters(overSizeGroup[groupSize]) + " ";

                        EventAnalyzeMessage?.Invoke(rtn);
                        return;
                    }
                    var one = overSizeGroup[groupSize];
                    if (one.Length > 6)
                    {
                        string Com = one.Substring(4, 2);
                        switch (Com)
                        {
                            case "54":
                                if (!string.IsNullOrEmpty(one))//The content after segmentation cannot be empty (the last group may be empty after segmentation)
                                {
                                    string thiscom = one + "0d0a";//Re-add the package tail information
                                    byte[] hexCom = HexStringToByteArray(thiscom);//Convert back to a byte array

                                    Tag tag = new Tag();
                                    int leanth = hexCom[3] - 2;//0d 0a（2）head（3）length（1）

                                    //Extract valid data
                                    byte[] subArray = new byte[leanth];
                                    Buffer.BlockCopy(hexCom, 4, subArray, 0, leanth);

                                    int ananum = subArray[0];//Antenna
                                    tag.AntID = (byte)(FindFirstOnePosition(ananum) + 1);

                                    int epcLeanth = ((subArray[1] & 0xf8) >> 3) * 2;

                                    if (epcLeanth < 1)
                                    {
                                        tag.EPC = "-";
                                    }
                                    else
                                    {
                                        byte[] epc = new byte[epcLeanth];
                                        Buffer.BlockCopy(subArray, 3, epc, 0, epcLeanth);
                                        tag.EPC = ByteArrayToHexStringWithSpaces(epc).Replace(" ", "").ToUpper();
                                    }

                                    byte[] pc = new byte[2];
                                    Buffer.BlockCopy(subArray, 1, pc, 0, 2);
                                    tag.PC = ByteArrayToHexStringWithSpaces(pc).Replace(" ", "").ToUpper();
                                    if (tag.PC == "0400")
                                    {
                                        int a = 0;
                                    }

                                    int _tmpSize = 1 + 2 + epcLeanth + 3 + 1 + 4;

                                    // PC length bit(2),
                                    // EPC Length(epcLeanth),
                                    // RSSI（3）,
                                    // Phase(1),
                                    // Frequency point(4)

                                    int surplusSize = leanth - _tmpSize;

                                    if (surplusSize > 2)
                                    {
                                        int tidSize = (subArray[_tmpSize + 1] | (subArray[_tmpSize] << 8)) - 2;//0d 0a(2)

                                        byte[] tid = new byte[tidSize];
                                        Buffer.BlockCopy(subArray, _tmpSize + 2, tid, 0, tidSize);
                                        tag.TID = ByteArrayToHexStringWithSpaces(tid).Replace(" ", "").ToUpper();
                                    }
                                    else
                                    {
                                        tag.TID = "-";
                                    }

                                    double RSSI = 0.0;
                                    double Phase = 0.0;
                                    double Frequency = 0.0;


                                    List<byte> RSSI_tmp = new List<byte>();
                                    RSSI_tmp.Add(subArray[epcLeanth + 2 + 1]);
                                    RSSI_tmp.Add(subArray[epcLeanth + 2 + 2]);
                                    RSSI_tmp.Add(subArray[epcLeanth + 2 + 3]);

                                    var Phase_tmp = subArray[epcLeanth + 2 + 4];

                                    List<byte> Frequency_tmp = new List<byte>();
                                    Frequency_tmp.Add(subArray[epcLeanth + 2 + 5]);
                                    Frequency_tmp.Add(subArray[epcLeanth + 2 + 6]);
                                    Frequency_tmp.Add(subArray[epcLeanth + 2 + 7]);
                                    Frequency_tmp.Add(subArray[epcLeanth + 2 + 8]);

                                    GetRSSI(RSSI_tmp.ToArray(), ref RSSI, Phase_tmp, ref Phase, Frequency_tmp.ToArray(), ref Frequency);

                                    tag.Frequency = Frequency;
                                    tag.Phase = Phase.ToString("f2");
                                    tag.Rssi = RSSI.ToString("f2");

                                    Debug.WriteLine("Tag is : " + tag.EPC);

                                    whenReceivedTag?.Invoke(tag);

                                    rtn = "*";
                                }
                                break;
                            case "64":
                                var tmp = one.Replace("7e5264", "").Replace("0d0a", "");

                                rtn = "";
                                for (int i = 0; i < tmp.Length; i += 2)
                                {
                                    // Check whether the remaining characters are sufficient to form a two-digit segment
                                    if (i + 1 < tmp.Length)
                                    {
                                        int asciiValue = Convert.ToInt32(tmp.Substring(i, 2), 16);
                                        char asciiChar = Convert.ToChar(asciiValue);
                                        rtn += asciiChar;
                                    }
                                }
                                rtn = "#" + rtn;
                                break;
                            case "73":
                                bool success = false;
                                if (one == "7e417330303030") success = true;
                                EventStop?.Invoke(success);
                                break;
                            default:
                                rtn = AddSpaceEveryTwoCharacters(one + "0d0a").ToUpper();
                                break;
                        }
                    }
                }
                EventAnalyzeMessage?.Invoke(rtn);
                return;
            }
            catch
            {

            }
        }

        public string AnalyzeMessages(byte[] msg, bool Analyze, string Cuttmp = "")
        {
            string rtn = "";

            try
            {
                string Allmsg = ByteArrayToHexStringWithSpaces(msg);

                if (!string.IsNullOrEmpty(Cuttmp))
                {
                    Allmsg = Cuttmp + Allmsg;
                }

                if (!Analyze)//Not parse
                {
                    rtn = Allmsg;
                    return rtn;
                }
                else
                {
                    Thread thread = new Thread(new ParameterizedThreadStart(ThreadAnalyzeMessage));
                    thread.Start(Allmsg);

                    return "";
                }
            }
            catch
            {
                Debug.WriteLine("----");
                return rtn;
            }
        }

    }
}
