﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Diagnostics;
using System.Linq;
using System.Net.Sockets;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Net.Http;

namespace AsReader033W_Demo
{
    public class ClassTCPClient
    {

        private static volatile ClassTCPClient instance;
        private static object syncRoot = new Object();
        private TcpClient tcpClient;

        private string ipAddress;
        private int port;
        private CancellationTokenSource cts;
        private readonly int readLength = 4096;
        private readonly string userName = ConfigurationManager.AppSettings["UserName"];
        public event Action<byte[]> EventReceiveMessage;
        public event Action<bool> EventConnectState;
        public event Action<Tag> whenReceivedTag;

        public event Action<int> EventConnectStateNumber;


        int num = 0;

        private ClassTCPClient()
        {
            tcpClient = new TcpClient();
        }
        public static ClassTCPClient Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new ClassTCPClient();
                    }
                }
                return instance;
            }
        }
        
        public void Connect(string ipAddress, int port)
        {
            num = 0;

            this.ipAddress = ipAddress;
            this.port = port;

            if (tcpClient.Connected)
            {
                Debug.WriteLine($"Already connected to server：{tcpClient.Connected}");
                EventConnectState?.Invoke(tcpClient.Connected);
                return;
            }

            Debug.WriteLine("Begin connect to server");
            Task.Factory.StartNew(() =>
            {
                while (!tcpClient.Connected)
                {
                    if (num++ >= 3)
                    {
                        return;
                    }
                    Debug.WriteLine("Reconnect...");
                    EventConnectStateNumber?.Invoke(num * 25);
                    try
                    {
                        tcpClient.Connect(ipAddress, port);
                    }
                    catch (Exception ex)
                    {
                        Debug.WriteLine("Failed to connect to server:{0}", ex.Message);
                        if (!tcpClient.Connected && num >=3)
                        {
                            EventConnectState?.Invoke(tcpClient.Connected);
                        }
                        tcpClient = new TcpClient();
                    }
                    finally
                    {
                        Thread.Sleep(1000);
                    }
                }
                EventConnectState?.Invoke(tcpClient.Connected);
                Debug.WriteLine("Successed to connect to server:{0}", tcpClient.Connected);
                try
                {
                    cts = new CancellationTokenSource();
                    Task.Factory.StartNew(() =>
                    {
                        SendHeartBeat();
                    }, cts.Token);

                    Task.Factory.StartNew(() =>
                    {
                        ListenForMessage();
                    }, cts.Token);
                }
                catch (Exception ex)
                {
                    Debug.WriteLine("Task.Factory.StartNew Fail:{0}", ex.Message);
                    throw ex;
                }
            });
        }

        public void Disconnect()
        {
            try
            {
                tcpClient?.Close();
                tcpClient?.Dispose();
                //tcpClient = new TcpClient();
                cts?.Cancel();
            }
            catch (Exception ex)
            {
                Debug.WriteLine($"Disconnect Fail:{ex.Message}");
                throw ex;
            }
        }

        private void ListenForMessage()
        {
            try
            {
                NetworkStream stream = tcpClient.GetStream();
                while (!cts.Token.IsCancellationRequested)
                {
                    byte[] bytes = new byte[4096];
                    try
                    {
                        int bytesRead = stream.Read(bytes, 0, readLength);
                        if (bytesRead == 0)
                        {
                            break;
                        }
                        string message = "";
                        try
                        {
                            message = Encoding.UTF8.GetString(bytes, 0, bytesRead);
                        }
                        catch (Exception ex)
                        {
                            Debug.WriteLine($"GetString Fail:{ex.Message}");
                        }
                        Console.WriteLine($"Read Message:{message}");
                        //EventReceiveMessage?.Invoke(message); 

                        byte[] subArray = new byte[bytesRead];
                        Buffer.BlockCopy(bytes, 0, subArray, 0, bytesRead);

                        EventReceiveMessage?.Invoke(subArray);
                    }
                    catch (Exception ex)
                    {
                        Debug.WriteLine($"NetworkStream Read Fail：{ex.Message}");
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine($"GetStream Fail:{ex.Message}");
            }

        }

        public void WriteMessage(byte[] data)
        {
            try
            {
                NetworkStream stream = tcpClient.GetStream();
                stream.Write(data, 0, data.Length);
                Thread.Sleep(100);
            }
            catch (Exception ex)
            {
                Debug.WriteLine($"NetworkStream Write Fail: {ex.Message}");
                if (!tcpClient.Connected)
                {
                    Debug.WriteLine("Server disconnect");
                }
            }
        }
        
        private void SendHeartBeat()
        {
            string message = AssembleHeartBeat();
            try
            {
                NetworkStream stream = tcpClient.GetStream();
                while (!cts.Token.IsCancellationRequested)
                {
                    try
                    {
                        byte[] data = Encoding.UTF8.GetBytes(message);
                        try
                        {
                            Debug.WriteLine("Send HeartBeat");
                            stream.Write(data, 0, data.Length);
                            Thread.Sleep(300000);
                        }
                        catch (Exception ex)
                        {
                            Debug.WriteLine($"NetworkStream Write Fail: {ex.Message}");
                            if (!tcpClient.Connected)
                            {
                                Debug.WriteLine("Server disconnect");
                            }
                            break;
                        }
                    }
                    catch (Exception ex)
                    {
                        Debug.WriteLine($"GetBytes Fail:{ex.Message}");
                        break;
                    }

                }
                //stream.Flush();
                //stream.Close();
            }
            catch (Exception ex)
            {
                Debug.WriteLine($"GetStream Fail:{ex.Message}");
            }
        }

        private string AssembleHeartBeat()
        {
            string message = ":";
            try
            {
                var hostName = Dns.GetHostName();
                message = userName;
                var ipAddresses = Dns.GetHostAddresses(hostName);
                foreach (var ipAddress in ipAddresses)
                {
                    if (ipAddress.AddressFamily == AddressFamily.InterNetwork)
                    {
                        var localIp = ipAddress.ToString();
                        message += ":" + localIp;
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine($"AssembleHeartBeat Fail:{ex.Message}");
            }
            return message;
        }

        public void BackTag(Tag tag)
        {
            whenReceivedTag?.Invoke(tag);
        }
    }
}
