﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using uPLibrary.Networking.M2Mqtt;
using uPLibrary.Networking.M2Mqtt.Messages;


namespace AsReader033W_Demo
{

    public class ClassMqttClient
    {
        // Singleton pattern
        private static volatile ClassMqttClient instance;
        private static object syncRoot = new Object();

        private MqttClient _mqttClient = null;

        public string clientID = Guid.NewGuid().ToString();

        public event Action<byte[]> EventReceiveMessage;
        public event Action<bool> EventConnectState;

        public bool HttpNotRuning = true;

        private ClassMqttClient()
        {
        }

        public static ClassMqttClient Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new ClassMqttClient();
                    }
                }
                return instance;
            }
        }


        public void MqttClientStart(string IP)
        {
            try
            {
                _mqttClient = new MqttClient(IP);

                _mqttClient.Connect(clientID, "", "", true, 10);

                String subtopic1 = "HEX_OUT";

                Debug.WriteLine("------------------------------------------------------");
                Debug.WriteLine(subtopic1);
                Debug.WriteLine("------------------------------------------------------");

                _mqttClient.Subscribe(new string[] { subtopic1 }, new byte[] { MqttMsgBase.QOS_LEVEL_EXACTLY_ONCE });
                _mqttClient.MqttMsgPublishReceived -= _mqttClient_ApplicationMessageReceivedAsync;
                _mqttClient.MqttMsgPublishReceived += _mqttClient_ApplicationMessageReceivedAsync;
                EventConnectState?.Invoke(true);
            }
            catch (Exception ex)
            {
                _mqttClient.MqttMsgPublishReceived -= _mqttClient_ApplicationMessageReceivedAsync;
                _mqttClient = null;
                EventConnectState?.Invoke(false);
            }
        }

        public void MqttClientStop()
        {

            //_mqttClient.MqttMsgPublishReceived -= _mqttClient_ApplicationMessageReceivedAsync;
            if (_mqttClient != null)
            {
                _mqttClient.Disconnect();
                _mqttClient = null;
            }
        }

        private void _mqttClient_ApplicationMessageReceivedAsync(object sender, MqttMsgPublishEventArgs e)
        {
            string Msg = Encoding.Default.GetString(e.Message);
            string Topic = e.Topic;

            EventReceiveMessage?.Invoke(e.Message);
        }

        public void Publish(string data, string topic = "HEX_IN")
        {
            _mqttClient.Publish(topic, Encoding.Default.GetBytes(data), MqttMsgBase.QOS_LEVEL_AT_MOST_ONCE, false);
        }

        public void Publish(byte[] data, string topic = "HEX_IN")
        {
            Debug.WriteLine("MQTT Output Message：" + Device.ByteArrayToHexStringWithSpaces(data).ToUpper() + "   Topic:" + topic);

            _mqttClient.Publish(topic, data, MqttMsgBase.QOS_LEVEL_AT_MOST_ONCE, false);

        }
    }
}
