#include <iostream>
#include <memory.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <errno.h>
#include <iostream>

#include <unistd.h>
#include <net/if.h>

#include "PubConvert.hpp"
#include "TCPClient.hpp"

#include <list>

#include <sys/time.h>

#define MCAST_PORT 8161
#define MCAST_ADDR "230.1.1.169"
#define MCAST_INTERVAL 1
#define BUFF_SIZE 1024

// #define MCAST_PORT 8888
// #define MCAST_ADDR "224.0.0.88"
// #define MCAST_INTERVAL 5
// #define BUFF_SIZE 256

int32_t Inventory = 0;
bool needStop = false;

struct timeval InventoryStart, InventoryEnd;

int InventoryOvertime = 0;
int InventoryOverRC = 0;

using namespace std;

void Get_RSSI(uint8_t rssibyte[], double &RSSI,
              uint8_t tempPhase, double &PHASE,
              uint8_t fbyte[], double &FREQUENCY)
{
    // RSSI = 20.0*log10(pow(2,(tempRssi>>3 &0x1f))*(1+(tempRssi &0x07)/pow(2,3))) -110.0;
    RSSI = stod(HexToASCIIString(rssibyte[0]) + HexToASCIIString(rssibyte[1]) + HexToASCIIString(rssibyte[2]));
    PHASE = (tempPhase / 128.0) * 360.0;
    auto tempFrequency = (fbyte[0] << 24) + (fbyte[1] << 16) + (fbyte[2] << 8) + fbyte[3];
    FREQUENCY = tempFrequency / 1000.0;
}

void StartInventory(bool haveTid, bool RSSI, int antenna, int overtime, int RC, std::shared_ptr<Client> client)
{
    string msg = "";
    msg += "7E,61,66,";
    if (haveTid)
    {
        msg += "B0,";
    }
    else
    {
        msg += "C0,";
    }

    if (RSSI)
    {
        msg += "01,";
    }
    else
    {
        msg += "00,";
    }

    InventoryOvertime = overtime;
    InventoryOverRC = RC;

    msg += IntToHexstring(antenna) + ",";
    msg += NumberToTwoBytesString(overtime) + ",";
    msg += NumberToTwoBytesString(RC) + ",";
    msg += "0D,0A";

    Inventory = 0; 

    gettimeofday(&InventoryStart, NULL); 
    std::cout << InventoryStart.tv_sec << std::endl;

    // cout<<msg<<endl;
    // auto Com =  Hexstring2Byte(msg);
    client->sendMessage(msg);
    // client->sendMessage("7E,61,66,C0,01,07,00,00,00,00,0D,0A");
    while (std::tolower(std::cin.get()) != 's')
    {
        // this_thread::sleep_for(std::chrono::seconds(1));
    }
    client->sendMessage("7E,61,73,0D,0A");
    // system("clear");
}

void SendCommend(string msg, std::shared_ptr<Client> client)
{
    client->sendMessage(msg);
}

std::list<string> IPlist;

bool groupback;
int grouptime = 0;

void threadGetGroup()
{
    while (grouptime < 10)
    {
        if (groupback)
        {
            grouptime += 10;
        }
        else
        {
            grouptime++;
            sleep(1);
        }
    }
    if (!groupback)
    {
        cout << "IP address not found." << endl;
        abort();
    }
}

void GetGroupPub(int num)
{
    int sockfd;
    struct sockaddr_in local_addr;
    struct ip_mreq mreq;
    char buff[BUFF_SIZE];
    int n;

    sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sockfd == -1)
    {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    memset(&local_addr, 0, sizeof(local_addr));
    local_addr.sin_family = AF_INET;
    local_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    local_addr.sin_port = htons(MCAST_PORT);

    if (bind(sockfd, (struct sockaddr *)&local_addr, sizeof(local_addr)) == -1)
    {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    mreq.imr_multiaddr.s_addr = inet_addr(MCAST_ADDR);
    mreq.imr_interface.s_addr = htonl(INADDR_ANY);
    if (setsockopt(sockfd, IPPROTO_IP, IP_ADD_MEMBERSHIP, &mreq, sizeof(mreq)) == -1)
    {
        perror("setsockopt: IP_ADD_MEMBERSHIP");
        exit(EXIT_FAILURE);
    }
    system("clear");

    cout << "Group connected,Waiting..." << endl;
    groupback = false;
    std::thread th(threadGetGroup);
    th.detach();

    // cout<<"############################"<<endl;

    for (int times = 1; times <= num; times++)
    {
        socklen_t addr_len = sizeof(local_addr);
        memset(buff, 0, BUFF_SIZE);
        n = recvfrom(sockfd, buff, BUFF_SIZE, 0, (struct sockaddr *)&local_addr, &addr_len);
        if (n == -1)
        {
            perror("recvfrom");
            exit(EXIT_FAILURE);
        }

        std::cout << 5 - times << "..." << std::endl;

        string tmp = buff;
        tmp.erase(std::remove(tmp.begin(), tmp.end(), ','), tmp.end());
        auto group = splitString(tmp, '\n');
        std::string _tmpgroup = "";
        for (int i = 0; i < group.size(); i++)
        {
            string thisone = group[i];
            // _tmpgroup += thisone + "\n";
            // cout<<thisone<<endl;
            if (StartsWith(thisone, "HOST_SERVER_IP:"))
            {
                thisone = replaceAllSubstr(thisone, "HOST_SERVER_", "");
                _tmpgroup += thisone + "\n";
            }
            else if (StartsWith(thisone, "HOST_SERVER_PORT:"))
            {
                thisone = replaceAllSubstr(thisone, "HOST_SERVER_", "");
                _tmpgroup += thisone + "\n";
            }
            else if (StartsWith(thisone, "MAC:"))
            {
                _tmpgroup += thisone + "\n";
                // cout<<thisone<<endl;
            }
            else if (StartsWith(thisone, "RFID_READER_INFORMATION:"))
            {
                thisone = replaceAllSubstr(thisone, "RFID_READER_INFORMATION", "MANUFACTURE NUMBER");
                _tmpgroup += thisone + "\n";
                // cout<<thisone<<endl;
            }
        }
        IPlist.push_back(_tmpgroup);

        // Print information
        groupback = true;
        // Wait for a period of time
        sleep(MCAST_INTERVAL);
    }

    IPlist.sort();
    IPlist.unique();
    IPlist.erase(std::unique(IPlist.begin(), IPlist.end()), IPlist.end());

    int ipcount = 1;
    for (auto oneip : IPlist)
    {
        cout << "###########    " << ipcount++ << "    ###########" << endl;
        cout << oneip << endl;
    }
    cout << "###############################" << endl;

   
    if (setsockopt(sockfd, IPPROTO_IP, IP_DROP_MEMBERSHIP, &mreq, sizeof(mreq)) == -1)
    {
        perror("setsockopt: IP_DROP_MEMBERSHIP");
        exit(EXIT_FAILURE);
    }
    close(sockfd);
}

void printMessage(const std::string &message)
{
    std::cout << "------------------------------------------------------------------" << std::endl;
    std::vector<uint8_t> byteArray(message.size());
    string tmpHex = "";
    for (size_t i = 0; i < message.size(); ++i)
    {
        byteArray[i] = static_cast<uint8_t>(message[i]);
        tmpHex += ByteToHexString(byteArray[i]);
    }

    string tmpCommend = "";
    vector<uint8_t> com;

    std::vector<std::string> result;

    switch (byteArray[2])
    {
    case 0x64:
        tmpHex = replaceAllSubstr(tmpHex, "7e5264", "");
        tmpHex = replaceAllSubstr(tmpHex, "0d0a", "");

        com = HexstringToByteGroup(tmpHex);
        for (int j = 0; j < com.size(); j++)
        {
            tmpCommend += static_cast<char>(com[j]);
        }

        // std::cout<<"Device Type is :"<<tmpCommend<<std::endl;
        break;
    case 0x54:
        tmpHex = replaceAllSubstr(tmpHex, "0d0a", ";");
        result = splitString(tmpHex, ';');

        for (auto &str : result)
        {
            // std::cout<<str<<std::endl;

            com = HexstringToByteGroup(str);
            if (com.size() > 3)
            {
                int leanth = com[3] - 2;                                                  // 0d0a occupies two length units, which have been replaced and truncated here
                std::vector<uint8_t> subArray(com.begin() + 4, com.begin() + 4 + leanth); // Extract valid bits

                std::cout << "ANTENNA：" << FindFirstOnPosition(subArray[0]) + 1; // The first bit is the antenna position
                // std::cout<<"Antenna position："<<ByteToHexString(subArray[0]);//The first bit is the antenna position

                int epcLeanth = ((subArray[1] & 0xf8) >> 3) * 2; // The second bit is the epc data length (here is the digit length)
                // std::cout<<"\tEPC length："<<epcLeanth;//The output data length needs to be *2
                std::vector<uint8_t> ArrayPC(subArray.begin() + 1, subArray.begin() + 1 + 2);          // Extract valid bits
                std::vector<uint8_t> ArrayEPC(subArray.begin() + 3, subArray.begin() + 3 + epcLeanth); // Extract valid bits

                std::cout << "\tPC：";
                for (auto &_pc : ArrayPC)
                {
                    cout << ByteToHexString(_pc);
                }

                int _tmpSize = 1 + 2 + epcLeanth + 3 + 1 + 4;
                int surplusSize = leanth - _tmpSize;
                // std::cout<<"\tTID length："<<surplusSize;

                if (surplusSize > 2)
                {
                    int tidSize = (subArray[_tmpSize + 1] | subArray[_tmpSize] << 8);
                    std::vector<uint8_t> ArrayTID(subArray.begin() + _tmpSize + 2, subArray.begin() + _tmpSize + 2 + tidSize); // 截取有效位
                    std::cout << "\tTID ：";
                    for (auto &_tid : ArrayTID)
                    {
                        cout << toUpperCase(ByteToHexString(_tid));
                    }
                }

                double RSSI;
                double PHASE;
                double FREQUENCY;

                uint8_t tmprssi[3];
                uint8_t tmpfreq[4];
                uint8_t tmpphase;

                tmprssi[0] = com[epcLeanth + 3 + 3 + 1];
                tmprssi[1] = com[epcLeanth + 3 + 3 + 2];
                tmprssi[2] = com[epcLeanth + 3 + 3 + 3];

                tmpphase = com[epcLeanth + 3 + 3 + 4];

                tmpfreq[0] = com[epcLeanth + 3 + 3 + 5];
                tmpfreq[1] = com[epcLeanth + 3 + 3 + 6];
                tmpfreq[2] = com[epcLeanth + 3 + 3 + 7];
                tmpfreq[3] = com[epcLeanth + 3 + 3 + 8];

                Get_RSSI(tmprssi, RSSI,
                         tmpphase, PHASE,
                         tmpfreq, FREQUENCY);

                std::cout << "\tRSSI : " << RSSI;
                std::cout << "\tPHASE : " << PHASE;
                std::cout << "\tFREQUENCY : " << FREQUENCY;

                std::cout << std::endl;

                std::cout << "EPC:";

                for (auto &_epc : ArrayEPC)
                {
                    cout << toUpperCase(ByteToHexString(_epc));
                }

                Inventory++;

                char buffer[50];
                sprintf(buffer, "%d", Inventory);
                std::string str(buffer);

                std::cout << "\t\tTotal： " << str << std::endl;

                if (InventoryOverRC != 0)
                {
                    if (Inventory >= InventoryOverRC)
                    {
                        needStop = true;
                    }
                }
            }
        }
        tmpCommend = "1";
        break;

    default:
        std::cout << "Received from reader: ";
        for (uint8_t byte : byteArray)
        {
            std::cout << std::hex << std::setw(2) << std::setfill('0') << static_cast<int>(byte) << " ";
        }
        break;
    }
    std::cout << std::endl;
}

void threadFunction(std::shared_ptr<Client> client)
{
    while (true)
    {
        if (needStop)
        {
            std::cout << "#";
            client->sendMessage("7E,61,73,0D,0A");
            needStop = false;
            std::cout << "Enter （s） exit Inventory" << std::endl;
        }

        if (InventoryOvertime != 0)
        {
            gettimeofday(&InventoryEnd, NULL);
            double elapsed_time = (InventoryEnd.tv_sec - InventoryStart.tv_sec) + (InventoryEnd.tv_usec - InventoryStart.tv_usec) / 1e6;
            if (elapsed_time > InventoryOvertime)
            {
                std::cout << elapsed_time;
                std::cout << " # ";
                client->sendMessage("7E,61,73,0D,0A");
                std::cout << "Enter （s） exit Inventory" << std::endl;
                InventoryOvertime = 0;
            }
        }
        sleep(1);
    }
}

int main()
{
    string Searchbool;
    std::cout << "Search for online devices？（y/n） ";
    std::cin >> Searchbool;
    if (Searchbool == "y" || Searchbool == "Y")
    {
        GetGroupPub(5);
    }

    string server; 
    int port = 9600;
    std::cout << std::endl;
    std::cout << std::endl;
    std::cout << std::endl;
    std::cout << std::endl;
    std::cout << "\t\t******************************************" << endl;
    std::cout << "\t\tPlease input the IP address:";
    cin >> server;
    // std::cout << "\t\tPlease input the port:";
    // cin >> port;

    //    Client client(server,port);
    auto client = std::make_shared<Client>(server, port);
    //    auto client = std::make_shared<Client>("192.168.5.142",9600);

    if (client->start(printMessage))
    {
        std::cout << "Connection succeeded" << std::endl;
        sleep(1); 
    }
    else
    {
        std::cout << "Connection failed" << std::endl;
        return 0;
    }

    client->sendMessage("C0,00,00,00,00,01");
    sleep(1); 
    client->sendMessage("7E,72,64,0D,0A");
    sleep(1); 

    std::thread myThread(threadFunction, client);
    myThread.detach();

    string command; // Store the input command
    while (true)
    {
        std::cout << "\t\t******************************************" << endl;
        std::cout << "\t\t1） \t\tInventory" << endl;
        std::cout << "\t\t2） \t\tStop Inventory" << endl;
        std::cout << "\t\t3） \t\tCommand" << endl;
        std::cout << "\t\t9） \t\tDisconnect" << endl;
        std::cout << "\t\t******************************************" << endl;
        std::cout << "\t\tPlease enter the instruction code: ";

        cin >> command;

        transform(command.begin(), command.end(), command.begin(), ::toupper);

        if (command == "1")
        {
            system("clear");
            int overtime = 0;
            int repeattimes = 0;
            string tmp_overtime = "0";
            string tmp_repeattimes = "0";

            string ana;

            string tid;
            bool tid_b = false;

            string rssi;
            bool rssi_b = false;

            std::cout << "Enter （s） Stop Inventory" << std::endl;
            std::cout << "-------------------------------" << std::endl;

            std::cout << "TID Enabled（y/n） ";
            std::cin >> tid;

            if (tid == "y")
            {
                tid_b = true;
            }

            // std::cout << "RSSI Enabled（y/n） ";
            // std::cin >>rssi;

            // if(rssi == "y")
            // {
            //     rssi_b = true;
            // }

            // Enter an 8-bit binary string
            std::cout << "Please enter a sequence of 0 and 1 with a length of 8 to control the on/off states of 8 antennas (1-on,0-off):";
            std::cin >> ana;

            // Check if the input is valid
            if (ana.length() != 8 || !std::all_of(ana.begin(), ana.end(), [](char c)
                                                  { return c == '0' || c == '1'; }))
            {
                std::cerr << "Invalid input. Please input a sequence of  0 and 1 with a length of 8." << std::endl;
                continue;
            }

            std::cout << "Please input the elapsed time of the inventory(Unit:s):";
            cin >> tmp_overtime;

            // std::cout << "Please input the elapsed  count of the inventory:";
            // cin >> tmp_repeattimes;

            try
            {
                overtime = std::stoi(tmp_overtime);
            }
            catch (const std::invalid_argument &)
            {
                overtime = 0;
            }
            catch (const std::out_of_range &)
            {
                overtime = 0;
            }

            try
            {
                repeattimes = stoi(tmp_repeattimes);
            }
            catch (const std::invalid_argument &)
            {
                repeattimes = 0;
            }
            catch (const std::out_of_range &)
            {
                repeattimes = 0;
            }

            // Reverse antenna number (from 00000001 to 10000000)
            ana = reverse_binary_string(ana);
            // Convert to integer
            int decimalValue = BinaryToInt(ana);

            StartInventory(tid_b, rssi_b, decimalValue, overtime, repeattimes, client);

            Inventory = 0;
        }
        else if (command == "2")
        {
            system("clear");

            // std::cout<<"Enter （s） Stop tInventory"<<std::endl;

            // while (std::tolower(std::cin.get()) != 's')
            // {
            //         // this_thread::sleep_for(std::chrono::seconds(1));
            // }
            client->sendMessage("7E,61,73,0D,0A");
        }
        else if (command == "3")
        {
            system("clear");
            string commendmsg = "";
            std::cout << "Enter hexadecimal operation instructions, with characters separated by 【,】.";
            cin >> commendmsg;

            SendCommend(commendmsg, client);
        }
        else if (command == "9")
        {
            break; // 如果输入了"exit"则结束循环
        }
        else
        {
            system("clear");
            cout << "Successfully received command：" << command << endl;
        }
        sleep(1);
    }

    // cls.Disconnect();
    cout << "Disconnected" << endl;
    sleep(1);

    return 0;
}