#include <string>
#include <vector>
#include <sstream>  
#include <algorithm>
#include <codecvt>
#include <cmath>
#include <iomanip>
#include <cctype> 

#include <iostream>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sstream>

#include <vector>
#include <bitset>


using namespace std;

/// @brief Split a string into a vector of strings by the specified delimiter
/// @param str 
/// @param delimiter 
/// @return 
static std::vector<std::string> splitString(const std::string& str, char delimiter) {  
    std::vector<std::string> tokens;  
    std::string token;  
    std::stringstream ss(str);  
  
    while (std::getline(ss, token, delimiter)) {  
        tokens.push_back(token);  
    }  
  
    return tokens;  
}

/// @brief Replace all occurrences of the specified substring in a string with a new substring
/// @param subject 
/// @param search 
/// @param replace 
/// @return 
static std::string replaceAllSubstr(std::string subject, const std::string& search, const std::string& replace) {  
    size_t pos = 0;  
    std::string result;  
    result.reserve(subject.size()); // Optional: reserve enough space to improve performance  
  
    while ((pos = subject.find(search, pos)) != std::string::npos) {  
        result += subject.substr(0, pos); // Add the part before the match  
        result += replace;                // Add the replacement string  
        subject.erase(0, pos + search.length()); // Remove the processed part  
    }  
    result += subject; // Add the remaining part (if any)  
  
    return result;  
}

/// @brief Convert an int number to a hexadecimal string 
/// @param number 
/// @return Example: 15 = "0f"
static string IntToHexstring(int number)
{
    std::string hexString;  
    std::stringstream ss;  
    // Output the integer as a hexadecimal format to the string stream  
    ss << std::hex <<std::setw(2) << std::setfill('0') <<number;  
    ss >> hexString;  

    return hexString;
}

/// @brief Convert a hexadecimal string (split by ',') to a byte array
/// @param val 
/// @return Example: aa,bb = [0xaa,0xbb]
static vector<uint8_t> HexstringToByteGroup(string val)
{
    vector<uint8_t> rtn;

	for (int i = 0; i < val.length(); i++) 
    {
  	if (val[i] == ',') {
    	val.replace(i, 1, "");
 	 }
	}

    for(int i=0;i<val.length()/2;i++)
    {
        rtn.push_back(static_cast<uint8_t>(stoi(val.substr(i*2,2),0,16)));
    }
    return rtn;
}

/// @brief Convert a binary string to an int value
/// @param binaryStr 
/// @return Example: "11111111"= 255 
static int BinaryToInt(const std::string& binaryStr)
{  
    int value = 0;  
    for (char bit : binaryStr) {  
        if (bit == '1') {  
            value = (value << 1) | 1;  
        } else {  
            value <<= 1;  
        }  
    }  
    return value;  
}  

/// @brief Output the byte value directly as a string
/// @param byte 
/// @return Example: 0xFF = "FF"
static std::string  ByteToHexString(uint8_t byte)
 {  
    std::ostringstream oss;  
    oss << std::hex << std::setw(2) << std::setfill('0') << static_cast<int>(byte);  
    return oss.str();  
} 

std::string toUpperCase(const std::string& str) {
    std::string result = str;
    for (size_t i = 0; i < result.size(); ++i) {
        if (std::islower(result[i])) { // Check if it is a lowercase letter
            result[i] = std::toupper(result[i]); // Convert to uppercase letter
        }
    }
    return result;
}

/// @brief Split a number into high byte and low byte
/// @param number 
/// @param highByte 
/// @param lowByte 
/// @return Example: 256 = 01 00
static void NumberToTwoBytes(int number, uint8_t& highByte, uint8_t& lowByte)
 {  
    // Treat number as a 16-bit integer and split into high 8 bits and low 8 bits  
    highByte = static_cast<uint8_t>((number >> 8) & 0xFF);  
    lowByte = static_cast<uint8_t>(number & 0xFF);  
} 

/// @brief Split a number into high byte and low byte and combine as a string separated by ','
/// @param number 
/// @return Example: 256 = “0100”
static string NumberToTwoBytesString(int number)
{
    uint8_t highByte = 0;  
    uint8_t lowByte = 0;  

    if(number<=255)
    {
        lowByte = static_cast<uint8_t>(number);  
    }
    else
    {
        highByte = static_cast<uint8_t>((number >> 8) & 0xFF);  
        lowByte = static_cast<uint8_t>(number & 0xFF); 
    }

    std::string h = ByteToHexString(highByte); 
    std::string l = ByteToHexString(lowByte); 

    return h+","+l;
}

/// @brief Convert a number to binary and return the lowest bit position (starting from 0) where 1 appears
/// @param number 
/// @return Example: 8 = 1000 = 3
static int FindFirstOnPosition(int number)
{
    int pos = 0;
    while(number>0)
    {
        if((number & 1) == 1)
        {
            return pos;
        }
        number >>= 1;
        pos++;
    }

    return -1;
}


static string HexToASCIIString(uint8_t hexValue)
{
    // Convert byte value to char, this will get the corresponding ASCII character
    char asciiChar = static_cast<char>(hexValue);
    // Convert char to string
    std::string asciiStr(1, asciiChar);

    return asciiStr;
}

bool StartsWith(const std::string& fullString, const std::string& starting) {
    if (fullString.length() >= starting.length()) 
    {
        // std::cout<<"|||"<<fullString<<"<----->"<<starting<<std::endl;
        return (0 == fullString.compare(0, starting.length(), starting));
    } else {
        return false;
    }
}

std::string reverse_binary_string(const std::string& s) {
    if (s.length() != 8) {
        throw std::invalid_argument("Input string must be 8 characters long.");
    }
    std::bitset<8> bits(s);
    std::bitset<8> reversed_bits;
    for (int i = 0; i < 8; ++i) {
        reversed_bits[i] = bits[7 - i]; // Reverse each bit
    }
    return reversed_bits.to_string();
}
