#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define MCAST_PORT 8888
#define MCAST_ADDR "224.0.0.88"
#define MCAST_INTERVAL 5
#define BUFF_SIZE 256

int main(void)
{
    int sockfd;
    struct sockaddr_in local_addr;
    struct ip_mreq mreq;
    char buff[BUFF_SIZE];
    int n;

    sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sockfd == -1)
    {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    memset(&local_addr, 0, sizeof(local_addr));
    local_addr.sin_family = AF_INET;
    local_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    local_addr.sin_port = htons(MCAST_PORT);

    if (bind(sockfd, (struct sockaddr*)&local_addr, sizeof(local_addr)) == -1)
    {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    int loop = 1;
    if (setsockopt(sockfd, IPPROTO_IP, IP_MULTICAST_LOOP, &loop, sizeof(loop)) == -1)
    {
        perror("setsockopt: IP_MULTICAST_LOOP");
        exit(EXIT_FAILURE);
    }

    mreq.imr_multiaddr.s_addr = inet_addr(MCAST_ADDR);
    mreq.imr_interface.s_addr = htonl(INADDR_ANY);
    if (setsockopt(sockfd, IPPROTO_IP, IP_ADD_MEMBERSHIP, &mreq, sizeof(mreq)) == -1)
    {
        perror("setsockopt: IP_ADD_MEMBERSHIP");
        exit(EXIT_FAILURE);
    }

    for (int times = 0; times < 5; times++)
    {
        socklen_t addr_len = sizeof(local_addr);
        memset(buff, 0, BUFF_SIZE);

        n = recvfrom(sockfd, buff, BUFF_SIZE, 0, (struct sockaddr*)&local_addr, &addr_len);
        if (n == -1)
        {
            perror("recvfrom");
            exit(EXIT_FAILURE);
        }

        printf("Recv %dst message from server: %s\n", times, buff);

        sleep(MCAST_INTERVAL);
    }

    if (setsockopt(sockfd, IPPROTO_IP, IP_DROP_MEMBERSHIP, &mreq, sizeof(mreq)) == -1)
    {
        perror("setsockopt: IP_DROP_MEMBERSHIP");
        exit(EXIT_FAILURE);
    }

    close(sockfd);

    return 0;
}