package com.asreader.asr033w.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class ASR033WUserConfigs {
    private static String preferenceName = "ASR033W";
    public final String KEY_RFID = "SETTING_KEY_RFID";
    public final String KEY_HID = "SETTING_KEY_HID";
    public final String KEY_IP = "SETTING_KEY_IP";
    private Context _context = null;

    private static ASR033WUserConfigs mUserConfigs;
    public SharedPreferences sharedPreferences;

    public static ASR033WUserConfigs getInstance() {
        if (mUserConfigs == null) {
            mUserConfigs = new ASR033WUserConfigs();
        }
        return mUserConfigs;
    }

    private ASR033WUserConfigs(){}

    public void setContext(Context context) {
        _context = context;
        sharedPreferences = _context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
    }

    public boolean getRFIDStatus(){
        return sharedPreferences.getBoolean(KEY_RFID, false);
    }

    public void setRFIDStatus(boolean value) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_RFID, value);
        editor.apply();
    }

    public boolean getHIDStatus(){
        return sharedPreferences.getBoolean(KEY_HID, false);
    }

    public void setHIDStatus(boolean value) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_HID, value);
        editor.apply();
    }

    public String getIP(){
        return sharedPreferences.getString(KEY_IP, "");
    }

    public void setIP(String value) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(KEY_IP, value);
        editor.apply();
    }
}
