package com.asreader.asr033w.asr033w.util;

public class ASR033WStringConvert {

	private static final String TAG = ASR033WStringConvert.class.getSimpleName();

	public static short getShort(String value, int radix) {
		short res = 0;

		try {
			int temp = Integer.parseInt(value, radix); // 2017.08.28
			res = (short) (temp & 0xFFFF);
		} catch (Exception e) {
			return 0;
		}
		return res;
	}

	public static int getInteger(String value, int radix) {
		int res = 0;

		try {
			long temp = Long.parseLong(value, radix); // 2017.08.28
			res = (int) (temp & 0xFFFFFFFF);
		} catch (Exception e) {
			return 0;
		}
		return res;
	}
	
	public static byte getByte(String value, int radix) {
		byte res = 0;

		try {
			int temp = Integer.parseInt(value, radix); // 2017.08.28
			res = (byte) (temp & 0xFF);
		} catch (Exception e) {
			return 0;
		}
		return res;
	}
}
