package com.asreader.asr033w.asr033w.protocol;

public class ASR033WStruct {
    public static class rcp_033w_packet
    {
        public int header = 0;
        public int payloadLength = 0;
        public String messageType = "";
        public byte[] msg_type = new byte[4];
        public byte[] pl_length = new byte[2];
        public byte[] payload = new byte[1024];
        public void setData(byte[]data)
        {
            header = data[0] & 0xFF;
            System.arraycopy(data, 1, msg_type, 0, 4);
            System.arraycopy(data, 5, pl_length, 0, 2);
            payloadLength =  ((pl_length[0] << 8) & 0xFF00) + (pl_length[1] & 0xFF);
            messageType = String.format("%02X%02X%02X%02X", msg_type[0],msg_type[1],msg_type[2],msg_type[3]);
            System.arraycopy(data, 7, payload, 0, payloadLength);
        }
    }
    public static class rcp_033w_packet_type
    {
        public int code_type = 0;
        public byte[] payload = new byte[1024];
        public void setData(byte[]data)
        {
            code_type = data[0] & 0xFF;
            payload = new byte[data.length -1];
            System.arraycopy(data, 1, payload, 0, data.length -1);
        }
    }
    public static class rcp_033w_packet_length
    {
        public int pl_length = 0;
        public byte[] payload = new byte[1024];
        public void setData(byte[]data)
        {
            pl_length =  ((data[0] << 8) & 0xFF00) + (data[1] & 0xFF);
            System.arraycopy(data, 2, payload, 0, pl_length);
        }
    }
}
