package com.asreader.asr033w.asr033w.network;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class ASR033WNetworkMQTT {
    private MqttClient client;
    private ASR033WNetworkMQTTCallBack asr033WNetworkMQTTCallBack;
    public String rfidTopic = "HEX_OUT";
    public String hidTopic = "HID_OUT";
    private String sendTopic = "HEX_IN";
    public boolean isConnected = false;

    public ASR033WNetworkMQTT() {
    }
    public void setASR033WNetworkMQTTCallBack(ASR033WNetworkMQTTCallBack listener) {
        this.asr033WNetworkMQTTCallBack = listener;
    }

    public void connect(String ip,int port)  {
        new Thread(new Runnable (){
            @Override
            public void run() {
                try {
                    MqttConnectOptions options = new MqttConnectOptions();
                    options.setCleanSession(true);
                    String url = "tcp://"+ ip +":" + port;
                    client = new MqttClient(url, "ASR033WNetworkMQTT", new MemoryPersistence());
                    client.connect(options);
                    client.setCallback(new MqttCallback() {
                        @Override
                        public void connectionLost(Throwable cause) {
                            isConnected = false;
                            if (asr033WNetworkMQTTCallBack != null){
                                asr033WNetworkMQTTCallBack.onMQTTDisconnect();
                            }
                        }

                        @Override
                        public void messageArrived(String topic, MqttMessage message) throws Exception {
                            if (asr033WNetworkMQTTCallBack != null){
                                asr033WNetworkMQTTCallBack.onMQTTReceive(message.getPayload());
                            }
                        }

                        @Override
                        public void deliveryComplete(IMqttDeliveryToken token) {

                        }
                    });
                    isConnected = true;
                    if (asr033WNetworkMQTTCallBack != null){
                        asr033WNetworkMQTTCallBack.onMQTTConnected();
                    }
                } catch ( Exception e){
                    isConnected = false;
                    if (asr033WNetworkMQTTCallBack != null){
                        asr033WNetworkMQTTCallBack.onMQTTDisconnect();
                    }
                }
            }
        }).start();
    }



    public Boolean subscribe(String topic) {
        try {
            client.subscribe(topic);
            return true;
        } catch (Exception e){
            return false;
        }
    }
    public boolean unsubscribe(String topic) {
        try {
            client.unsubscribe(topic);
            return true;
        } catch (Exception e){
            return false;
        }
    }

    public boolean disconnect()  {
        try {
            client.disconnect();
            isConnected = false;
            if (asr033WNetworkMQTTCallBack != null){
                asr033WNetworkMQTTCallBack.onMQTTDisconnect();
            }
            return true;
        } catch (Exception e){
            return false;
        }
    }
    public boolean sendData(final byte[] data)  {
        try {
            client.publish(sendTopic, new MqttMessage(data));
            return true;
        } catch (Exception e){
            return false;
        }
    }
}