package com.asreader.asr033w.asr033w.errormodel;

import androidx.annotation.NonNull;

public enum ASR033WErrorCode {
    ASR033WErrorCodeUnknown {
        @NonNull
        @Override
        public String toString() {
            return "Unknown Error.";
        }
    },
    ASR033WErrorCodeNil_Instance{
        @NonNull
        @Override
        public String toString() {
            return "Error : Instance is nil.";
        }
    },
    ASR033WErrorCodeNil_ArgumentValue{
        @NonNull
        @Override
        public String toString() {
            return"Error : Argument value is nil.";
        }
    },
    ASR033WErrorCodeCommon_TCPNotConnect{
        @NonNull
        @Override
        public String toString() {
            return "Error : TCP is not connect.";
        }
    },
    ASR033WErrorCodeCommon_FHLBTReadTimeInvalidRange{
        @NonNull
        @Override
        public String toString() {
            return "ReadTime value is invalid range. Valid range is 10 to 40000";
        }
    },
    ASR033WErrorCodeCommon_FHLBTIdleTimeInvalidRange{
        @NonNull
        @Override
        public String toString() {
            return "IdleTime value is invalid range. Valid range is 10 to 40000";
        }
    },
    ASR033WErrorCode_SearchDeviceERROR{
        @NonNull
        @Override
        public String toString() {
            return "Search device error.";
        }
    },


}
