package com.asreader.asr033w.asr033w.asr033wenum;

public enum ASR033WSubCommandType {
	Inventory(0x66, "Inventory"),
	ReadMemory(0x72, "Read Memory"),
	WriteMemory(0x77, "Write Memory"),
	LockTag(0x6C, "Lock"),
	PermaLockTag(0x70, "Perma Lock"),
	Kill(0x6B, "Kill"),
	Stop(0x73, "Stop");

	private int code;
	private String mName;
	
	private ASR033WSubCommandType(int subCmd, String name) {
		this.code = subCmd;
		this.mName = name;
	}
	
	public int getCommand() {
		return this.code;
	}

	@Override
	public String toString() {
		return this.mName;
	}
	
	public static ASR033WSubCommandType valueOf(int code) {
		for (ASR033WSubCommandType item : values()) {
			if (item.getCommand() == code) {
				return item;
			}
		}
		return ASR033WSubCommandType.Stop;
	}
}
