package com.asreader.asr033w.asr033w.asr033wenum;

public enum ASR033WResultCode {
    ASR033WResultNoError(0x0000),
    ASR033WResultOtherError(0x0001),
    ASR033WResultUndefined(0x0002),
    ASR033WResultMemoryOverrun(0x0003),
    ASR033WResultMemoryLocked(0x0004),
    ASR033WResultInsufficientPower(0x000B),
    ASR033WResultNotConnected(0xE100),
    ASR033WResultInvalidParameter(0xE200),
    ASR033WResultTimeout(0xEFFF),
    ASR033WResultCommandFormatError(0xF007),
    ASR033WResultOutOfRetries(0xF009),
    ASR033WResultReadAntennaPortParameterError(0xF001),
    ASR033WResultReadReadParameterError(0xF002),
    ASR033WResultReadTidReadingParameterError(0xF003),
    ASR033WResultReadUserDataAreaParameterError(0xF004),
    ASR033WResultReadReservedAreaParameterError(0xF005),
    ASR033WResultReadOtherParameterError(0xF006),
    ASR033WResultWriteAntennaPortParameterError(0xF101),
    ASR033WResultWriteSelectionParameterError(0xF102),
    ASR033WResultWriteWritingParameterError(0xF103),
    ASR033WResultWriteCRCCheckError(0xF104),
    ASR033WResultWriteInsufficientPower(0xF105),
    ASR033WResultWriteMemoryOverrun(0xF106),
    ASR033WResultWriteMemoryLocked(0xF107),
    ASR033WResultWriteIncorrectAccessPassword(0xF108),
    ASR033WResultWriteOtherLabelError(0xF109),
    ASR033WResultWriteLabelLoss(0xF110),
    ASR033WResultWriteSendingInstructionError(0xF111),
    ASR033WResultLockAntennaPortParameterError(0xF201),
    ASR033WResultLockSelectionParameterError(0xF202),
    ASR033WResultLockLockingParameterError(0xF203),
    ASR033WResultLockCRCCheckError(0xF204),
    ASR033WResultLockInsufficientPower(0xF205),
    ASR033WResultLockMemoryOverrun(0xF206),
    ASR033WResultLockMemoryLocked(0xF207),
    ASR033WResultLockIncorrectAccessPassword(0xF208),
    ASR033WResultLockOtherLabelError(0xF209),
    ASR033WResultLockLabelLoss(0xF210),
    ASR033WResultLockSendingInstructionError(0xF211),
    ASR033WResultKillAntennaPortParameterError(0xF301),
    ASR033WResultKillSelectionParameterError(0xF302),
    ASR033WResultKillCRCCheckError(0xF303),
    ASR033WResultKillInsufficientPower(0xF304),
    ASR033WResultKillIncorrectAccessPassword(0xF305),
    ASR033WResultKillOtherLabelError(0xF306),
    ASR033WResultKillLabelLoss(0xF307),
    ASR033WResultKillSendingInstructionError(0xF308);
    private final int code;

    ASR033WResultCode(int code) {
        this.code = code;
    }
    public static ASR033WResultCode getValue(int code){
        Class<?> enumClass = ASR033WResultCode.class;
        ASR033WResultCode[] enumValues = (ASR033WResultCode[]) enumClass.getEnumConstants();
        for (ASR033WResultCode enumValue : enumValues) {
            if (enumValue.code == code) {
               return enumValue;
            }
        }
        return ASR033WResultOtherError;
    }
}
