package com.asreader.asr033w.asr033w.asr033wenum;

public enum ASR033WCommandType {
	None(' ', "None"),
	GetProperty('r', "Get Property"),
	SetProperty('w', "Set Property"),
	Operation('o', "Operation"),
	DefaultParameter('a', "Default Parameter"),
	SaveParemeter('S', "Save Parameter");

	private final char code;
	private final String name;

	private ASR033WCommandType(char code, String name) {
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return this.code;
	}

	public String toString() {
		return this.name;
	}

	public static ASR033WCommandType valueOf(int code) {
		for (ASR033WCommandType item : values()) {
			if (item.getCode() == code)
				return item;
		}
		return ASR033WCommandType.None;
	}
}
