package com.asreader.asr033w.asr033w.asr033wenum;

/**
 * ActionState indicates the current operation status of the device.
 *
 */
public enum ASR033WActionState {
	Stop(0x73, "Stop Operation"),
	Inventory(0x66, "Inventory"),
	ReadMemory(0x72, "Read Memory"),
	WriteMemory(0x77, "Write Memory"),
	Lock(0x6C, "Lock Tag"),
	Unlock(0x6D, "Unlock Tag"),
	PermaLock(0x70, "PermaLock TAg"),
	Kill(0x6B, "Kill Tag"),
	StartDecode(0x64, "Start Decode"),
	WaitForResponse(0xF0, "Wait for response");
	
	private final int code;
	private final String name;

	private ASR033WActionState(int code, String name) {
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return this.code;
	}

	public String toString() {
		return this.name;
	}

	public static ASR033WActionState valueOf(int code) {
		for (ASR033WActionState item : values()) {
			if (item.getCode() == code)
				return item;
		}
		return ASR033WActionState.Stop;
	}
}
