package com.asreader.asr033w.adapter;

import com.asreader.asr033w.R;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class ListAdapter extends BaseAdapter {
    private Context mContext;
    private List<DataModel> dataList = new ArrayList<>();


    public ListAdapter(Context context) {
        mContext = context;
    }

    public void addItem(DataModel item) {
        dataList.add(0, item);
    }

    public void clearItems(){
        dataList.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return dataList.size();
    }

    @Override
    public Object getItem(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        DataModel item = dataList.get(position);
        LayoutInflater inflater = LayoutInflater.from(mContext);
        if (convertView == null) {
            convertView = inflater.inflate(
                    R.layout.activity_list_item, null);
            holder = new ViewHolder();
            holder.tvEPC = convertView
                    .findViewById(R.id.tv_epc);
            holder.tvPC = convertView
                    .findViewById(R.id.tv_pc);
            holder.tvANT = convertView
                    .findViewById(R.id.tv_ant);
            holder.tvPhase = convertView
                    .findViewById(R.id.tv_phase);
            holder.tvChannel = convertView
                    .findViewById(R.id.tv_channel);
            holder.tvRSSI = convertView
                    .findViewById(R.id.tv_rssi);
            holder.tvTid = convertView
                    .findViewById(R.id.tv_tid);
            holder.tvCount = convertView
                    .findViewById(R.id.tv_count);
            convertView.setTag(holder);
        }else {
            holder = (ViewHolder) convertView.getTag();
        }
        if (item.type.equals("HID")) {
            holder.tvANT.setVisibility(View.INVISIBLE);
            holder.tvPhase.setVisibility(View.INVISIBLE);
            holder.tvChannel.setVisibility(View.INVISIBLE);
            holder.tvRSSI.setVisibility(View.INVISIBLE);
            holder.tvCount.setVisibility(View.INVISIBLE);
            holder.tvTid.setVisibility(View.INVISIBLE);
            holder.tvEPC.setText("HID Data:" + item.epc.toUpperCase());
            holder.tvPC.setText("Count:" + item.count);
        } else {
            holder.tvANT.setVisibility(View.VISIBLE);
            holder.tvPhase.setVisibility(View.VISIBLE);
            holder.tvChannel.setVisibility(View.VISIBLE);
            holder.tvRSSI.setVisibility(View.VISIBLE);
            holder.tvTid.setVisibility(View.VISIBLE);
            holder.tvCount.setVisibility(View.VISIBLE);
            holder.tvEPC.setText("EPC:" + item.epc.toUpperCase());
            holder.tvPC.setText("PC:" + item.pc.toUpperCase());
            holder.tvANT.setText("ANT:" + item.ant);
            holder.tvPhase.setText("Phase:" + item.phase);
            holder.tvChannel.setText("Frequency:" + item.channel);
            holder.tvRSSI.setText("RSSI:" + item.rssi);
            holder.tvTid.setText("TID:" + item.tid.toUpperCase());
            holder.tvCount.setText("Count:" + item.count);
        }

        return convertView;
    }

    class ViewHolder {
        TextView tvEPC;
        TextView tvPC;
        TextView tvANT;
        TextView tvPhase;
        TextView tvChannel;
        TextView tvRSSI;
        TextView tvTid;
        TextView tvCount;
    }
}
