package com.asreader.asr033w;

import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.asreader.asr033w.manager.ASR033WManager;
import com.asreader.asr033w.asr033w.ASR033W;
import com.asreader.asr033w.asr033w.ASR033WCallBack;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WNetworkState;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WSubCommandType;

import java.util.HashMap;

public class TestActivity extends AppCompatActivity implements View.OnClickListener {
    private TextView left;
    private TextView title;
    private TextView right;
    private TextView receiveTextView;
    private TextView sendEditView;
    private TextView senTextView;
    private TextView clearTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_test);
        getSupportActionBar().setDisplayHomeAsUpEnabled(false);
        getSupportActionBar().setHomeButtonEnabled(false);
        getSupportActionBar().setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
        getSupportActionBar().setDisplayShowCustomEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        View view = LayoutInflater.from(this).inflate(R.layout.action_bar_layout, null);
        getSupportActionBar().setCustomView(view,
                new ActionBar.LayoutParams(
                        ActionBar.LayoutParams.MATCH_PARENT,
                        ActionBar.LayoutParams.MATCH_PARENT,
                        Gravity.CENTER));
        left = view.findViewById(R.id.left_button);
        left.setOnClickListener(this);
        left.setText("<");
        title = view.findViewById(R.id.title);
        title.setText("Test");
        right = view.findViewById(R.id.right_button);
        right.setText("");
        receiveTextView = findViewById(R.id.tv_receive);
        sendEditView = findViewById(R.id.edit_send);
        senTextView = findViewById(R.id.btn_send);
        senTextView.setOnClickListener(this);
        clearTextView = findViewById(R.id.btn_clear);
        clearTextView.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.btn_send) {
            if (sendEditView.getText().length() == 0) {
                return;
            }
            String dataString = sendEditView.getText().toString();
            dataString = dataString.replace(" ", "");
            ASR033W.sharedInstance().sendData(hexStringToByteArray(dataString));
        } else if (v.getId() == R.id.btn_clear) {
            receiveTextView.setText("");
        } else if (v.getId() == R.id.left_button) {
            finish();
        }
    }

    private byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(hex.charAt(i), 16) << 4)
                    + Character.digit(hex.charAt(i+1), 16));
        }
        return data;
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                // 如果是一位的话，要补0
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    protected void onResume() {
        super.onResume();
        ASR033W.sharedInstance().setCallBack(new ASR033WCallBack() {
            @Override
            public void searchingIP(ASR033W asr033W, HashMap<String, String> dictionary, boolean isFinish) {

            }

            @Override
            public void changeNetworkState(ASR033W asr033W, ASR033WNetworkState state, Error error) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (state == ASR033WNetworkState.ASR033WNetworkStateConnected) {
                            ASR033WManager.getInstance().isConnect = true;
                        } else {
                            ASR033WManager.getInstance().isConnect = false;
                            finish();
                        }
                    }
                });
            }

            @Override
            public void receivedASR033WInventoryPC(String pc, String epc, String tid, int ant, int rssi, double phase, double frequency) {

            }

            @Override
            public void receivedASR033WHIDData(byte[] HIDData) {

            }

            @Override
            public void receivedASR033WData(byte[] data) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        receiveTextView.setText(byteArrayToHexString(data));
                    }
                });
            }

            @Override
            public void receivedASR033WActionChanged(ASR033WSubCommandType action) {

            }

            @Override
            public void receivedASR033WRegionName(String version) {

            }

            @Override
            public void receivedASR033WSerialNumber(String version) {

            }

            @Override
            public void receivedASR033WHardwareVersion(String version) {

            }

            @Override
            public void receivedASR033WRFModuleVersion(String version) {

            }

            @Override
            public void receivedASR033WFirmwareVersion(String version) {

            }

            @Override
            public void receivedASR033WMacAddress(String value) {

            }
        });
    }
}
