package com.asreader.asr033w;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;


import java.util.List;

public class SegmentView extends LinearLayout {

    private int currentPostion;
    private TextView leftTextView;
    private TextView rightTextView;
    private TextView centerTextView;
    private onSegmentViewClickListener segmentListener;

    // This constructor is required when creating the view in code
    public SegmentView(Context context) {
        super(context);
        initView(null);
    }

    // This constructor is required when inflating the view from XML
    public SegmentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(null);
    }

    public void setItems(List<String> items){
        initView(items);
    }
    private void initView(List<String> items) {
        this.removeAllViews();
        if (items != null) {
            for(int i = 0; i < items.size(); i++) {
                TextView itemView = new TextView(getContext());
                itemView.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));

                ColorStateList csl = getResources().getColorStateList(R.color.segment_text_color_selector);
                itemView.setTextColor(csl);

                itemView.setGravity(Gravity.CENTER);

                itemView.setPadding(5, 6, 5, 6);

                itemView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);

                if (i == 0){
                    itemView.setBackgroundResource(R.drawable.segment_left_background);
                    itemView.setSelected(true);
                }else if(i == items.size() -1){
                    itemView.setBackgroundResource(R.drawable.segment_right_background);
                    itemView.setSelected(false);
                }else{
                    itemView.setBackgroundResource(R.drawable.segment_center_background);
                    itemView.setSelected(false);
                }

                itemView.setText(items.get(i));
                this.addView(itemView);
            }
        }

        for (int i = 0; i < this.getChildCount();i++ ){
            int index = i;
            TextView textView = (TextView) this.getChildAt(i);
            textView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (textView.isSelected()) {
                        return;
                    }
                    currentPostion = index;
                    unSelectAllItems();
                    textView.setSelected(true);

                    if (segmentListener != null) {
                        segmentListener.onSegmentViewClick(textView, index);
                    }
                }
            });
        }
        this.invalidate();
    }

    private void unSelectAllItems(){
        for (int i = 0; i < this.getChildCount();i++){
            TextView textView = (TextView) this.getChildAt(i);
            textView.setSelected(false);
        }
    }
    /**
     * Manually set the selected state
     *
     * @param index
     */
    public void setSelectIndex(int index) {
        currentPostion = index;
        for (int i = 0; i < this.getChildCount();i++){
            TextView textView = (TextView) this.getChildAt(i);
            textView.setSelected(false);
        }
        TextView textView = (TextView) this.getChildAt(index);
        textView.setSelected(true);
    }

    /**
     * Set the text displayed by the control
     *
     * @param text
     * @param position
     */
    public void setSegmentText(CharSequence text, int position) {
        TextView textView = (TextView) this.getChildAt(position);
        textView.setText(text);
    }

    public int getSelectIndex(){
        return currentPostion;
    }

    // Define an interface to receive click events
    public interface onSegmentViewClickListener {
        public void onSegmentViewClick(View view, int postion);
    }

    public void setOnSegmentViewClickListener(onSegmentViewClickListener segmentListener) {
        this.segmentListener = segmentListener;
    }

}
