package com.asreader.asr033w;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;

public class SearchBuilder {
    CustomAlertDialog dialog = null;
    View contentView = null;
    View layout = null;
    TextView textView = null;
    EditText inputText = null;
    TextView cancelTextView = null;
    TextView okTextView = null;


    public SearchBuilder(Context context){
        dialog = new CustomAlertDialog(context,R.style.CustomDialog);
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        layout = inflater.inflate(R.layout.dialog_search, null);
        dialog.addContentView(layout, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        textView = layout.findViewById(R.id.title_text_view);
        textView.setText("Please wait...");
        inputText = layout.findViewById(R.id.detail_message_text_view);
        cancelTextView = layout.findViewById(R.id.cancel_button);
        okTextView = layout.findViewById(R.id.ok_button);
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }
    public String getInputValue() {
        return inputText.getText().toString();
    }
    public SearchBuilder setInputValue(String inputValue) {
        inputText.setText(inputValue);
        return this;
    }
    public SearchBuilder setHidden(boolean isHidden) {
        if (isHidden){
            inputText.setVisibility(View.GONE);
        } else {
            inputText.setVisibility(View.VISIBLE);
        }
        return this;
    }
    public SearchBuilder setCancelHidden(boolean isHidden) {
        if (isHidden){
            cancelTextView.setVisibility(View.GONE);
        } else {
            cancelTextView.setVisibility(View.VISIBLE);
        }
        return this;
    }
    public SearchBuilder setOnClickListener(View.OnClickListener listener){
        okTextView.setOnClickListener(listener);
        return this;
    }
    public SearchBuilder setCancelOnClickListener(View.OnClickListener listener){
        cancelTextView.setOnClickListener(listener);
        return this;
    }
    public CustomAlertDialog setTitle(String title){
        textView.setText(title);
        setContentView(layout);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }
}
