package com.asreader.asr033w;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;

public class ProgressHUDBuilder {
    CustomAlertDialog dialog = null;
    View contentView = null;
    View layout = null;
    ProgressBar progressBar = null;
    TextView textView = null;


    public ProgressHUDBuilder(Context context){
        dialog = new CustomAlertDialog(context,R.style.CustomDialog);
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        layout = inflater.inflate(R.layout.progress_hud, null);
        dialog.addContentView(layout, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        progressBar = layout.findViewById(R.id.progressBar);
        textView = layout.findViewById(R.id.textView);
        textView.setText("Please wait...");
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }

    public CustomAlertDialog setTitle(String title){
        textView.setText(title);
        setContentView(layout);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }
}
