package com.asreader.asr033w;

import android.content.Intent;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.asreader.asr033w.manager.ASR033WManager;
import com.asreader.asr033w.asr033w.ASR033W;
import com.asreader.asr033w.asr033w.ASR033WCallBack;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WResultCode;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WNetworkState;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WSubCommandType;

import java.util.HashMap;
import java.util.Map;

public class MoreActivity extends AppCompatActivity implements View.OnClickListener {
    private TextView left;
    private TextView title;
    private TextView right;
    private TextView informationTextView;
    private TextView testTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_more);
        getSupportActionBar().setDisplayHomeAsUpEnabled(false);
        getSupportActionBar().setHomeButtonEnabled(false);
        getSupportActionBar().setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
        getSupportActionBar().setDisplayShowCustomEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        View view = LayoutInflater.from(this).inflate(R.layout.action_bar_layout, null);
        getSupportActionBar().setCustomView(view,
                new ActionBar.LayoutParams(
                        ActionBar.LayoutParams.MATCH_PARENT,
                        ActionBar.LayoutParams.MATCH_PARENT,
                        Gravity.CENTER));
        left = view.findViewById(R.id.left_button);
        left.setOnClickListener(this);
        left.setText("<");
        title = view.findViewById(R.id.title);
        title.setText("More");
        right = view.findViewById(R.id.right_button);
        right.setText("");

        informationTextView = findViewById(R.id.tv_information);
        informationTextView.setOnClickListener(this);
        testTextView = findViewById(R.id.tv_test);
        testTextView.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.tv_information) {
            Intent intent = new Intent(MoreActivity.this, InformationActivity.class);
            startActivity(intent);
        } else if (v.getId() == R.id.tv_test) {
            Intent intent = new Intent(MoreActivity.this, TestActivity.class);
            startActivity(intent);
        } else if (v.getId() == R.id.left_button) {
            finish();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        ASR033W.sharedInstance().setCallBack(new ASR033WCallBack() {
            @Override
            public void searchingIP(ASR033W asr033W, HashMap<String, String> dictionary, boolean isFinish) {

            }

            @Override
            public void changeNetworkState(ASR033W asr033W, ASR033WNetworkState state, Error error) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (state == ASR033WNetworkState.ASR033WNetworkStateConnected) {
                            ASR033WManager.getInstance().isConnect = true;
                        } else {
                            ASR033WManager.getInstance().isConnect = false;
                            finish();
                        }
                    }
                });
            }

            @Override
            public void receivedASR033WInventoryPC(String pc, String epc, String tid, int ant, int rssi, double phase, double frequency) {

            }

            @Override
            public void receivedASR033WHIDData(byte[] HIDData) {

            }

            @Override
            public void receivedASR033WData(byte[] data) {

            }

            @Override
            public void receivedASR033WActionChanged(ASR033WSubCommandType action) {

            }

            @Override
            public void receivedASR033WRegionName(String version) {

            }

            @Override
            public void receivedASR033WSerialNumber(String version) {

            }

            @Override
            public void receivedASR033WHardwareVersion(String version) {

            }

            @Override
            public void receivedASR033WRFModuleVersion(String version) {

            }

            @Override
            public void receivedASR033WFirmwareVersion(String version) {

            }

            @Override
            public void receivedASR033WMacAddress(String value) {

            }
        });
    }
}
