package com.asreader.asr033w;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;

public class ListSelectBuilder {
    CustomAlertDialog dialog = null;
    View contentView = null;
    View layout = null;
    TextView textView = null;
    EditText inputText = null;
    TextView okTextView = null;
    ArrayAdapter<String> adapter;
    ListView listView;
    public ListSelectBuilder(Context context){
        dialog = new CustomAlertDialog(context,R.style.CustomDialog);
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        layout = inflater.inflate(R.layout.dialog_data_select, null);
        dialog.addContentView(layout, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT));
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        textView = layout.findViewById(R.id.title_text_view);
        listView = layout.findViewById(R.id.listview);
        okTextView = layout.findViewById(R.id.cancel_button);
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }
    public ListSelectBuilder setArray(String[] items, AdapterView.OnItemClickListener listener){
        adapter = new ArrayAdapter(dialog.getContext(), R.layout.simple_list_item_1, items);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(listener);
        return this;
    }
    public ListSelectBuilder setOnClickListener(View.OnClickListener listener){
        okTextView.setOnClickListener(listener);
        return this;
    }
    public CustomAlertDialog setTitle(String title){
        textView.setText(title);
        setContentView(layout);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }
}
