package com.asreader.asr033w;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.asreader.asr033w.manager.ASR033WManager;
import com.asreader.asr033w.asr033w.ASR033W;
import com.asreader.asr033w.asr033w.ASR033WCallBack;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WResultCode;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WNetworkState;
import com.asreader.asr033w.asr033w.asr033wenum.ASR033WSubCommandType;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class InformationActivity extends AppCompatActivity implements View.OnClickListener {
    private TextView left;
    private TextView title;
    private TextView right;
    private TextView appTextView;
    private TextView regionTextView;
    private TextView serialTextView;
    private TextView hardwareTextView;
    private TextView rfTextView;
    private TextView firmwareTextView;
    private TextView macAddressTextView;
    private Timer sendDataTimer;
    private CustomAlertDialog dialog = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_information);
        getSupportActionBar().setDisplayHomeAsUpEnabled(false);
        getSupportActionBar().setHomeButtonEnabled(false);
        getSupportActionBar().setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
        getSupportActionBar().setDisplayShowCustomEnabled(true);
        getSupportActionBar().setDisplayShowHomeEnabled(true);
        View view = LayoutInflater.from(this).inflate(R.layout.action_bar_layout, null);
        getSupportActionBar().setCustomView(view,
                new ActionBar.LayoutParams(
                        ActionBar.LayoutParams.MATCH_PARENT,
                        ActionBar.LayoutParams.MATCH_PARENT,
                        Gravity.CENTER));
        left = view.findViewById(R.id.left_button);
        left.setOnClickListener((View.OnClickListener) this);
        left.setText("<");
        title = view.findViewById(R.id.title);
        title.setText("Information");
        right = view.findViewById(R.id.right_button);
        right.setText("");

        appTextView = findViewById(R.id.app);
        regionTextView = findViewById(R.id.region);
        serialTextView = findViewById(R.id.serial);
        hardwareTextView = findViewById(R.id.hardware);
        rfTextView = findViewById(R.id.rf);
        firmwareTextView = findViewById(R.id.firmware);
        macAddressTextView = findViewById(R.id.macaddress);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.left_button) {
            finish();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        ASR033W.sharedInstance().setCallBack(new ASR033WCallBack() {
            @Override
            public void searchingIP(ASR033W asr033W, HashMap<String, String> dictionary, boolean isFinish) {

            }

            @Override
            public void changeNetworkState(ASR033W asr033W, ASR033WNetworkState state, Error error) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (state == ASR033WNetworkState.ASR033WNetworkStateConnected) {
                            ASR033WManager.getInstance().isConnect = true;
                        } else {
                            ASR033WManager.getInstance().isConnect = false;
                            finish();
                        }
                    }
                });
            }

            @Override
            public void receivedASR033WInventoryPC(String pc, String epc, String tid, int ant, int rssi, double phase, double frequency) {

            }

            @Override
            public void receivedASR033WHIDData(byte[] HIDData) {

            }

            @Override
            public void receivedASR033WData(byte[] data) {

            }

            @Override
            public void receivedASR033WActionChanged(ASR033WSubCommandType action) {

            }

            @Override
            public void receivedASR033WRegionName(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        regionTextView.setText(value);
                        ASR033W.sharedInstance().serialNumber();
                    }
                });
            }

            @Override
            public void receivedASR033WSerialNumber(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        serialTextView.setText(value);
                        ASR033W.sharedInstance().hardwareVersion();
                    }
                });
            }

            @Override
            public void receivedASR033WHardwareVersion(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hardwareTextView.setText(value);
                        ASR033W.sharedInstance().rFModuleVersion();
                    }
                });
            }

            @Override
            public void receivedASR033WRFModuleVersion(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        rfTextView.setText(value);
                        ASR033W.sharedInstance().firmwareVersion();
                    }
                });
            }

            @Override
            public void receivedASR033WFirmwareVersion(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        firmwareTextView.setText(value);
                        ASR033W.sharedInstance().macAddress();
                    }
                });
            }
            @Override
            public void receivedASR033WMacAddress(String value) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        macAddressTextView.setText(value);
                        if(sendDataTimer != null) {
                            sendDataTimer.cancel();
                            sendDataTimer = null;
                        }
                        dialog.dismiss();
                    }
                });
            }
        });
        dialog = new ProgressHUDBuilder(InformationActivity.this).setTitle("Information ...");
        dialog.show();
        startTimer();
        try {
            PackageManager packageManager = getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(getPackageName(), 0);
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            appTextView.setText("Version:" + versionName + " " + "Build:" + versionCode);
        } catch (PackageManager.NameNotFoundException e) {
        }
        ASR033W.sharedInstance().regionName();
    }
    private void startTimer() {
        if(sendDataTimer != null) {
            sendDataTimer.cancel();
            sendDataTimer = null;
        }
        sendDataTimer = new Timer();
        sendDataTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                dialog.dismiss();
            }
        }, 5000);
    }
}
