/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.util;

import java.util.Locale;

public class ASR033WBitConvert {
    private static final String TAG = ASR033WBitConvert.class.getSimpleName();

    public static String getHexString(byte[] data, int offset, int length) {
        StringBuilder builder = new StringBuilder();
        int len = data[offset] & 0x7F;
        if (len > length + 1) {
            len = length - 1;
        }
        for (int i = 0; i < len; ++i) {
            builder.append(String.format(Locale.US, "%02X", data[offset + i + 1]));
        }
        return builder.toString();
    }

    public static byte[] getHexBytes(String data) {
        byte[] result = null;
        if (data == null) {
            return null;
        }
        int length = data.length() / 2;
        result = new byte[length + 1];
        result[0] = (byte)((0x80 | length) & 0xFF);
        for (int i = 0; i < length; ++i) {
            result[i + 1] = (byte)Integer.parseInt(data.substring(2 * i, 2 * i + 2), 16);
        }
        return result;
    }

    public static String getString(byte[] data) throws Exception {
        String value = null;
        value = new String(data, "ASCII");
        return value;
    }

    public static String getString(byte[] data, int offset, int length) throws Exception {
        String value = null;
        value = new String(data, offset, length, "ASCII");
        return value;
    }

    public static int getInteger(byte[] data) throws Exception {
        int value = 0;
        String str = null;
        str = ASR033WBitConvert.getString(data);
        value = Integer.parseInt(str);
        return value;
    }

    public static int getInteger(byte[] data, int offset, int length) throws Exception {
        int value = 0;
        String str = null;
        str = ASR033WBitConvert.getString(data, offset, length);
        value = Integer.parseInt(str);
        return value;
    }

    public static int getInteger(byte[] data, int radix) throws Exception {
        int value = 0;
        String str = null;
        str = ASR033WBitConvert.getString(data);
        value = Integer.parseInt(str, radix);
        return value;
    }

    public static int getInteger(byte[] data, int offset, int length, int radix) throws Exception {
        int value = 0;
        String str = null;
        str = ASR033WBitConvert.getString(data, offset, length);
        value = Integer.parseInt(str, radix);
        return value;
    }

    public static long getLong(byte[] data) throws Exception {
        long value = 0L;
        String str = null;
        str = ASR033WBitConvert.getString(data);
        value = Long.parseLong(str);
        return value;
    }

    public static long getLong(byte[] data, int radix) throws Exception {
        long value = 0L;
        String str = null;
        str = ASR033WBitConvert.getString(data);
        value = Long.parseLong(str, radix);
        return value;
    }

    public static boolean getBoolean(byte[] data) throws Exception {
        return ASR033WBitConvert.getInteger(data) > 0;
    }

    public static byte[] getBytes(String value) throws Exception {
        return value.getBytes("ASCII");
    }

    public static byte[] getBytes(int value) throws Exception {
        return ASR033WBitConvert.getBytes(String.format(Locale.US, "%d", value));
    }

    public static byte[] getBytes(boolean enabled) throws Exception {
        return ASR033WBitConvert.getBytes(enabled ? "1" : "0");
    }

    public static byte[] getAddDataLength(byte[] data) throws Exception {
        byte[] newData = null;
        newData = new byte[data.length + 1];
        newData[0] = (byte)(data.length & 0xFF);
        System.arraycopy(data, 0, newData, 1, data.length);
        return newData;
    }
}

