/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.protocol;

import android.util.Log;
import com.asreader.asr033w.sdk.ASR033WCallBack;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WConnectMethod;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WResultCode;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WSubCommandType;
import com.asreader.asr033w.sdk.info.ASR033WReaderInfo;
import com.asreader.asr033w.sdk.network.ASR033WNetworkMQTT;
import com.asreader.asr033w.sdk.network.ASR033WNetworkTCP;
import com.asreader.asr033w.sdk.protocol.ASR033WDefine;
import com.asreader.asr033w.sdk.protocol.ASR033WStruct;
import com.asreader.asr033w.sdk.protocol.UnsignedShort;
import com.asreader.asr033w.sdk.util.ASR033WBitConvert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class ASR033WProtocol {
    private ASR033WNetworkTCP _currentTCP;
    private ASR033WNetworkMQTT _currentMQTT;
    private ASR033WReaderInfo asr033WReaderInfo;
    private ASR033WCallBack callBack;
    private ASR033WConnectMethod currentConnectMethod = ASR033WConnectMethod.ASR033WConnectMethod_TCP;
    private static final byte PACKET_PREFIX = 126;
    private static final byte[] PACKET_SUFFIX = new byte[]{13, 10};
    private static final byte PACKET_ENED = 13;
    private static final byte PACKET_ENEA = 10;
    private static final byte CMD_SET_PARAMETER = 119;
    private static final byte CMD_SET_RESULT = 87;
    private static final byte CMD_GET_PARAMETER = 114;
    private static final byte CMD_PARAMETER_VALUE = 82;
    private static final byte CMD_COMMAND = 97;
    private static final byte CMD_COMMAND_ACK = 65;
    private static final byte CMD_EVENT = 101;
    private static final byte CMD_DEBUG = 100;
    private static final byte CMD_HID = -86;
    public static final byte PARAM_HARDWARE_VERSION = 72;
    public static final byte PARAM_FIRMWARE_VERSION = 118;
    public static final byte PARAM_MAC_ADDRESS = 77;
    public static final byte PARAM_REGION = 103;
    public static final byte PARAM_SERIAL_NUMBER = 83;
    public static final byte PARAM_UHF_VERSION = 107;
    public static final byte SUBCMD_INVENTORY = 102;
    public static final byte SUBCMD_STOP_OPERATION = 115;
    private static final int POS_CMD = 1;
    private static final int POS_SUB_CMD = 2;
    private static final int POS_DATA = 3;
    private static final int POS_RESULT_DATA = 10;
    private static final int DEFAULT_TIMEOUT = 3500;
    private static final byte EVENT_TAG_VALUE = 84;
    private static final byte EVENT_HTTAG_VALUE = 72;
    private static final byte[] STATUS_SUCCESS = new byte[]{48, 48, 48, 48};
    private int _bufHead = 0;
    private int tagLen = 0;
    private byte[] _buf = new byte[2048];

    public ASR033WProtocol(ASR033WNetworkTCP asr033WNetworkTCP, ASR033WNetworkMQTT asr033WNetworkMQTT) {
        this._currentTCP = asr033WNetworkTCP;
        this._currentMQTT = asr033WNetworkMQTT;
        this.asr033WReaderInfo = ASR033WReaderInfo.getInstance();
    }

    public void setCallBack(ASR033WCallBack callBack) {
        this.callBack = callBack;
    }

    public void receiveData(byte[] receiveData) {
        Log.d((String)"ASR033WProtocol", (String)("receiveData : " + this.byteArrayToHexString(receiveData)));
        if (receiveData.length > 0 && this.callBack != null) {
            this.callBack.receivedASR033WData(receiveData);
            this.analysis(receiveData);
        }
    }

    private void analysis(byte[] receiveData) {
        try {
            for (byte this._buf[this._bufHead] : receiveData) {
                ++this._bufHead;
                if (this._bufHead < 7) continue;
                this.tagLen = (this._buf[1] & 0xFF) == 101 && (this._buf[2] & 0xFF) == 84 ? this._buf[3] & 0xFF & 0xFF : ((this._buf[1] & 0xFF) == 65 && (this._buf[2] & 0xFF) == 114 ? this._buf[3] & 0xFF & 0xFF : ((this._buf[1] & 0xFF) == -86 ? ((this._buf[2] & 0xFF) << 8) + (this._buf[3] & 0xFF) : 0));
                if (this._bufHead < this.tagLen || (this._buf[this._bufHead - 2] & 0xFF) != 13 || (this._buf[this._bufHead - 1] & 0xFF) != 10) continue;
                byte[] bytes = new byte[this._bufHead];
                System.arraycopy(this._buf, 0, bytes, 0, this._bufHead);
                this._bufHead = 0;
                this._buf = new byte[2048];
                this.decodePacket(bytes);
            }
        }
        catch (Exception e) {
            Log.d((String)"ASR033WProtocol", (String)("e\uff1a" + e.getMessage()));
        }
    }

    private void decodePacket(byte[] packet) {
        block65: {
            try {
                int length = packet.length;
                byte header = packet[0];
                byte endD = packet[length - 2];
                byte endA = packet[length - 1];
                if (header != 126 || endD != 13 || endA != 10) break block65;
                byte packetEvent = packet[1];
                byte packetType = packet[2];
                if (packetEvent == 82) {
                    byte[] newPacket = new byte[length - 3];
                    System.arraycopy(packet, 1, newPacket, 0, length - 3);
                    if (packetType == 77) {
                        byte[] statusByte = this.getPacketStatus(newPacket);
                        if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                            byte[] valueByte = this.getPacketValue(newPacket);
                            try {
                                String value = ASR033WBitConvert.getString(valueByte);
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WMacAddress(value);
                                }
                                break block65;
                            }
                            catch (Exception e) {
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WMacAddress("");
                                }
                                break block65;
                            }
                        }
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WMacAddress("");
                        }
                        break block65;
                    }
                    if (packetType == 72) {
                        byte[] statusByte = this.getPacketStatus(newPacket);
                        if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                            byte[] valueByte = this.getPacketValue(newPacket);
                            try {
                                String version = ASR033WBitConvert.getString(valueByte);
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WHardwareVersion(version);
                                }
                                break block65;
                            }
                            catch (Exception e) {
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WHardwareVersion("");
                                }
                                break block65;
                            }
                        }
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WHardwareVersion("");
                        }
                        break block65;
                    }
                    if (packetType == 118) {
                        byte[] statusByte = this.getPacketStatus(newPacket);
                        if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                            byte[] valueByte = this.getPacketValue(newPacket);
                            try {
                                String version = ASR033WBitConvert.getString(valueByte);
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WFirmwareVersion(version);
                                }
                                break block65;
                            }
                            catch (Exception e) {
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WFirmwareVersion("");
                                }
                                break block65;
                            }
                        }
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WFirmwareVersion("");
                        }
                        break block65;
                    }
                    if (packetType == 103) {
                        byte[] statusByte = this.getPacketStatus(newPacket);
                        if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                            byte[] valueByte = this.getPacketValue(newPacket);
                            try {
                                String value = ASR033WBitConvert.getString(valueByte);
                                HashMap<String, String> dictionary = new HashMap<String, String>();
                                dictionary.put("0", "GB");
                                dictionary.put("1", "GB1");
                                dictionary.put("2", "GB2");
                                dictionary.put("3", "FCC");
                                dictionary.put("4", "Europe");
                                dictionary.put("5", "Japan250mW");
                                dictionary.put("9", "TEST");
                                dictionary.put("10", "Japan");
                                Set keys = dictionary.keySet();
                                for (String key : keys) {
                                    if (!key.equals(value)) continue;
                                    value = (String)dictionary.get(key);
                                }
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WRegionName(value);
                                }
                                break block65;
                            }
                            catch (Exception e) {
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WRegionName("");
                                }
                                break block65;
                            }
                        }
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WRegionName("");
                        }
                        break block65;
                    }
                    if (packetType == 83) {
                        byte[] statusByte = this.getPacketStatus(newPacket);
                        if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                            byte[] valueByte = this.getPacketValue(newPacket);
                            try {
                                String version = ASR033WBitConvert.getString(valueByte);
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WSerialNumber(version);
                                }
                                break block65;
                            }
                            catch (Exception e) {
                                if (this.callBack != null) {
                                    this.callBack.receivedASR033WSerialNumber("");
                                }
                                break block65;
                            }
                        }
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WSerialNumber("");
                        }
                        break block65;
                    }
                    if (packetType != 107) break block65;
                    byte[] statusByte = this.getPacketStatus(newPacket);
                    if (Arrays.equals(statusByte, STATUS_SUCCESS)) {
                        byte[] valueByte = this.getPacketValue(newPacket);
                        try {
                            String version = ASR033WBitConvert.getString(valueByte);
                            if (this.callBack != null) {
                                this.callBack.receivedASR033WRFModuleVersion(version);
                            }
                            break block65;
                        }
                        catch (Exception e) {
                            if (this.callBack != null) {
                                this.callBack.receivedASR033WRFModuleVersion("");
                            }
                            break block65;
                        }
                    }
                    if (this.callBack != null) {
                        this.callBack.receivedASR033WRFModuleVersion("");
                    }
                    break block65;
                }
                if (packetEvent == -86) {
                    if (packet.length > 4) {
                        int hidLen = ((packet[2] & 0xFF) << 8) + (packet[3] & 0xFF);
                        byte[] hidPacket = new byte[hidLen];
                        System.arraycopy(packet, 4, hidPacket, 0, hidLen);
                        if (this.callBack != null) {
                            this.callBack.receivedASR033WHIDData(hidPacket);
                        }
                    }
                    break block65;
                }
                if (packetEvent == 101) {
                    if (packetType != 84) break block65;
                    String pc = "";
                    String epc = "";
                    String tid = "";
                    int antenna = 0;
                    int rssi = 0;
                    double phase = 0.0;
                    double frequency = 0.0;
                    int index = 3;
                    int len = packet[index] & 0xFF;
                    int antByte = packet[++index] & 0xFF;
                    ++index;
                    switch (antByte) {
                        case 1: {
                            antenna = 1;
                            break;
                        }
                        case 2: {
                            antenna = 2;
                            break;
                        }
                        case 4: {
                            antenna = 3;
                            break;
                        }
                        case 8: {
                            antenna = 4;
                            break;
                        }
                        case 16: {
                            antenna = 5;
                            break;
                        }
                        case 32: {
                            antenna = 6;
                            break;
                        }
                        case 64: {
                            antenna = 7;
                            break;
                        }
                        case 128: {
                            antenna = 8;
                            break;
                        }
                    }
                    int epcLength = (packet[index] & 0xF8) >> 3;
                    byte[] pcByte = new byte[]{(byte)(packet[index] & 0xFF), (byte)(packet[index + 1] & 0xFF)};
                    pc = this.byteArrayToHexString(pcByte);
                    byte[] epcByte = new byte[epcLength * 2];
                    System.arraycopy(packet, index += 2, epcByte, 0, epcLength * 2);
                    epc = this.byteArrayToHexString(epcByte);
                    byte[] rssiByte = new byte[]{(byte)(packet[index += epcLength * 2] & 0xFF), (byte)(packet[index + 1] & 0xFF), (byte)(packet[index + 2] & 0xFF)};
                    index += 3;
                    try {
                        rssi = Integer.parseInt(ASR033WBitConvert.getString(rssiByte));
                    }
                    catch (Exception e) {
                        rssi = 0;
                    }
                    phase = (double)(packet[index] & 0xFF) / 128.0 * 360.0;
                    double frequencyInt = ((packet[++index] & 0xFF) << 24) + ((packet[index + 1] & 0xFF) << 16) + ((packet[index + 2] & 0xFF) << 8) + (packet[index + 3] & 0xFF);
                    frequency = frequencyInt / 1000.0;
                    if (len > (index += 4) + 2) {
                        int tidLength = (packet[index] & 0xFF00) + packet[index + 1] & 0xFF;
                        byte[] tidPacket = new byte[tidLength];
                        System.arraycopy(packet, index += 2, tidPacket, 0, tidLength);
                        tid = this.byteArrayToHexString(tidPacket);
                    }
                    if (this.callBack != null) {
                        this.callBack.receivedASR033WInventoryPC(pc, epc, tid, antenna, rssi, phase, frequency);
                    }
                    break block65;
                }
                if (packetEvent == 65) {
                    ASR033WSubCommandType commandType = ASR033WSubCommandType.valueOf(packetType);
                    if (this.callBack != null) {
                        this.callBack.receivedASR033WActionChanged(commandType);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private byte[] getPacketStatus(byte[] newPacket) {
        byte[] statusPacket = new byte[4];
        System.arraycopy(newPacket, 2, statusPacket, 0, 4);
        String statusString = this.byteArrayToHexString(statusPacket);
        Log.i((String)"QQQ", (String)("statusString   " + statusString));
        return statusPacket;
    }

    private byte[] getPacketValue(byte[] newPacket) {
        byte[] valuePacket = new byte[newPacket.length - 6];
        System.arraycopy(newPacket, 6, valuePacket, 0, newPacket.length - 6);
        String valueString = this.byteArrayToHexString(valuePacket);
        Log.i((String)"QQQ", (String)("valueString   " + valueString));
        return valuePacket;
    }

    public ASR033WResultCode getRegionName() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 103;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode getSerialNumber() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 83;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode getHardwareVersion() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 72;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode getRFModuleVersion() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 107;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode getFirmwareVersion() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 118;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode startInventoryAntenna1(byte[] data) {
        int dataLen = data.length;
        byte[] buf = new byte[5 + dataLen];
        buf[0] = 126;
        buf[1] = 97;
        buf[2] = 102;
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, buf, 3, data.length);
        }
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3 + dataLen, PACKET_SUFFIX.length);
        ASR033WResultCode resultCode = this.sendData(buf);
        return resultCode;
    }

    public ASR033WResultCode stopInventory() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 97;
        buf[2] = 115;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        ASR033WResultCode resultCode = this.sendData(buf);
        return resultCode;
    }

    public ASR033WResultCode getMacAddress() {
        byte[] buf = new byte[5];
        buf[0] = 126;
        buf[1] = 114;
        buf[2] = 77;
        System.arraycopy(PACKET_SUFFIX, 0, buf, 3, PACKET_SUFFIX.length);
        return this.sendData(buf);
    }

    public ASR033WResultCode sendData(byte[] sendData) {
        Log.d((String)"ASR033WProtocol", (String)("sendData : " + this.byteArrayToHexString(sendData)));
        if (this.currentConnectMethod == ASR033WConnectMethod.ASR033WConnectMethod_TCP) {
            if (this._currentTCP.isConnected) {
                this._currentTCP.sendData(sendData);
                return ASR033WResultCode.ASR033WResultNoError;
            }
            return ASR033WResultCode.ASR033WResultNotConnected;
        }
        if (this._currentMQTT.isConnected) {
            this._currentMQTT.sendData(sendData);
            return ASR033WResultCode.ASR033WResultNoError;
        }
        return ASR033WResultCode.ASR033WResultNotConnected;
    }

    public void setASR033WConnectMethod(ASR033WConnectMethod connectMethod) {
        this.currentConnectMethod = connectMethod;
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public UnsignedShort getCRC16WithPacketLength(byte[] picket, UnsignedShort picketLength) {
        int wCRC = 0;
        for (int index = 1; index <= picketLength.getValue(); ++index) {
            char chChar = (char)picket[index];
            wCRC = (short)(wCRC ^ new UnsignedShort(chChar).getValue() << 8);
            for (int i = 0; i < 8; i = (int)((char)(i + 1))) {
                wCRC = (wCRC & 0x8000) == 32768 ? (int)((short)(wCRC << 1 ^ 0x1021)) : (int)((short)(wCRC << 1));
            }
        }
        return new UnsignedShort(wCRC);
    }

    public HashMap<String, byte[]> interceptData(byte[] data, int type, int length) {
        HashMap<String, byte[]> dictionary = new HashMap<String, byte[]>();
        try {
            if (type == 0) {
                ASR033WStruct.rcp_033w_packet_length rcpIntercept = new ASR033WStruct.rcp_033w_packet_length();
                rcpIntercept.setData(data);
                int intercept_len = rcpIntercept.pl_length;
                byte[] payload = new byte[intercept_len];
                System.arraycopy(rcpIntercept.payload, 0, payload, 0, intercept_len);
                byte[] interceptData = payload;
                byte[] mutableData = new byte[data.length - intercept_len - 2];
                System.arraycopy(data, intercept_len + 2, mutableData, 0, data.length - intercept_len - 2);
                dictionary.put(ASR033WDefine.ASR033W_PACKET_INTERCEPT_DATA, interceptData);
                dictionary.put(ASR033WDefine.ASR033W_PACKET_REMAIN_DATA, mutableData);
            } else {
                byte[] interceptData = new byte[length];
                System.arraycopy(data, 0, interceptData, 0, length);
                byte[] mutableData = new byte[data.length - length];
                System.arraycopy(data, length, mutableData, 0, data.length - length);
                dictionary.put(ASR033WDefine.ASR033W_PACKET_INTERCEPT_DATA, interceptData);
                dictionary.put(ASR033WDefine.ASR033W_PACKET_REMAIN_DATA, mutableData);
            }
        }
        catch (Exception e) {
            dictionary = new HashMap();
            Log.d((String)"ASR033WProtocol", (String)("Exception dictionary :" + e.toString()));
        }
        Log.d((String)"ASR033WProtocol", (String)("dictionary :" + dictionary));
        return dictionary;
    }

    public byte[] SubData(byte[] original, int length) {
        byte[] det = new byte[original.length - length];
        System.arraycopy(original, length, det, 0, original.length - length);
        return det;
    }

    public byte[] SubData(byte[] original, int offset, int length) {
        byte[] det = new byte[length];
        System.arraycopy(original, offset, det, 0, length);
        return det;
    }

    public String calculationIPData(byte[] data) {
        try {
            int a = data[0] & 0xFF;
            int b = data[1] & 0xFF;
            int c = data[2] & 0xFF;
            int d = data[3] & 0xFF;
            String string = String.format("%d.%d.%d.%d", a, b, c, d);
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            value |= (bytes[i] & 0xFF) << 8 * i;
        }
        return value;
    }
}

