/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk;

import android.util.Log;
import com.asreader.asr033w.sdk.ASR033WCallBack;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WConnectMethod;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WNetworkState;
import com.asreader.asr033w.sdk.asr033wenum.ASR033WResultCode;
import com.asreader.asr033w.sdk.errormodel.ASR033WErrorModel;
import com.asreader.asr033w.sdk.info.ASR033WReaderInfo;
import com.asreader.asr033w.sdk.network.ASR033WNetworkMQTT;
import com.asreader.asr033w.sdk.network.ASR033WNetworkMQTTCallBack;
import com.asreader.asr033w.sdk.network.ASR033WNetworkTCP;
import com.asreader.asr033w.sdk.network.ASR033WNetworkTCPCallBack;
import com.asreader.asr033w.sdk.network.ASR033WNetworkUDP;
import com.asreader.asr033w.sdk.network.ASR033WNetworkUDPCallBack;
import com.asreader.asr033w.sdk.protocol.ASR033WProtocol;
import java.util.HashMap;

public class ASR033W {
    private static ASR033W instance = null;
    private ASR033WNetworkUDP asr033wNetworkUDP = null;
    private ASR033WReaderInfo asr033wReaderInfo = null;
    private ASR033WProtocol asr033wProtocol = null;
    private ASR033WNetworkTCP asr033wNetworkTCP = null;
    private ASR033WNetworkMQTT asr033WNetworkMQTT = null;
    private ASR033WCallBack callBack = null;
    private boolean isConnect = false;
    private ASR033WConnectMethod currentConnectMethod = ASR033WConnectMethod.ASR033WConnectMethod_TCP;

    public static ASR033W sharedInstance() {
        if (instance == null) {
            instance = new ASR033W();
        }
        return instance;
    }

    private ASR033W() {
        this.asr033wNetworkUDP = new ASR033WNetworkUDP();
        this.asr033wNetworkUDP.setCallBack(new ASR033WNetworkUDPCallBack(){

            @Override
            public void onSearchingUDPReceiveInformation(HashMap<String, String> dictionary, boolean isFinish) {
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.searchingIP(ASR033W.this, dictionary, isFinish);
                }
            }

            @Override
            public void onReceivedUDPSearchError(ASR033WErrorModel errorModel) {
            }
        });
        this.asr033wReaderInfo = ASR033WReaderInfo.getInstance();
        this.asr033wNetworkTCP = new ASR033WNetworkTCP();
        this.asr033wNetworkTCP.setASR033WNetworkTCPCallBack(new ASR033WNetworkTCPCallBack(){

            @Override
            public void onTCPDisconnect() {
                ASR033W.this.isConnect = false;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateDisconnected, null);
                }
            }

            @Override
            public void onTCPConnected() {
                ASR033W.this.isConnect = true;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateConnected, null);
                }
            }

            @Override
            public void onTCPReceive(byte[] data) {
                ASR033W.this.asr033wProtocol.receiveData(data);
            }

            @Override
            public void onTCPErrorReceive(Exception e) {
                ASR033W.this.isConnect = false;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateError, new Error(e.getMessage()));
                }
            }
        });
        this.asr033WNetworkMQTT = new ASR033WNetworkMQTT();
        this.asr033WNetworkMQTT.setASR033WNetworkMQTTCallBack(new ASR033WNetworkMQTTCallBack(){

            @Override
            public void onMQTTDisconnect() {
                ASR033W.this.isConnect = false;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateDisconnected, null);
                }
            }

            @Override
            public void onMQTTConnected() {
                ASR033W.this.isConnect = true;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateConnected, null);
                }
            }

            @Override
            public void onMQTTReceive(byte[] data) {
                ASR033W.this.asr033wProtocol.receiveData(data);
            }

            @Override
            public void onMQTTErrorReceive(Exception e) {
                ASR033W.this.isConnect = false;
                if (ASR033W.this.callBack != null) {
                    ASR033W.this.callBack.changeNetworkState(ASR033W.this, ASR033WNetworkState.ASR033WNetworkStateError, new Error(e.getMessage()));
                }
            }
        });
        this.asr033wProtocol = new ASR033WProtocol(this.asr033wNetworkTCP, this.asr033WNetworkMQTT);
    }

    public void setCallBack(ASR033WCallBack callBack) {
        this.callBack = callBack;
        this.asr033wProtocol.setCallBack(callBack);
    }

    public boolean getCurrentConnect() {
        return this.isConnect;
    }

    public ASR033WConnectMethod getASR033WConnectMethod() {
        return this.currentConnectMethod;
    }

    public void setASR033WConnectMethod(ASR033WConnectMethod connectMethod) {
        this.currentConnectMethod = connectMethod;
        this.asr033wProtocol.setASR033WConnectMethod(connectMethod);
    }

    public String getSDKVersion() {
        return "1.0.0";
    }

    public void startSearchDevice() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            this.asr033wNetworkTCP.disconnect();
        } else {
            this.asr033WNetworkMQTT.disconnect();
        }
        this.asr033wNetworkUDP.searchDevice();
    }

    public void stopSearchDevice() {
        this.asr033wNetworkUDP.stopSearch();
    }

    public void setSearchDeviceTimeout(int searchTimeout) {
        if (searchTimeout < 10) {
            searchTimeout = 10;
        }
        if (searchTimeout > 60) {
            searchTimeout = 60;
        }
        this.asr033wReaderInfo.searchTimeout = searchTimeout;
    }

    public void connectServerWithIP(String IP, int port) {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            this.asr033wNetworkTCP.connect(IP, port);
        } else {
            this.asr033WNetworkMQTT.connect(IP, port);
        }
    }

    public void disconnectServer() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            this.asr033wNetworkTCP.disconnect();
        } else {
            this.asr033WNetworkMQTT.disconnect();
        }
    }

    public void startReceiveRFIDData() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            byte[] param = new byte[]{-64, 0, 0, 0, 0, 1};
            this.sendData(param);
        } else {
            this.asr033WNetworkMQTT.subscribe(this.asr033WNetworkMQTT.rfidTopic);
        }
    }

    public void stopReceiveRFIDData() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            byte[] param = new byte[]{-64, 0, 0, 0, 0, 2};
            this.sendData(param);
        } else {
            this.asr033WNetworkMQTT.unsubscribe(this.asr033WNetworkMQTT.rfidTopic);
        }
    }

    public void startReceiveHIDData() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            byte[] param = new byte[]{-64, 0, 0, 0, 0, 3};
            this.sendData(param);
        } else {
            this.asr033WNetworkMQTT.subscribe(this.asr033WNetworkMQTT.hidTopic);
        }
    }

    public void stopReceiveHIDData() {
        if (ASR033WConnectMethod.ASR033WConnectMethod_TCP == this.currentConnectMethod) {
            byte[] param = new byte[]{-64, 0, 0, 0, 0, 4};
            this.sendData(param);
        } else {
            this.asr033WNetworkMQTT.unsubscribe(this.asr033WNetworkMQTT.hidTopic);
        }
    }

    public ASR033WResultCode regionName() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getRegionName();
        return resultCode;
    }

    public ASR033WResultCode serialNumber() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getSerialNumber();
        return resultCode;
    }

    public ASR033WResultCode hardwareVersion() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getHardwareVersion();
        return resultCode;
    }

    public ASR033WResultCode rFModuleVersion() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getRFModuleVersion();
        return resultCode;
    }

    public ASR033WResultCode firmwareVersion() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getFirmwareVersion();
        return resultCode;
    }

    public ASR033WResultCode macAddress() {
        ASR033WResultCode resultCode = this.asr033wProtocol.getMacAddress();
        return resultCode;
    }

    public ASR033WResultCode startInventoryAntenna1(boolean antenna1, boolean antenna2, boolean antenna3, boolean antenna4, boolean antenna5, boolean antenna6, boolean antenna7, boolean antenna8, boolean tid) {
        Log.d((String)"ASR033W", (String)"startInventoryAntenna1");
        byte[] param = new byte[]{11, 1, 0, 0, 0, 0, 0};
        param[0] = tid ? -80 : -64;
        param[1] = 1;
        int ant = (antenna1 ? 1 : 0) + (antenna2 ? 1 : 0) * 2 + (antenna3 ? 1 : 0) * 4 + (antenna4 ? 1 : 0) * 8 + (antenna5 ? 1 : 0) * 16 + (antenna6 ? 1 : 0) * 32 + (antenna7 ? 1 : 0) * 64 + (antenna8 ? 1 : 0) * 128 & 0xFF;
        param[2] = (byte)ant;
        ASR033WResultCode resultCode = this.asr033wProtocol.startInventoryAntenna1(param);
        return resultCode;
    }

    public ASR033WResultCode stopInventory() {
        Log.d((String)"ASR033W", (String)"stopInventory");
        ASR033WResultCode resultCode = this.asr033wProtocol.stopInventory();
        return resultCode;
    }

    public ASR033WResultCode sendData(byte[] data) {
        Log.d((String)"ASR033W", (String)"sendData");
        ASR033WResultCode resultCode = this.asr033wProtocol.sendData(data);
        return resultCode;
    }

    public String getMessageWithResultCode(ASR033WResultCode resultCode) {
        Log.d((String)"ASR033W", (String)"getMessageWithResultCode");
        switch (resultCode) {
            case ASR033WResultNoError: {
                return "No Error";
            }
            case ASR033WResultOtherError: {
                return "Other Error";
            }
            case ASR033WResultUndefined: {
                return "Undefined";
            }
            case ASR033WResultMemoryOverrun: {
                return "Memory Overrun";
            }
            case ASR033WResultMemoryLocked: {
                return "Memory Locked";
            }
            case ASR033WResultInsufficientPower: {
                return "Insufficient Power";
            }
            case ASR033WResultNotConnected: {
                return "Disconnected";
            }
            case ASR033WResultInvalidParameter: {
                return "Invalid parameter";
            }
            case ASR033WResultTimeout: {
                return "Timeout";
            }
            case ASR033WResultCommandFormatError: {
                return "Command format error";
            }
            case ASR033WResultOutOfRetries: {
                return "Out of retries";
            }
            case ASR033WResultReadAntennaPortParameterError: {
                return "Read antenna port parameter error";
            }
            case ASR033WResultReadReadParameterError: {
                return "Read read parameter error";
            }
            case ASR033WResultReadTidReadingParameterError: {
                return "Read tid reading parameter error";
            }
            case ASR033WResultReadUserDataAreaParameterError: {
                return "Read user data area parameter error";
            }
            case ASR033WResultReadReservedAreaParameterError: {
                return "Read reserved area parameter error";
            }
            case ASR033WResultReadOtherParameterError: {
                return "Read other parameter error";
            }
            case ASR033WResultWriteAntennaPortParameterError: {
                return "Write antenna port parameter error";
            }
            case ASR033WResultWriteSelectionParameterError: {
                return "Write selection parameter error";
            }
            case ASR033WResultWriteWritingParameterError: {
                return "Write writing parameter error";
            }
            case ASR033WResultWriteCRCCheckError: {
                return "Write CRC error on tag response";
            }
            case ASR033WResultWriteInsufficientPower: {
                return "Write insufficient power";
            }
            case ASR033WResultWriteMemoryOverrun: {
                return "Write memory overrun";
            }
            case ASR033WResultWriteMemoryLocked: {
                return "Write Memory locked";
            }
            case ASR033WResultWriteIncorrectAccessPassword: {
                return "Write incorrect access password";
            }
            case ASR033WResultWriteOtherLabelError: {
                return "Write other label error";
            }
            case ASR033WResultWriteLabelLoss: {
                return "Write label loss";
            }
            case ASR033WResultWriteSendingInstructionError: {
                return "Write sending instruction error";
            }
            case ASR033WResultLockAntennaPortParameterError: {
                return "Lock antenna port parameter error";
            }
            case ASR033WResultLockSelectionParameterError: {
                return "Lock selection parameter error";
            }
            case ASR033WResultLockLockingParameterError: {
                return "Lock locking parameter error";
            }
            case ASR033WResultLockCRCCheckError: {
                return "Lock CRC error on tag response";
            }
            case ASR033WResultLockInsufficientPower: {
                return "Lock insufficient power";
            }
            case ASR033WResultLockMemoryOverrun: {
                return "Lock memory overrun";
            }
            case ASR033WResultLockMemoryLocked: {
                return "Lock memory locked";
            }
            case ASR033WResultLockIncorrectAccessPassword: {
                return "Lock incorrect access password";
            }
            case ASR033WResultLockOtherLabelError: {
                return "Lock other label error";
            }
            case ASR033WResultLockLabelLoss: {
                return "Lock label loss";
            }
            case ASR033WResultLockSendingInstructionError: {
                return "Lock sending instruction error";
            }
            case ASR033WResultKillAntennaPortParameterError: {
                return "Kill antenna port parameter error";
            }
            case ASR033WResultKillSelectionParameterError: {
                return "Kill selection parameter error";
            }
            case ASR033WResultKillCRCCheckError: {
                return "Kill CRC error on tag response";
            }
            case ASR033WResultKillInsufficientPower: {
                return "Kill insufficient power";
            }
            case ASR033WResultKillIncorrectAccessPassword: {
                return "Kill incorrect access password";
            }
            case ASR033WResultKillOtherLabelError: {
                return "Kill other label error";
            }
            case ASR033WResultKillLabelLoss: {
                return "Kill label loss";
            }
            case ASR033WResultKillSendingInstructionError: {
                return "Kill sending instruction error";
            }
        }
        return "Unknown Error";
    }
}

