/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.util;

public class ASR033WByteQueue {
    private static final String TAG = ASR033WByteQueue.class.getSimpleName();
    private static final int DEFAULT_QUEUE_SIZE = 8192;
    private byte[] mData = new byte[8192];
    private int mFront = 0;
    private int mTail = 0;

    public synchronized int getSize() {
        return this.mData.length;
    }

    public synchronized int getFront() {
        return this.mFront;
    }

    public synchronized int getTail() {
        return this.mTail;
    }

    public synchronized int getCount() {
        return this.getCount(this.mFront, this.mTail);
    }

    public synchronized int getCount(int start, int end) {
        return start <= end ? end - start : this.mData.length + end - start;
    }

    public synchronized int getRemainSize() {
        return this.mData.length - this.getCount();
    }

    public int next(int pos) {
        return pos % this.mData.length;
    }

    public synchronized boolean isRange(int pos) {
        return this.mFront <= this.mTail ? this.mFront <= pos && pos < this.mTail : 0 <= pos && pos < this.mTail || this.mFront <= pos && pos < this.mData.length;
    }

    public synchronized boolean isLength(int pos) {
        return this.mFront <= this.mTail ? this.mFront < pos && pos <= this.mTail : 0 <= pos && pos <= this.mTail || this.mFront < pos && pos < this.mData.length;
    }

    public synchronized void enqueue(byte[] data) {
        this.enqueue(data, 0, data.length);
    }

    public synchronized void enqueue(byte[] data, int offset, int length) {
        if (this.getRemainSize() < length) {
            this.resize(length);
        }
        int pos = this.mTail + length;
        if (this.mFront <= this.mTail) {
            if (pos < this.getSize()) {
                System.arraycopy(data, offset, this.mData, this.mTail, length);
            } else {
                int copyLen = this.mData.length - this.mTail;
                System.arraycopy(data, offset, this.mData, this.mTail, copyLen);
                System.arraycopy(data, offset + copyLen, this.mData, 0, length - copyLen);
            }
        } else {
            System.arraycopy(data, offset, this.mData, this.mTail, length);
        }
        this.mTail = (this.mTail + length) % this.mData.length;
    }

    public synchronized byte[] dequeue(int end) {
        return this.dequeue(this.mFront, end);
    }

    public synchronized byte[] dequeue(int start, int end) {
        if (!this.isRange(start)) {
            return null;
        }
        if (!this.isLength(end)) {
            return null;
        }
        int length = this.getCount(start, end);
        byte[] data = new byte[length];
        if (this.mFront <= this.mTail) {
            System.arraycopy(this.mData, start, data, 0, length);
        } else if (start >= this.mFront && start < this.mData.length && end >= this.mFront && end < this.mData.length) {
            System.arraycopy(this.mData, start, data, 0, length);
        } else if (start >= this.mFront && start < this.mData.length && end >= 0 && end <= this.mTail) {
            int copyLen = this.mData.length - start;
            System.arraycopy(this.mData, start, data, 0, copyLen);
            System.arraycopy(this.mData, 0, data, copyLen, data.length - copyLen);
        } else if (start >= 0 && start < this.mTail && end >= 0 && end <= this.mTail) {
            System.arraycopy(this.mData, start, data, 0, length);
        } else {
            return null;
        }
        this.mFront = (start + length) % this.mData.length;
        return data;
    }

    public synchronized boolean remove(int pos) {
        if (!this.isLength(pos)) {
            return false;
        }
        this.mFront = pos % this.mData.length;
        return true;
    }

    public synchronized void clear() {
        this.mTail = 0;
        this.mFront = 0;
    }

    public synchronized int findPattern(byte[] pattern) {
        return this.findPattern(pattern, this.mFront);
    }

    public synchronized int findPattern(byte[] pattern, int pos) {
        int refPos = -1;
        int index = -1;
        boolean isFound = false;
        while (this.isRange(pos)) {
            index = this.indexOf(this.mData, pattern[0], pos);
            if (this.isRange(index)) {
                isFound = true;
                for (int i = 0; i < pattern.length; ++i) {
                    refPos = (index + i) % this.mData.length;
                    if (refPos != this.mTail && pattern[i] == this.mData[refPos]) continue;
                    isFound = false;
                    break;
                }
                if (isFound) {
                    return index;
                }
            }
            if (this.isRange(pos = (pos + 1) % this.mData.length)) continue;
            index = -1;
            break;
        }
        return index;
    }

    public synchronized int peekFront() {
        return this.peek(this.mFront);
    }

    public synchronized int peek(int pos) {
        if (!this.isRange(pos)) {
            return 0;
        }
        return this.mData[pos] & 0xFF;
    }

    public synchronized int findByte(byte data) {
        return this.findByte(data, this.mFront);
    }

    public synchronized int findByte(byte data, int pos) {
        int index = -1;
        if (this.isRange(pos) && this.isRange(index = this.indexOf(this.mData, data, pos))) {
            return index;
        }
        return -1;
    }

    private synchronized int indexOf(byte[] array, byte data, int pos) {
        for (int i = pos; i < array.length; ++i) {
            if (array[i] != data) continue;
            return i;
        }
        return -1;
    }

    private synchronized void resize(int size) {
        byte[] newBuf = null;
        int newSize = (size / 8192 + 1) * 8192;
        int copySize = 0;
        newBuf = new byte[this.mData.length + newSize];
        if (this.mFront <= this.mTail) {
            copySize = this.mTail - this.mFront;
            if (copySize > 0) {
                System.arraycopy(this.mData, this.mFront, newBuf, this.mFront, copySize);
            }
        } else {
            System.arraycopy(this.mData, 0, newBuf, 0, this.mTail);
            System.arraycopy(this.mData, this.mFront, newBuf, this.mFront + newSize, this.mData.length - this.mFront);
            this.mFront += newSize;
        }
        this.mData = newBuf;
    }
}

