/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.network;

import com.asreader.asr033w.sdk.errormodel.ASR033WErrorCode;
import com.asreader.asr033w.sdk.errormodel.ASR033WErrorModel;
import com.asreader.asr033w.sdk.info.ASR033WReaderInfo;
import com.asreader.asr033w.sdk.network.ASR033WNetworkUDPCallBack;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ASR033WNetworkUDP {
    private String BIND_GROUP_IP = "230.1.1.169";
    private int BIND_GROUP_PORT = 8161;
    private int PACK_SIZE = 1024;
    private ASR033WNetworkUDPCallBack callBack;
    MulticastSocket socket = null;
    boolean isTimeOutCheck = true;
    int isTimeOutCheckCount = 0;

    public void setCallBack(ASR033WNetworkUDPCallBack callBack) {
        this.callBack = callBack;
    }

    public void searchDevice() {
        if (this.socket != null) {
            if (this.socket.isClosed()) {
                this.socket.close();
            }
            this.socket = null;
        }
        this.isTimeOutCheck = true;
        this.isTimeOutCheckCount = 0;
        int timeout = ASR033WReaderInfo.getInstance().searchTimeout;
        if (timeout == 0) {
            timeout = 10;
        }
        int maxTimeOut = timeout;
        new Thread(() -> {
            while (this.isTimeOutCheck) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.isTimeOutCheckCount;
                if (this.isTimeOutCheckCount <= maxTimeOut) continue;
            }
            this.finishSearchDevice();
        }).start();
        new Thread(() -> {
            try {
                this.socket = new MulticastSocket(this.BIND_GROUP_PORT);
                this.socket.setSoTimeout(20000);
                InetAddress group = InetAddress.getByName(this.BIND_GROUP_IP);
                this.socket.joinGroup(group);
                byte[] buffer = new byte[this.PACK_SIZE];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                while (true) {
                    this.socket.receive(packet);
                    String message = new String(packet.getData(), 0, packet.getLength());
                    if (message.length() == 0) continue;
                    String[] items = message.split(",");
                    HashMap<String, String> dictionary = new HashMap<String, String>();
                    for (String item : items) {
                        String[] bodyArray = item.split(":");
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(bodyArray));
                        if (arrayList.size() != 2) continue;
                        String string = arrayList.get(0);
                        if (string.contains("RFID_READER_INFORMATION")) {
                            dictionary.put("RFID_READER_INFORMATION", arrayList.get(1));
                        }
                        if (string.contains("IP")) {
                            dictionary.put("IP", arrayList.get(1));
                        }
                        if (string.contains("MASK")) {
                            dictionary.put("MASK", arrayList.get(1));
                        }
                        if (string.contains("GATEWAY")) {
                            dictionary.put("GATEWAY", arrayList.get(1));
                        }
                        if (string.contains("MAC")) {
                            dictionary.put("MAC", arrayList.get(1));
                        }
                        if (string.contains("PORT")) {
                            dictionary.put("PORT", arrayList.get(1));
                        }
                        if (string.contains("HOST_SERVER_IP")) {
                            String ipString = arrayList.get(1);
                            if (ipString.contains("\r\n")) {
                                ipString = ipString.replace("\r\n", "");
                            }
                            dictionary.put("HOST_SERVER_IP", ipString);
                        }
                        if (string.contains("HOST_SERVER_PORT")) {
                            dictionary.put("HOST_SERVER_PORT", arrayList.get(1));
                        }
                        if (string.contains("MODE")) {
                            dictionary.put("MODE", arrayList.get(1));
                        }
                        if (string.contains("NET_STATE")) {
                            dictionary.put("NET_STATE", arrayList.get(1));
                        }
                        if (!string.contains("DHCP_SW")) continue;
                        dictionary.put("DHCP_SW", arrayList.get(1));
                    }
                    if (this.callBack == null) continue;
                    this.callBack.onSearchingUDPReceiveInformation(dictionary, false);
                }
            }
            catch (Exception e) {
                ASR033WErrorModel errorModel = new ASR033WErrorModel("udp", ASR033WErrorCode.ASR033WErrorCodeNil_Instance);
                if (this.callBack != null) {
                    this.callBack.onReceivedUDPSearchError(errorModel);
                }
                return;
            }
        }).start();
    }

    private void finishSearchDevice() {
        this.stopSearch();
        if (this.callBack != null) {
            this.callBack.onSearchingUDPReceiveInformation(null, true);
        }
    }

    public void stopSearch() {
        this.isTimeOutCheck = false;
        if (this.socket != null) {
            if (this.socket.isClosed()) {
                this.socket.close();
            }
            this.socket = null;
        }
    }
}

