/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.network;

import android.util.Log;
import com.asreader.asr033w.sdk.network.ASR033WNetworkTCPCallBack;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ASR033WNetworkTCP {
    private String serverIP = "";
    private int serverPort = -1;
    private PrintWriter pw;
    private InputStream is;
    private DataInputStream dis;
    private boolean isRun = false;
    private byte[] buff = new byte[4096];
    private String rcvMsg;
    private Socket socket;
    private int rcvLen;
    private int soTimeOut = 0;
    private Runnable msgRun;
    private Runnable connRun;
    private Runnable sendMsgRun;
    private ASR033WNetworkTCPCallBack asr033WNetworkTCPCallBack;
    private int numberOfCores = Runtime.getRuntime().availableProcessors();
    private int keepAliveTime = 1;
    private BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private boolean needReConn = false;
    private int reConnTime = 10;
    public boolean isConnected = false;
    ExecutorService executorService = new ThreadPoolExecutor(this.numberOfCores, this.numberOfCores * 2, this.keepAliveTime, TimeUnit.SECONDS, this.taskQueue);

    private void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    private void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setSoTimeOut(int soTimeOut) {
        this.soTimeOut = soTimeOut;
    }

    public void setNeedReConn(boolean needReConn) {
        this.needReConn = needReConn;
    }

    public void setReConnTime(int reConnTime) {
        this.reConnTime = reConnTime;
    }

    public void setASR033WNetworkTCPCallBack(ASR033WNetworkTCPCallBack listener) {
        this.asr033WNetworkTCPCallBack = listener;
    }

    public void connect(String serverIp, int port) {
        this.setServerIP(serverIp);
        this.setServerPort(port);
        this.reconnect();
    }

    public void reconnect() {
        this.connRun = new Runnable(){

            @Override
            public void run() {
                if (ASR033WNetworkTCP.this.isRun) {
                    ASR033WNetworkTCP.this.disconnect();
                    try {
                        Thread.sleep(ASR033WNetworkTCP.this.reConnTime * 1000);
                        ASR033WNetworkTCP.this.reconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    Log.d((String)"TAG", (String)("=================run:new socket  serverIP: " + ASR033WNetworkTCP.this.serverIP + " serverPort:" + ASR033WNetworkTCP.this.serverPort));
                    ASR033WNetworkTCP.this.socket = new Socket(ASR033WNetworkTCP.this.serverIP, ASR033WNetworkTCP.this.serverPort);
                    ASR033WNetworkTCP.this.socket.setSoTimeout(ASR033WNetworkTCP.this.soTimeOut);
                    ASR033WNetworkTCP.this.pw = new PrintWriter(ASR033WNetworkTCP.this.socket.getOutputStream(), true);
                    ASR033WNetworkTCP.this.is = ASR033WNetworkTCP.this.socket.getInputStream();
                    ASR033WNetworkTCP.this.dis = new DataInputStream(ASR033WNetworkTCP.this.is);
                    ASR033WNetworkTCP.this.startListen();
                }
                catch (Exception e) {
                    Log.d((String)"TAG", (String)("============== new Socket:" + e.getMessage()));
                    if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack != null) {
                        ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPDisconnect();
                    }
                    ASR033WNetworkTCP.this.disconnect();
                    return;
                }
                ASR033WNetworkTCP.this.isConnected = true;
                if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack != null) {
                    ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPConnected();
                }
            }
        };
        this.executorService.execute(this.connRun);
    }

    private void startListen() {
        if (this.isRun) {
            return;
        }
        if (this.socket == null || this.pw == null || this.is == null) {
            return;
        }
        this.isRun = true;
        this.msgRun = new Runnable(){

            @Override
            public void run() {
                while (ASR033WNetworkTCP.this.isRun) {
                    try {
                        ASR033WNetworkTCP.this.rcvLen = ASR033WNetworkTCP.this.dis.read(ASR033WNetworkTCP.this.buff);
                        if (ASR033WNetworkTCP.this.rcvLen <= 0) continue;
                        byte[] receivedBytes = new byte[ASR033WNetworkTCP.this.rcvLen];
                        System.arraycopy(ASR033WNetworkTCP.this.buff, 0, receivedBytes, 0, ASR033WNetworkTCP.this.rcvLen);
                        if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack == null) continue;
                        ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPReceive(receivedBytes);
                    }
                    catch (Exception e) {
                        Log.d((String)"TAG", (String)("============== startListen e:" + e.getMessage()));
                        if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack != null) {
                            ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPErrorReceive(e);
                        }
                        ASR033WNetworkTCP.this.disconnect();
                    }
                }
            }
        };
        this.executorService.execute(this.msgRun);
    }

    public void sendData(final byte[] data) {
        this.sendMsgRun = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ASR033WNetworkTCP.this.socket.getOutputStream().write(data);
                        ASR033WNetworkTCP.this.socket.getOutputStream().flush();
                    }
                    catch (Exception e) {
                        if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack == null) break block2;
                        ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPErrorReceive(e);
                    }
                }
            }
        };
        this.executorService.execute(this.sendMsgRun);
    }

    public void sendData(final String msg) {
        this.sendMsgRun = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ASR033WNetworkTCP.this.pw.println(msg);
                        ASR033WNetworkTCP.this.pw.flush();
                    }
                    catch (Exception e) {
                        if (ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack == null) break block2;
                        ASR033WNetworkTCP.this.asr033WNetworkTCPCallBack.onTCPErrorReceive(e);
                    }
                }
            }
        };
        this.executorService.execute(this.sendMsgRun);
    }

    public void disconnect() {
        block2: {
            try {
                this.isRun = false;
                this.isConnected = false;
                this.pw.close();
                this.is.close();
                this.dis.close();
                this.socket.close();
            }
            catch (Exception e) {
                if (this.asr033WNetworkTCPCallBack == null) break block2;
                this.asr033WNetworkTCPCallBack.onTCPErrorReceive(e);
            }
        }
    }
}

