/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk.network;

import com.asreader.asr033w.sdk.network.ASR033WNetworkMQTTCallBack;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class ASR033WNetworkMQTT {
    private MqttClient client;
    private ASR033WNetworkMQTTCallBack asr033WNetworkMQTTCallBack;
    public String rfidTopic = "SERIAL";
    public String hidTopic = "MQTT_HID";
    private String sendTopic = "HID_RFID";
    public boolean isConnected = false;

    public void setASR033WNetworkMQTTCallBack(ASR033WNetworkMQTTCallBack listener) {
        this.asr033WNetworkMQTTCallBack = listener;
    }

    public void connect(final String ip, final int port) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        MqttConnectOptions options = new MqttConnectOptions();
                        options.setCleanSession(true);
                        String url = "tcp://" + ip + ":" + port;
                        ASR033WNetworkMQTT.this.client = new MqttClient(url, "ASR033WNetworkMQTT", (MqttClientPersistence)new MemoryPersistence());
                        ASR033WNetworkMQTT.this.client.connect(options);
                        ASR033WNetworkMQTT.this.client.setCallback(new MqttCallback(){

                            public void connectionLost(Throwable cause) {
                                ASR033WNetworkMQTT.this.isConnected = false;
                                if (ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack != null) {
                                    ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack.onMQTTDisconnect();
                                }
                            }

                            public void messageArrived(String topic, MqttMessage message) throws Exception {
                                if (ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack != null) {
                                    ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack.onMQTTReceive(message.getPayload());
                                }
                            }

                            public void deliveryComplete(IMqttDeliveryToken token) {
                            }
                        });
                        ASR033WNetworkMQTT.this.isConnected = true;
                        if (ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack != null) {
                            ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack.onMQTTConnected();
                        }
                    }
                    catch (Exception e) {
                        ASR033WNetworkMQTT.this.isConnected = false;
                        if (ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack == null) break block3;
                        ASR033WNetworkMQTT.this.asr033WNetworkMQTTCallBack.onMQTTDisconnect();
                    }
                }
            }
        }).start();
    }

    public Boolean subscribe(String topic) {
        try {
            this.client.subscribe(topic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unsubscribe(String topic) {
        try {
            this.client.unsubscribe(topic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean disconnect() {
        try {
            this.client.disconnect();
            this.isConnected = false;
            if (this.asr033WNetworkMQTTCallBack != null) {
                this.asr033WNetworkMQTTCallBack.onMQTTDisconnect();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendData(byte[] data) {
        try {
            this.client.publish(this.sendTopic, new MqttMessage(data));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

