/*
 * Decompiled with CFR 0.152.
 */
package com.asreader.asr033w.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class ASR033WDevice {
    public static final int MAX_BUFFER_SIZE = 12288;
    public static final int MAX_STREAM_SIZE = 16384;
    protected static String TAG = ASR033WDevice.class.getSimpleName();
    protected PipedOutputStream mWriter = null;
    protected PipedInputStream mReader = null;
    protected boolean mIsConnectComplete = false;
    protected boolean DEBUG = false;

    public abstract void destroy();

    public abstract String getName();

    public abstract String getAddress();

    public abstract void setAddress(String var1);

    public abstract void connect(String var1);

    public abstract void waitConnection();

    public abstract void listen();

    public abstract void disconnect();

    public abstract void disconnect(boolean var1);

    public abstract void write(byte[] var1) throws Exception;

    public InputStream getReader() {
        return this.mReader;
    }

    protected boolean createStream() {
        try {
            this.mWriter = new PipedOutputStream();
            this.mReader = new PipedInputStream(this.mWriter, 16384);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void destroyStream() {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWriter = null;
        }
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mReader = null;
        }
    }
}

