#import <Foundation/Foundation.h>
// Declare Packet Type Codes
typedef enum {
    ASR033WPacketResSetProperty  = 0x57,        // 'W'
    ASR033WPacketResGetProperty  = 0x52,        // 'R'
    ASR033WPacketCommandAck      = 0x41,        // 'A'
    ASR033WPacketEvent           = 0x65,        // 'e'
    ASR033WPacketHID             = 0xAA,         
} ASR033WPacketType;

// Declare Property Type Codes
typedef enum {
    ASR033WPropertyBuzzer                = 0x62,    // 'b'
    ASR033WPropertyContinuousMode        = 0x63,    // 'c'
    ASR033WPropertyHardwareVersion       = 0x48,    // 'H'
    ASR033WPropertyPowerGain             = 0x70,    // 'p'
    ASR033WPropertyPowerGainRange        = 0x61,    // 'a'
    ASR033WPropertyRegion                = 0x67,    // 'g'
    ASR033WPropertyOperationTime         = 0x69,    // 'i'
    ASR033WPropertyInventoryTime         = 0x32,    // '2'
    ASR033WPropertyIdleTime              = 0x30,    // '0'
    ASR033WPropertyAutoOffTime           = 0x74,    // 't'
    ASR033WPropertyAccessPassword        = 0x77,    // 'w'
    ASR033WPropertyInventorySession      = 0x73,    // 's'
    ASR033WPropertySessionFlag           = 0x66,    // 'f'
    ASR033WPropertyMacAddress            = 0x4D,    // 'M'
    ASR033WPropertyFirmwareVersion       = 0x76,    // 'V'
    ASR033WPropertyUHFVersion            = 0x6b,    // 'k'
    ASR033WPropertyBatteryStatus         = 0x65,    // 'e'
    ASR033WPropertySerialNo              = 0x53,    // 'S'
    ASR033WPropertyEpcMask               = 0x64,    // 'd'
    ASR033WPropertyEpcMaskData           = 0x44,    // 'D'
    ASR033WPropertyLBT                   = 0x4C,    // 'L'
    ASR033WPropertyLBTMask               = 0x39,    // '9'
    ASR033WPropertyQValue                = 0x51,    // 'Q'
    ASR033WPropertyLinkProfile           = 0x34,    // '4'
    ASR033WPropertySleepTime             = 0x79,    // 'y'
    ASR033WPropertyBarcodeTimeOut        = 0x40,    // '@'
    ASR033WPropertyBaudRateList          = 0x49,    // 'I'
    ASR033WPropertyBaudRate              = 0x6D,    // 'm'
    ASR033WPropertyGetTemperature        = 0x54,    // 'T'
    ASR033WPropertySetTemperature        = 0x41,    // 'A'
    ASR033WPropertySetIPStatus           = 0x4E,    // 'N'
} ASR033WPropertyType;

// Declare Sub Command Type Codes
typedef enum {
    ASR033WCommandInventory       = 0x66,    		// 'f'
    ASR033WCommandReadMemory      = 0x72,    		// 'r'
    ASR033WCommandWriteMemory     = 0x77,         // 'w'
    ASR033WCommandKill            = 0x6B,    		// 'k'
    ASR033WCommandLock            = 0x6C,    		// 'l'
    ASR033WCommandUnlock          = 0x6D,   	    // 'm'
    ASR033WCommandPermaLock       = 0x70,         // 'p'
    ASR033WCommandStop            = 0x73,    		// 's'
} ASR033WCommandType;

// Declare Event Type Codes
typedef enum {
    ASR033WEventTagValue      = 0x54,           // 'T'
    ASR033WEventAccessResult  = 0x41,           // 'A'
    ASR033WEventReaderValue   = 0x52,           // 'R'
    ASR033WEventHTTagValue    = 0x48,           // 'U'
} ASR033WEventType;
 
@interface ASR033WPacket : NSObject

@property (nonatomic) NSInteger errorCode;
@property (strong, nonatomic) NSData *data;

- (id)initWithPacketType:(ASR033WPacketType)type subType:(uint8_t)subType;
- (ASR033WPacketType)type;
- (uint8_t)subType;
- (void)signal;
- (void)wait;
- (BOOL)equalPacket:(ASR033WPacketType)type subType:(uint8_t)subType;
- (BOOL)checkTimeoutInterval:(int)interval withTimeout:(int)maxTimeout;

@end

@interface ASR033WPacketManager : NSObject

- (void)addPacket:(ASR033WPacket *)packet;
- (ASR033WPacket *)waitPacket:(ASR033WPacketType)type subType:(uint8_t)subType;
- (ASR033WPacket *)findPacket:(ASR033WPacketType)type subType:(uint8_t)subType;
- (ASR033WPacket *)firstPacket;
- (void)removePacket:(ASR033WPacket *)packet;
- (BOOL)isWaitPacket;

@end
