#import <Foundation/Foundation.h>
#import <CFNetwork/CFNetwork.h>

@protocol ASR033WNetworkTCPDelegate <NSObject>
- (void)onTCPReceive:(NSData *)data;
- (void)onTCPDisconnect;
- (void)onTCPConnected;
- (void)onTCPErrorReceive:(NSError *)error;
@end

@interface ASR033WNetworkTCP : NSObject<NSStreamDelegate>

@property (nonatomic,assign) BOOL isConnected;
@property (atomic, retain) id <ASR033WNetworkTCPDelegate> delegate;

- (void) connect:(NSString*)ip port:(int)remoteport;
- (void) reconnect;
- (void) disconnect;
- (void) sendData:(NSData *)data;
@end

