#import <Foundation/Foundation.h>
#import "ASR033WProtocol.h"
#import "ASR033WDefine.h"
@class ASR033WPrinter;

@interface ASR033W : NSObject

@property (nonatomic, assign, readonly)BOOL isConnected;
@property (nonatomic, strong, readonly)NSString *host;
@property (nonatomic, assign) ASR033WConnectMethod connectMethod;

+ (ASR033W *)sharedInstance;
- (ASR033WPrinter *)getASR033WPrinter;
- (void)setDelegate:(id<ASR033WDelegate>)delegate;
- (NSString *)getSDKVersion;
- (void)setSearchDeviceTimeout:(NSTimeInterval)timeout;
- (ASR033WResultCode)startSearchDevice;
- (ASR033WResultCode)stopSearchDevice;
- (ASR033WResultCode)connectServerWithIP:(NSString *)IP remoteport:(int)port;
- (ASR033WResultCode)disconnectServer;
- (BOOL)startReceiveRFIDData;
- (BOOL)stopReceiveRFIDData;
- (BOOL)startReceiveHIDData;
- (BOOL)stopReceiveHIDData;
- (ASR033WResultCode)startInventoryWithAntenna1:(BOOL)antenna1
                                       antenna2:(BOOL)antenna2
                                       antenna3:(BOOL)antenna3
                                       antenna4:(BOOL)antenna4
                                       antenna5:(BOOL)antenna5
                                       antenna6:(BOOL)antenna6
                                       antenna7:(BOOL)antenna7
                                       antenna8:(BOOL)antenna8
                                            TID:(BOOL)TID;
- (ASR033WResultCode)stopInventory;

- (NSString *)regionName;
- (NSString *)serialNumber;
- (NSString *)hardwareVersion;
- (NSString *)rFModuleVersion;
- (NSString *)firmwareVersion;
- (NSString *)macAddress;
- (NSString *)getMessageWithASR033WResultCode:(ASR033WResultCode)code;

- (ASR033WResultCode)readMemory:(ASR033WMemoryBank)bank
                         offset:(int)offset
                         length:(int)length
                            epc:(NSData *)epc
                             pc:(NSData *)pc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8;
- (ASR033WResultCode)writeMemory:(ASR033WMemoryBank)bank
                          offset:(int)offset
                          length:(int)length
                       writeData:(NSData *)writeData
                             epc:(NSData *)epc
                              cw:(BOOL)cw
                        password:(int)password
                        antenna1:(BOOL)antenna1
                        antenna2:(BOOL)antenna2
                        antenna3:(BOOL)antenna3
                        antenna4:(BOOL)antenna4
                        antenna5:(BOOL)antenna5
                        antenna6:(BOOL)antenna6
                        antenna7:(BOOL)antenna7
                        antenna8:(BOOL)antenna8;
- (ASR033WResultCode)lockMemory:(ASR033WLockBank)lockBank
                       lockType:(ASR033WLockType)lockType
                            epc:(NSData *)epc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8;
- (ASR033WResultCode)killMemory:(NSData *)epc
                       password:(int)password
                       antenna1:(BOOL)antenna1
                       antenna2:(BOOL)antenna2
                       antenna3:(BOOL)antenna3
                       antenna4:(BOOL)antenna4
                       antenna5:(BOOL)antenna5
                       antenna6:(BOOL)antenna6
                       antenna7:(BOOL)antenna7
                       antenna8:(BOOL)antenna8;

- (ASR033WResultCode)setSession:(ASR033WSessionType)session;
- (ASR033WSessionType)getSession;

- (ASR033WResultCode)setSessionFlag:(ASR033WSessionFlag)session;
- (ASR033WSessionFlag)getSessionFlag;

- (ASR033WResultCode)setLinkProfile:(int)linkProfile;
- (int)getLinkProfile;

- (ASR033WResultCode)setQValue:(int)QValue;
- (int)getQValue;

- (ASR033WResultCode)setAntenna1Power:(int)antenna1Power
                        Antenna2Power:(int)antenna2Power
                        Antenna3Power:(int)antenna3Power
                        Antenna4Power:(int)antenna4Power
                        Antenna5Power:(int)antenna5Power
                        Antenna6Power:(int)antenna6Power
                        Antenna7Power:(int)antenna7Power
                        Antenna8Power:(int)antenna8Power;
- (NSDictionary *)getAntennaPower;

- (NSDictionary *)getAntennaPowerRange;

- (ASR033WResultCode)setIdleTime:(int)time;
- (int)getIdleTime;
    
- (NSArray *)getLBT;
- (ASR033WResultCode)setLBT:(NSArray *)table;
- (NSArray *)getLBTMask;

- (ASR033WResultCode)setIPStatus:(ASR033WIPStatus)status IP:(NSString *)ip Subnet:(NSString *)subnet Gateway:(NSString *)gateway;

- (ASR033WResultCode)sendData:(NSData *)data;
@end
