//
//  ASR033WPrinter.h
//  ASR033WSDK
//
//  Created by DS.Zhang on 2019/2/20.
//  Copyright © 2019年 Robin. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "ASR033WDefine.h"
#import "ASR033WNetworkTCP.h"
#import "ASR033W.h"

@protocol ASR033WPrinterDelegate <NSObject>
@optional
- (void)ASR033WPrinterStatus:(ASR033WPrinterStatus)printerStatus;//返回打印机状态目前只有缺纸
- (void)ASR033WPrinterConnected:(BOOL)isConnected;//返回打印机连接状态
- (BOOL)retryPrintOnError;//尝试重新打印不清除数据
- (void)whenPrintSuccessed;//打印数据成功
- (void)rxRawData:(NSData *)rxRawData;//接收反馈代理
@end
@interface ASR033WPrinter : NSObject
@property(nonatomic,assign,readonly)BOOL isConnected;
@property (nonatomic, weak) id<ASR033WPrinterDelegate> printDelegate;
-(id)initWithASR033W:(ASR033W *)asr033w;
-(void)getPrinterStatus;
-(void)addPrintText:(NSString*)text
               font:(ASR033WPrintFont)font
   printerAlignment:(ASR033WPrintAlignment)printerAlignment;//添加每一行的打印数据
-(void)addPrintQRCode:(NSString*)qrCode
                 size:(ASR033WPrintQrDotSize)size
     printerAlignment:(ASR033WPrintAlignment)printerAlignment;//添加要打印QRCode数据
-(void)addPrintImage:(UIImage *)image
               width:(float)width
              height:(float)height
    printerAlignment:(ASR033WPrintAlignment)printerAlignment;//添加要打印的图片数据
-(void)addCutCommand:(ASR033WPrintCutType)cutType;//添加切纸指令
-(void)openDrawer;//打开钱箱
-(void)cleanPrintData;//清除已添加的数据
-(void)doPrint;//执行打印操作向打印机发送指令
-(void)txRawData:(NSData *)txRawData;//自定义指令添加
@end
