//
//  ASR033WNetworkMQTT.h
//
//  Created by iOS on 15.4.22.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, ASR033WNetworkMQTTSubscriptions) {
    ASR033WNetworkMQTTSubscriptions_SERIAL,
    ASR033WNetworkMQTTSubscriptions_MQTT_HID,
    ASR033WNetworkMQTTSubscriptions_CHG_STAT,
};

@protocol ASR033WNetworkMQTTDelegate <NSObject>
- (void)onMQTTReceive:(NSData *)data;
- (void)onMQTTDisconnect;
- (void)onMQTTConnected;
- (void)onMQTTErrorReceive:(NSError *)err;
@end

@interface ASR033WNetworkMQTT : NSObject
@property (nonatomic,assign) BOOL isConnected;
@property (atomic, retain) id <ASR033WNetworkMQTTDelegate> delegate;

- (BOOL)connectedWithIP:(NSString *)ip port:(int)port;
- (BOOL)disConnect;
- (void)reconnect;
- (BOOL)sendHIDORRFIDData:(NSData *)data;
- (BOOL)sendGPIOData:(NSData *)data;
- (void)subscriptions:(ASR033WNetworkMQTTSubscriptions)subscriptions status:(BOOL)status;
@end
 
