//
//  System.m
//
//  Created by mac on 2018/12/20.
//  Copyright © 2018年 zyl. All rights reserved.
//

#import "System.h"
@implementation System{
    NSUserDefaults *_userDefaults;
}
static System * _sharedSystem;
+ (System *)sharedSystem{
    if (!_sharedSystem) {
        _sharedSystem = [[System alloc] init];
    }
    return _sharedSystem;
}
- (instancetype)init
{
    self = [super init];
    if (self) {
        _userDefaults = [NSUserDefaults standardUserDefaults];
        if (![self getIsFirstUsed]) {
            [self setIsFirstUsed:@"YES"];
            [self setStopTime:@"10"];
            [self setAnt1Status:YES];
            [self setAnt2Status:YES];
            [self setAnt3Status:YES];
            [self setAnt4Status:YES];
            [self setAnt5Status:YES];
            [self setAnt6Status:YES];
            [self setAnt7Status:YES];
            [self setAnt8Status:YES];
            [self setPort:@"9600"];
            [self setConnectMethod:ConnectMethod_TCP];
            PrintTextData *textData = [[PrintTextData alloc] init];
            textData.textString = @"Welcome to AsReader 033W.";
            textData.alignmentString = @"1";
            textData.fontString = @"0";
            NSArray *array = [NSArray arrayWithObject:textData];
            [self setPrintTextData:array];
            PrintQRData *QRData = [[PrintQRData alloc] init];
            QRData.textString = @"https://asreader.com";
            QRData.alignmentString = @"1";
            QRData.fontString = @"1";
            [self setPrintQRData:QRData];
            PrintImageData *imageData = [[PrintImageData alloc] init];
            imageData.picString = @"logo";
            imageData.alignmentString = @"1";
            imageData.widthString = @"200";
            imageData.heightString = @"60";
            [self setPrintImageData:imageData];
        }
    }
    return self;
}
- (void)setIsFirstUsed:(NSString *)used{
    [_userDefaults setValue:used forKey:@"isFirstUsed"];
    [_userDefaults synchronize];
}
- (NSString *)getIsFirstUsed{
    return  [_userDefaults valueForKey:@"isFirstUsed"];
}
- (void)setIp:(NSString *)ip{
    [_userDefaults setValue:ip forKey:@"ip"];
    [_userDefaults synchronize];
}
- (NSString *)getIp{
    return [_userDefaults valueForKey:@"ip"]?:@"";
}
- (void)setPort:(NSString *)port{
    [_userDefaults setValue:port forKey:@"port"];
    [_userDefaults synchronize];
}
- (NSString *)getPort{
    return [_userDefaults valueForKey:@"port"]?:@"9600";
}
- (void)setStopTime:(NSString *)time{
    [_userDefaults setValue:time forKey:@"time"];
    [_userDefaults synchronize];
}
- (NSString *)getStopTime{
    return [_userDefaults valueForKey:@"time"]?:@"";
}
- (void)setAnt1Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant1"];
    [_userDefaults synchronize];
}
- (void)setAnt2Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant2"];
    [_userDefaults synchronize];
}
- (void)setAnt3Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant3"];
    [_userDefaults synchronize];
}
- (void)setAnt4Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant4"];
    [_userDefaults synchronize];
}
- (void)setAnt5Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant5"];
    [_userDefaults synchronize];
}
- (void)setAnt6Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant6"];
    [_userDefaults synchronize];
}
- (void)setAnt7Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant7"];
    [_userDefaults synchronize];
}
- (void)setAnt8Status:(BOOL)antStatus{
    [_userDefaults setBool:antStatus forKey:@"ant8"];
    [_userDefaults synchronize];
}
- (BOOL)getAnt1Status{
    return  [_userDefaults boolForKey:@"ant1"];
}
- (BOOL)getAnt2Status{
    return  [_userDefaults boolForKey:@"ant2"];
}
- (BOOL)getAnt3Status{
    return  [_userDefaults boolForKey:@"ant3"];
}
- (BOOL)getAnt4Status{
    return  [_userDefaults boolForKey:@"ant4"];
}
- (BOOL)getAnt5Status{
    return  [_userDefaults boolForKey:@"ant5"];
}
- (BOOL)getAnt6Status{
    return  [_userDefaults boolForKey:@"ant6"];
}
- (BOOL)getAnt7Status{
    return  [_userDefaults boolForKey:@"ant7"];
}
- (BOOL)getAnt8Status{
    return  [_userDefaults boolForKey:@"ant8"];
}
- (void)setSubscribeRFIDTopic:(BOOL)subscribe{
    [_userDefaults setBool:subscribe forKey:@"subscribe"];
    [_userDefaults synchronize];
}
- (BOOL)getSubscribeRFIDTopic{
    return [_userDefaults boolForKey:@"subscribe"];
}
- (BOOL)getHIDStatus{
    return [_userDefaults boolForKey:@"hidStatus"];
}
- (void)setHIDStatus:(BOOL)hidStatus{
    [_userDefaults setBool:hidStatus forKey:@"hidStatus"];
    [_userDefaults synchronize];
}
- (void)setTid:(BOOL)tid{
    [_userDefaults setBool:tid forKey:@"tid"];
    [_userDefaults synchronize];
}
- (BOOL)getTid{
    return [_userDefaults boolForKey:@"tid"];
}
- (void)setPrintTextData:(NSArray *)textData{
    NSData *encodeData = [NSKeyedArchiver archivedDataWithRootObject:textData];
    [_userDefaults setObject:encodeData forKey:@"textData"];
    [_userDefaults synchronize];
}
- (NSArray *)getPrintTextData{
    NSData *encodeObject = [_userDefaults objectForKey:@"textData"];
    NSMutableArray *tempTimeData = [NSKeyedUnarchiver unarchiveObjectWithData:encodeObject];
    return tempTimeData;
}
- (void)setPrintQRData:(PrintQRData *)QRData{
    NSData *encodeData = [NSKeyedArchiver archivedDataWithRootObject:QRData];
    [_userDefaults setObject:encodeData forKey:@"QRData"];
    [_userDefaults synchronize];
}
- (PrintQRData *)getPrintQRData{
    NSData *encodeObject = [_userDefaults objectForKey:@"QRData"];
    PrintQRData *printQRData = [NSKeyedUnarchiver unarchiveObjectWithData:encodeObject];
    return printQRData;
}
- (void)setPrintImageData:(PrintImageData *)imageData{
    NSData *encodeData = [NSKeyedArchiver archivedDataWithRootObject:imageData];
    [_userDefaults setObject:encodeData forKey:@"imageData"];
    [_userDefaults synchronize];
}
- (PrintImageData *)getPrintImageData{
    NSData *encodeObject = [_userDefaults objectForKey:@"imageData"];
    PrintImageData *printImageData = [NSKeyedUnarchiver unarchiveObjectWithData:encodeObject];
    return printImageData;
}
- (void)setPrintCutPaper:(NSInteger)cutPaper{
    [_userDefaults setInteger:cutPaper forKey:@"cutPaper"];
    [_userDefaults synchronize];
}
- (NSInteger)getPrintCutPaper{
    return [_userDefaults integerForKey:@"cutPaper"];
}
- (ConnectMethod)getConnectMethod{
    return [_userDefaults integerForKey:@"connectMethod"];
}
- (void)setConnectMethod:(ConnectMethod)method{
    [_userDefaults setInteger:method forKey:@"connectMethod"];
    [_userDefaults synchronize];
}
- (NSString *)getMQTTIp{
    return  [_userDefaults valueForKey:@"ipMQTT"]?:@"";
}
- (void)setMQTTIp:(NSString *)ip{
    [_userDefaults setValue:ip forKey:@"ipMQTT"];
    [_userDefaults synchronize];
}
- (NSString *)getMQTTPort{
    return  [_userDefaults valueForKey:@"portMQTT"]?:@"1883";
}
- (void)setMQTTPort:(NSString *)port{
    [_userDefaults setValue:port forKey:@"portMQTT"];
    [_userDefaults synchronize];
}
@end
