//
//  System.h
//
//  Created by mac on 2018/12/20.
//  Copyright © 2018年 zyl. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PrintTextData.h"
#import "PrintQRData.h"
#import "PrintImageData.h"

typedef NS_ENUM(NSUInteger, ConnectMethod) {
    ConnectMethod_TCP,
    ConnectMethod_MQTT,
};

@interface System : NSObject
+ (System *)sharedSystem;
- (void)setIp:(NSString *)ip;
- (NSString *)getIp;
- (void)setPort:(NSString *)port;
- (NSString *)getPort;
- (void)setStopTime:(NSString *)time;
- (NSString *)getStopTime;
- (void)setAnt1Status:(BOOL)antStatus;
- (void)setAnt2Status:(BOOL)antStatus;
- (void)setAnt3Status:(BOOL)antStatus;
- (void)setAnt4Status:(BOOL)antStatus;
- (void)setAnt5Status:(BOOL)antStatus;
- (void)setAnt6Status:(BOOL)antStatus;
- (void)setAnt7Status:(BOOL)antStatus;
- (void)setAnt8Status:(BOOL)antStatus;
- (BOOL)getAnt1Status;
- (BOOL)getAnt2Status;
- (BOOL)getAnt3Status;
- (BOOL)getAnt4Status;
- (BOOL)getAnt5Status;
- (BOOL)getAnt6Status;
- (BOOL)getAnt7Status;
- (BOOL)getAnt8Status;
- (void)setSubscribeRFIDTopic:(BOOL)subscribe;
- (BOOL)getSubscribeRFIDTopic;
- (void)setHIDStatus:(BOOL)hidStatus;
- (BOOL)getHIDStatus;
- (void)setTid:(BOOL)tid;
- (BOOL)getTid;
- (void)setPrintTextData:(NSArray *)textData;
- (NSArray *)getPrintTextData;
- (void)setPrintQRData:(PrintQRData *)QRData;
- (PrintQRData *)getPrintQRData;
- (void)setPrintImageData:(PrintImageData *)imageData;
- (PrintImageData *)getPrintImageData;
- (void)setPrintCutPaper:(NSInteger)cutPaper;
- (NSInteger)getPrintCutPaper;
- (void)setConnectMethod:(ConnectMethod)method;
- (ConnectMethod)getConnectMethod;
- (void)setMQTTIp:(NSString *)ip;
- (NSString *)getMQTTIp;
- (void)setMQTTPort:(NSString *)port;
- (NSString *)getMQTTPort;
@end
