//
//  SettingListViewController.m
//  ASR033W
//
//  Created by mac on 2020/11/20.
//

#import "SettingListViewController.h"
#import <ASR033WSDK/ASR033WSDK.h>
#import "Utils.h"
#import "RFIDSettingViewController.h"
#import "InformationViewController.h"
@interface SettingListViewController ()<ASR033WDelegate>

@end

@implementation SettingListViewController{
    ASR033W *asr033w;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    asr033w = [ASR033W sharedInstance];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:YES];
    asr033w.delegate = self;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:YES];
    asr033w.delegate = nil;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        if ([Utils CheckSubscribeRFIDTopic]) {
            UIStoryboard *mainStoryBoard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
            RFIDSettingViewController *rfidVC = [mainStoryBoard instantiateViewControllerWithIdentifier:@"RFIDSettingID"];
            [self.navigationController pushViewController:rfidVC animated:YES];
        }
    } else if (indexPath.row == 1) {
        if ([Utils CheckSubscribeRFIDTopic]) {
            UIStoryboard *mainStoryBoard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
            InformationViewController *rfidVC = [mainStoryBoard instantiateViewControllerWithIdentifier:@"InformationID"];
            [self.navigationController pushViewController:rfidVC animated:YES];
        }
    }
}
#pragma mark - ASR033WDelegate
- (void)receivedASR033WNetworkState:(ASR033WNetworkState)state error:(NSError *)error {
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        if (state != ASR033WNetworkStateConnected) {
            [self.navigationController popToRootViewControllerAnimated:YES];
        }
    }];
}
@end
